/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.service.cdi;

import be.fedict.eid.applet.service.Address;
import be.fedict.eid.applet.service.Identity;
import be.fedict.eid.applet.service.cdi.BelgianCertificate;
import be.fedict.eid.applet.service.cdi.BelgianCitizen;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.enterprise.inject.Produces;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;

public class BelgianIdentityCardProducer {
    @Produces
    public Identity createIdentity() {
        Identity identity = this.getSessionAttribute(Identity.class, "eid.identity");
        return identity;
    }

    @Produces
    public Address createAddress() {
        Address address = this.getSessionAttribute(Address.class, "eid.address");
        return address;
    }

    @Produces
    @BelgianCertificate(value=BelgianCertificate.CERTIFICATE_TYPE.AUTH)
    public X509Certificate createAuthCert() {
        X509Certificate cert = this.getSessionAttribute(X509Certificate.class, "eid.certs.authn");
        return cert;
    }

    @Produces
    @BelgianCertificate(value=BelgianCertificate.CERTIFICATE_TYPE.SIGN)
    public X509Certificate createSignCert() {
        X509Certificate cert = this.getSessionAttribute(X509Certificate.class, "eid.certs.sign");
        return cert;
    }

    @Produces
    @BelgianCertificate(value=BelgianCertificate.CERTIFICATE_TYPE.CITIZEN_CA)
    public X509Certificate createCitizenCACert() {
        X509Certificate cert = this.getSessionAttribute(X509Certificate.class, "eid.certs.ca");
        return cert;
    }

    @Produces
    @BelgianCertificate(value=BelgianCertificate.CERTIFICATE_TYPE.ROOT_CA)
    public X509Certificate createRootCACert() {
        X509Certificate cert = this.getSessionAttribute(X509Certificate.class, "eid.certs.root");
        return cert;
    }

    @Produces
    @BelgianCitizen
    public String createAuthenticatedBelgianCitizenIdentifier() {
        String userId = this.getSessionAttribute(String.class, "eid.identifier");
        return userId;
    }

    private <T> T getSessionAttribute(Class<? extends T> clazz, String attributeName) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ExternalContext externalContext = facesContext.getExternalContext();
        Map sessionMap = externalContext.getSessionMap();
        Object sessionAttribute = sessionMap.get(attributeName);
        return (T)sessionAttribute;
    }
}

