/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.service.signer.time;

import be.fedict.eid.applet.service.signer.facets.RevocationData;
import be.fedict.eid.applet.service.signer.time.TimeStampService;
import be.fedict.eid.applet.service.signer.time.TimeStampServiceValidator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.cmp.PKIFailureInfo;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.tsp.TSPAlgorithms;
import org.bouncycastle.tsp.TimeStampRequest;
import org.bouncycastle.tsp.TimeStampRequestGenerator;
import org.bouncycastle.tsp.TimeStampResponse;
import org.bouncycastle.tsp.TimeStampToken;

public class TSPTimeStampService
implements TimeStampService {
    private static final Log LOG = LogFactory.getLog(TSPTimeStampService.class);
    public static final String DEFAULT_USER_AGENT = "eID Applet Service TSP Client";
    private final String tspServiceUrl;
    private String requestPolicy;
    private final String userAgent;
    private final TimeStampServiceValidator validator;
    private String username;
    private String password;
    private String proxyHost;
    private int proxyPort;
    private String digestAlgo;
    private String digestAlgoOid;

    public TSPTimeStampService(String tspServiceUrl, TimeStampServiceValidator validator) {
        this(tspServiceUrl, validator, null, null);
    }

    public TSPTimeStampService(String tspServiceUrl, TimeStampServiceValidator validator, String requestPolicy, String userAgent) {
        if (null == tspServiceUrl) {
            throw new IllegalArgumentException("TSP service URL required");
        }
        this.tspServiceUrl = tspServiceUrl;
        if (null == validator) {
            throw new IllegalArgumentException("TSP validator required");
        }
        this.validator = validator;
        this.requestPolicy = requestPolicy;
        this.userAgent = null != userAgent ? userAgent : DEFAULT_USER_AGENT;
        this.digestAlgo = "SHA-1";
        this.digestAlgoOid = TSPAlgorithms.SHA1;
    }

    public void setRequestPolicy(String policyOid) {
        this.requestPolicy = policyOid;
    }

    public void setAuthenticationCredentials(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public void resetAuthenticationCredentials() {
        this.username = null;
        this.password = null;
    }

    public void setDigestAlgo(String digestAlgo) {
        if ("SHA-1".equals(digestAlgo)) {
            this.digestAlgoOid = TSPAlgorithms.SHA1;
        } else if ("SHA-256".equals(digestAlgo)) {
            this.digestAlgoOid = TSPAlgorithms.SHA256;
        } else if ("SHA-384".equals(digestAlgo)) {
            this.digestAlgoOid = TSPAlgorithms.SHA384;
        } else if ("SHA-512".equals(digestAlgo)) {
            this.digestAlgoOid = TSPAlgorithms.SHA512;
        } else {
            throw new IllegalArgumentException("unsupported digest algo: " + digestAlgo);
        }
        this.digestAlgo = digestAlgo;
    }

    public void setProxy(String proxyHost, int proxyPort) {
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
    }

    public void resetProxy() {
        this.proxyHost = null;
        this.proxyPort = 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] timeStamp(byte[] data, RevocationData revocationData) throws Exception {
        String aki;
        X509Certificate x509Certificate;
        void var26_29;
        MessageDigest messageDigest = MessageDigest.getInstance(this.digestAlgo);
        byte[] digest = messageDigest.digest(data);
        BigInteger nonce = new BigInteger(128, new SecureRandom());
        TimeStampRequestGenerator requestGenerator = new TimeStampRequestGenerator();
        requestGenerator.setCertReq(true);
        if (null != this.requestPolicy) {
            requestGenerator.setReqPolicy(this.requestPolicy);
        }
        TimeStampRequest request = requestGenerator.generate(this.digestAlgoOid, digest, nonce);
        byte[] encodedRequest = request.getEncoded();
        HttpClient httpClient = new HttpClient();
        if (null != this.username) {
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.username, this.password);
            httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)credentials);
        }
        if (null != this.proxyHost) {
            httpClient.getHostConfiguration().setProxy(this.proxyHost, this.proxyPort);
        }
        PostMethod postMethod = new PostMethod(this.tspServiceUrl);
        ByteArrayRequestEntity requestEntity = new ByteArrayRequestEntity(encodedRequest, "application/timestamp-query");
        postMethod.addRequestHeader("User-Agent", this.userAgent);
        postMethod.setRequestEntity((RequestEntity)requestEntity);
        int statusCode = httpClient.executeMethod((HttpMethod)postMethod);
        if (200 != statusCode) {
            LOG.error((Object)("Error contacting TSP server " + this.tspServiceUrl));
            throw new Exception("Error contacting TSP server " + this.tspServiceUrl);
        }
        Header responseContentTypeHeader = postMethod.getResponseHeader("Content-Type");
        if (null == responseContentTypeHeader) {
            throw new RuntimeException("missing Content-Type header");
        }
        String contentType = responseContentTypeHeader.getValue();
        if (!contentType.startsWith("application/timestamp-reply")) {
            LOG.debug((Object)("response content: " + postMethod.getResponseBodyAsString()));
            throw new RuntimeException("invalid Content-Type: " + contentType);
        }
        if (0L == postMethod.getResponseContentLength()) {
            throw new RuntimeException("Content-Length is zero");
        }
        InputStream inputStream = postMethod.getResponseBodyAsStream();
        TimeStampResponse timeStampResponse = new TimeStampResponse(inputStream);
        timeStampResponse.validate(request);
        if (0 != timeStampResponse.getStatus()) {
            LOG.debug((Object)("status: " + timeStampResponse.getStatus()));
            LOG.debug((Object)("status string: " + timeStampResponse.getStatusString()));
            PKIFailureInfo failInfo = timeStampResponse.getFailInfo();
            if (null != failInfo) {
                LOG.debug((Object)("fail info int value: " + failInfo.intValue()));
                if (256 == failInfo.intValue()) {
                    LOG.debug((Object)"unaccepted policy");
                }
            }
            throw new RuntimeException("timestamp response status != 0: " + timeStampResponse.getStatus());
        }
        TimeStampToken timeStampToken = timeStampResponse.getTimeStampToken();
        SignerId signerId = timeStampToken.getSID();
        BigInteger signerCertSerialNumber = signerId.getSerialNumber();
        X500Principal signerCertIssuer = signerId.getIssuer();
        LOG.debug((Object)("signer cert serial number: " + signerCertSerialNumber));
        LOG.debug((Object)("signer cert issuer: " + signerCertIssuer));
        CertStore certStore = timeStampToken.getCertificatesAndCRLs("Collection", BouncyCastleProvider.PROVIDER_NAME);
        Collection<? extends Certificate> certificates = certStore.getCertificates(null);
        X509Certificate signerCert = null;
        HashMap<String, X509Certificate> certificateMap = new HashMap<String, X509Certificate>();
        for (Certificate certificate : certificates) {
            X509Certificate x509Certificate2 = (X509Certificate)certificate;
            if (signerCertIssuer.equals(x509Certificate2.getIssuerX500Principal()) && signerCertSerialNumber.equals(x509Certificate2.getSerialNumber())) {
                signerCert = x509Certificate2;
            }
            String ski = Hex.encodeHexString((byte[])this.getSubjectKeyId(x509Certificate2));
            certificateMap.put(ski, x509Certificate2);
            LOG.debug((Object)("embedded certificate: " + x509Certificate2.getSubjectX500Principal() + "; SKI=" + ski));
        }
        if (null == signerCert) {
            throw new RuntimeException("TSP response token has no signer certificate");
        }
        LinkedList<X509Certificate> tspCertificateChain = new LinkedList<X509Certificate>();
        X509Certificate x509Certificate3 = signerCert;
        do {
            LOG.debug((Object)("adding to certificate chain: " + var26_29.getSubjectX500Principal()));
            tspCertificateChain.add((X509Certificate)var26_29);
        } while (!var26_29.getSubjectX500Principal().equals(var26_29.getIssuerX500Principal()) && null != (x509Certificate = (X509Certificate)certificateMap.get(aki = Hex.encodeHexString((byte[])this.getAuthorityKeyId((X509Certificate)var26_29)))));
        timeStampToken.validate((X509Certificate)tspCertificateChain.get(0), BouncyCastleProvider.PROVIDER_NAME);
        this.validator.validate(tspCertificateChain, revocationData);
        LOG.debug((Object)("time-stamp token time: " + timeStampToken.getTimeStampInfo().getGenTime()));
        byte[] timestamp = timeStampToken.getEncoded();
        return timestamp;
    }

    private byte[] getSubjectKeyId(X509Certificate cert) throws IOException {
        byte[] extvalue = cert.getExtensionValue(X509Extensions.SubjectKeyIdentifier.getId());
        if (extvalue == null) {
            return null;
        }
        ASN1OctetString str = ASN1OctetString.getInstance((Object)new ASN1InputStream((InputStream)new ByteArrayInputStream(extvalue)).readObject());
        SubjectKeyIdentifier keyId = SubjectKeyIdentifier.getInstance((Object)new ASN1InputStream((InputStream)new ByteArrayInputStream(str.getOctets())).readObject());
        return keyId.getKeyIdentifier();
    }

    private byte[] getAuthorityKeyId(X509Certificate cert) throws IOException {
        byte[] extvalue = cert.getExtensionValue(X509Extensions.AuthorityKeyIdentifier.getId());
        if (extvalue == null) {
            return null;
        }
        DEROctetString oct = (DEROctetString)new ASN1InputStream((InputStream)new ByteArrayInputStream(extvalue)).readObject();
        AuthorityKeyIdentifier keyId = new AuthorityKeyIdentifier((ASN1Sequence)new ASN1InputStream((InputStream)new ByteArrayInputStream(oct.getOctets())).readObject());
        return keyId.getKeyIdentifier();
    }

    static {
        if (null == Security.getProvider(BouncyCastleProvider.PROVIDER_NAME)) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

