/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.service.signer.ooxml;

import be.fedict.eid.applet.service.signer.KeyInfoKeySelector;
import be.fedict.eid.applet.service.signer.jaxb.opc.relationships.CTRelationship;
import be.fedict.eid.applet.service.signer.jaxb.opc.relationships.CTRelationships;
import be.fedict.eid.applet.service.signer.jaxb.opc.relationships.ObjectFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OPCKeySelector
extends KeyInfoKeySelector {
    private static final Log LOG = LogFactory.getLog(OPCKeySelector.class);
    private static final String DIGITAL_SIGNATURE_CERTIFICATE_REL_TYPE = "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/certificate";
    private final String signatureResourceName;
    private final URL opcUrl;
    private final Unmarshaller relationshipsUnmarshaller;
    private final CertificateFactory certificateFactory;

    public OPCKeySelector(URL opcUrl, String signatureResourceName) {
        this.opcUrl = opcUrl;
        this.signatureResourceName = signatureResourceName;
        try {
            JAXBContext relationshipsJAXBContext = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
            this.relationshipsUnmarshaller = relationshipsJAXBContext.createUnmarshaller();
        }
        catch (JAXBException e) {
            throw new RuntimeException("JAXB error: " + e.getMessage(), e);
        }
        try {
            this.certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new RuntimeException("CertificateFactory error: " + e.getMessage(), e);
        }
    }

    @Override
    public KeySelectorResult select(KeyInfo keyInfo, KeySelector.Purpose purpose, AlgorithmMethod method, XMLCryptoContext context) throws KeySelectorException {
        try {
            return super.select(keyInfo, purpose, method, context);
        }
        catch (KeySelectorException e) {
            JAXBElement signatureRelationshipsElement;
            ZipArchiveEntry zipEntry;
            ZipArchiveInputStream zipInputStream;
            LOG.debug((Object)"no key found via ds:KeyInfo key selector");
            LOG.debug((Object)("signature resource name: " + this.signatureResourceName));
            String signatureSegment = this.signatureResourceName.substring(0, this.signatureResourceName.lastIndexOf("/"));
            LOG.debug((Object)("signature segment: " + signatureSegment));
            String signatureBase = this.signatureResourceName.substring(this.signatureResourceName.lastIndexOf("/") + 1);
            LOG.debug((Object)("signature base: " + signatureBase));
            String signatureRelationshipResourceName = signatureSegment + "/_rels/" + signatureBase + ".rels";
            LOG.debug((Object)("signature relationship resource name: " + signatureRelationshipResourceName));
            try {
                zipInputStream = new ZipArchiveInputStream(this.opcUrl.openStream(), "UTF8", true, true);
            }
            catch (IOException e2) {
                throw new KeySelectorException(e2);
            }
            try {
                while (null != (zipEntry = zipInputStream.getNextZipEntry()) && !signatureRelationshipResourceName.equals(zipEntry.getName())) {
                }
            }
            catch (IOException e3) {
                throw new KeySelectorException(e3);
            }
            if (null == zipEntry) {
                LOG.warn((Object)("relationship part not present: " + signatureRelationshipResourceName));
                throw new KeySelectorException("no key found");
            }
            LOG.debug((Object)"signature relationship part found");
            try {
                signatureRelationshipsElement = (JAXBElement)this.relationshipsUnmarshaller.unmarshal((InputStream)zipInputStream);
            }
            catch (JAXBException e4) {
                throw new KeySelectorException(e4);
            }
            CTRelationships signatureRelationships = (CTRelationships)signatureRelationshipsElement.getValue();
            List<CTRelationship> signatureRelationshipList = signatureRelationships.getRelationship();
            LinkedList<String> certificateResourceNames = new LinkedList<String>();
            for (CTRelationship signatureRelationship : signatureRelationshipList) {
                if (!DIGITAL_SIGNATURE_CERTIFICATE_REL_TYPE.equals(signatureRelationship.getType())) continue;
                String certificateResourceName = signatureRelationship.getTarget().substring(1);
                certificateResourceNames.add(certificateResourceName);
            }
            X509Certificate endEntityCertificate = null;
            for (String certificateResourceName : certificateResourceNames) {
                X509Certificate certificate;
                try {
                    zipInputStream = new ZipArchiveInputStream(this.opcUrl.openStream(), "UTF8", true, true);
                }
                catch (IOException e5) {
                    throw new KeySelectorException(e5);
                }
                try {
                    while (null != (zipEntry = zipInputStream.getNextZipEntry()) && !certificateResourceName.equals(zipEntry.getName())) {
                    }
                }
                catch (IOException e6) {
                    throw new KeySelectorException(e6);
                }
                if (null == zipEntry) {
                    LOG.warn((Object)("certificate part not present: " + certificateResourceName));
                    continue;
                }
                try {
                    certificate = (X509Certificate)this.certificateFactory.generateCertificate((InputStream)zipInputStream);
                }
                catch (CertificateException e7) {
                    throw new KeySelectorException(e7);
                }
                LOG.debug((Object)("certificate subject: " + certificate.getSubjectX500Principal()));
                if (-1 != certificate.getBasicConstraints()) {
                    LOG.debug((Object)"skipping CA certificate");
                    continue;
                }
                if (null != endEntityCertificate) {
                    throw new KeySelectorException("two possible end entity certificates");
                }
                endEntityCertificate = certificate;
            }
            if (null == endEntityCertificate) {
                throw new KeySelectorException("no key found");
            }
            this.certificate = endEntityCertificate;
            return this;
        }
    }
}

