/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.service.signer.ooxml;

import be.fedict.eid.applet.service.signer.KeyInfoKeySelector;
import be.fedict.eid.applet.service.signer.jaxb.opc.contenttypes.CTDefault;
import be.fedict.eid.applet.service.signer.jaxb.opc.contenttypes.CTOverride;
import be.fedict.eid.applet.service.signer.jaxb.opc.contenttypes.CTTypes;
import be.fedict.eid.applet.service.signer.jaxb.opc.contenttypes.ObjectFactory;
import be.fedict.eid.applet.service.signer.jaxb.opc.relationships.CTRelationship;
import be.fedict.eid.applet.service.signer.jaxb.opc.relationships.CTRelationships;
import be.fedict.eid.applet.service.signer.jaxb.opc.relationships.STTargetMode;
import be.fedict.eid.applet.service.signer.ooxml.OOXMLSignatureFacet;
import be.fedict.eid.applet.service.signer.ooxml.OOXMLURIDereferencer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.Manifest;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureProperties;
import javax.xml.crypto.dsig.SignatureProperty;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class OOXMLSignatureVerifier {
    private static final Log LOG = LogFactory.getLog(OOXMLSignatureVerifier.class);
    public static final String DIGITAL_SIGNATURE_ORIGIN_REL_TYPE = "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin";
    public static final String DIGITAL_SIGNATURE_REL_TYPE = "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/signature";
    private final Unmarshaller relationshipsUnmarshaller;
    public static String[] excludedStreams = new String[]{"0x05Bagaaqy23kudbhchAaq5u2chNd", "0x06DataSpaces", "Xmlsignatures", "MsoDataStore", "0x09DRMContent", "_signatures", "_xmlsignatures", "0x05SummaryInformation", "0x05DocumentSummaryInformation"};

    public OOXMLSignatureVerifier() {
        try {
            JAXBContext relationshipsJAXBContext = JAXBContext.newInstance((Class[])new Class[]{be.fedict.eid.applet.service.signer.jaxb.opc.relationships.ObjectFactory.class});
            this.relationshipsUnmarshaller = relationshipsJAXBContext.createUnmarshaller();
        }
        catch (JAXBException e) {
            throw new RuntimeException("JAXB error: " + e.getMessage(), e);
        }
    }

    public static boolean isOOXML(URL url) throws IOException {
        ZipEntry zipEntry;
        ZipInputStream zipInputStream = new ZipInputStream(url.openStream());
        while (null != (zipEntry = zipInputStream.getNextEntry())) {
            if (!"[Content_Types].xml".equals(zipEntry.getName())) continue;
            return true;
        }
        return false;
    }

    public List<X509Certificate> getSigners(URL url) throws IOException, ParserConfigurationException, SAXException, TransformerException, MarshalException, XMLSignatureException, JAXBException {
        LinkedList<X509Certificate> signers = new LinkedList<X509Certificate>();
        List<String> signatureResourceNames = this.getSignatureResourceNames(url);
        if (signatureResourceNames.isEmpty()) {
            LOG.debug((Object)"no signature resources");
        }
        for (String signatureResourceName : signatureResourceNames) {
            Document signatureDocument = this.getSignatureDocument(url, signatureResourceName);
            if (null == signatureDocument) continue;
            NodeList signatureNodeList = signatureDocument.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
            if (0 == signatureNodeList.getLength()) {
                return null;
            }
            Node signatureNode = signatureNodeList.item(0);
            Element signedPropertiesElement = (Element)((Element)signatureNode).getElementsByTagNameNS("http://uri.etsi.org/01903/v1.3.2#", "SignedProperties").item(0);
            if (null != signedPropertiesElement) {
                signedPropertiesElement.setIdAttribute("Id", true);
            }
            KeyInfoKeySelector keySelector = new KeyInfoKeySelector();
            DOMValidateContext domValidateContext = new DOMValidateContext(keySelector, signatureNode);
            domValidateContext.setProperty("org.jcp.xml.dsig.validateManifests", Boolean.TRUE);
            OOXMLURIDereferencer dereferencer = new OOXMLURIDereferencer(url);
            domValidateContext.setURIDereferencer(dereferencer);
            XMLSignatureFactory xmlSignatureFactory = XMLSignatureFactory.getInstance();
            XMLSignature xmlSignature = xmlSignatureFactory.unmarshalXMLSignature(domValidateContext);
            boolean valid = xmlSignature.validate(domValidateContext);
            if (!valid) {
                LOG.debug((Object)"not a valid signature");
                continue;
            }
            List<XMLObject> objects = xmlSignature.getObjects();
            XMLObject idPackageObject = null;
            for (XMLObject object : objects) {
                if (!"idPackageObject".equals(object.getId())) continue;
                idPackageObject = object;
                break;
            }
            if (null == idPackageObject) {
                LOG.debug((Object)"idPackageObject ds:Object not present");
                continue;
            }
            List<XMLStructure> idPackageObjectContent = idPackageObject.getContent();
            Manifest idPackageObjectManifest = null;
            for (XMLStructure content : idPackageObjectContent) {
                if (!(content instanceof Manifest)) continue;
                idPackageObjectManifest = (Manifest)content;
                break;
            }
            if (null == idPackageObjectManifest) {
                LOG.debug((Object)"no ds:Manifest present within idPackageObject ds:Object");
                continue;
            }
            LOG.debug((Object)"ds:Manifest present within idPackageObject ds:Object");
            List<Reference> idPackageObjectReferences = idPackageObjectManifest.getReferences();
            HashSet<String> idPackageObjectReferenceUris = new HashSet<String>();
            HashSet<String> remainingIdPackageObjectReferenceUris = new HashSet<String>();
            for (Reference idPackageObjectReference : idPackageObjectReferences) {
                idPackageObjectReferenceUris.add(idPackageObjectReference.getURI());
                remainingIdPackageObjectReferenceUris.add(idPackageObjectReference.getURI());
            }
            LOG.debug((Object)("idPackageObject ds:Reference URIs: " + idPackageObjectReferenceUris));
            CTTypes contentTypes = this.getContentTypes(url);
            List<String> relsEntryNames = this.getRelsEntryNames(url);
            for (String relsEntryName : relsEntryNames) {
                LOG.debug((Object)("---- relationship entry name: " + relsEntryName));
                CTRelationships relationships = this.getRelationships(url, relsEntryName);
                List<CTRelationship> relationshipList = relationships.getRelationship();
                boolean includeRelationshipInSignature = false;
                for (CTRelationship relationship : relationshipList) {
                    String relationshipType = relationship.getType();
                    STTargetMode targetMode = relationship.getTargetMode();
                    if (null != targetMode) {
                        LOG.debug((Object)("TargetMode: " + targetMode.name()));
                        if (targetMode == STTargetMode.EXTERNAL) continue;
                    }
                    if (!OOXMLSignatureFacet.isSignedRelationship(relationshipType)) continue;
                    String relationshipTarget = relationship.getTarget();
                    String baseUri = "/" + relsEntryName.substring(0, relsEntryName.indexOf("_rels/"));
                    String streamEntry = baseUri + relationshipTarget;
                    LOG.debug((Object)("stream entry: " + streamEntry));
                    streamEntry = FilenameUtils.separatorsToUnix((String)FilenameUtils.normalize((String)streamEntry));
                    LOG.debug((Object)("normalized stream entry: " + streamEntry));
                    String contentType = this.getContentType(contentTypes, streamEntry);
                    if (relationshipType.endsWith("customXml") && !contentType.equals("inkml+xml") && !contentType.equals("text/xml")) {
                        LOG.debug((Object)("skipping customXml with content type: " + contentType));
                        continue;
                    }
                    includeRelationshipInSignature = true;
                    LOG.debug((Object)("content type: " + contentType));
                    String referenceUri = streamEntry + "?ContentType=" + contentType;
                    LOG.debug((Object)("reference URI: " + referenceUri));
                    if (!idPackageObjectReferenceUris.contains(referenceUri)) {
                        throw new RuntimeException("no reference in idPackageObject ds:Object for relationship target: " + streamEntry);
                    }
                    remainingIdPackageObjectReferenceUris.remove(referenceUri);
                }
                String relsReferenceUri = "/" + relsEntryName + "?ContentType=application/vnd.openxmlformats-package.relationships+xml";
                if (includeRelationshipInSignature && !idPackageObjectReferenceUris.contains(relsReferenceUri)) {
                    LOG.debug((Object)("missing ds:Reference for: " + relsEntryName));
                    throw new RuntimeException("missing ds:Reference for: " + relsEntryName);
                }
                remainingIdPackageObjectReferenceUris.remove(relsReferenceUri);
            }
            if (!remainingIdPackageObjectReferenceUris.isEmpty()) {
                LOG.debug((Object)("remaining idPackageObject reference URIs" + idPackageObjectReferenceUris));
                throw new RuntimeException("idPackageObject manifest contains unknown ds:References: " + remainingIdPackageObjectReferenceUris);
            }
            X509Certificate signer = keySelector.getCertificate();
            signers.add(signer);
        }
        return signers;
    }

    private String getContentType(CTTypes contentTypes, String partName) {
        List<Object> defaultOrOverrideList = contentTypes.getDefaultOrOverride();
        for (Object defaultOrOverride : defaultOrOverrideList) {
            CTOverride override;
            if (!(defaultOrOverride instanceof CTOverride) || !partName.equals((override = (CTOverride)defaultOrOverride).getPartName())) continue;
            return override.getContentType();
        }
        for (Object defaultOrOverride : defaultOrOverrideList) {
            CTDefault ctDefault;
            if (!(defaultOrOverride instanceof CTDefault) || !partName.endsWith((ctDefault = (CTDefault)defaultOrOverride).getExtension())) continue;
            return ctDefault.getContentType();
        }
        return null;
    }

    private CTRelationships getRelationships(URL url, String relationshipsEntryName) throws IOException, JAXBException {
        ZipEntry zipEntry;
        ZipInputStream zipInputStream = new ZipInputStream(url.openStream());
        ZipInputStream relationshipsInputStream = null;
        while (null != (zipEntry = zipInputStream.getNextEntry())) {
            if (!relationshipsEntryName.equals(zipEntry.getName())) continue;
            relationshipsInputStream = zipInputStream;
            break;
        }
        if (null == relationshipsInputStream) {
            return null;
        }
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{be.fedict.eid.applet.service.signer.jaxb.opc.relationships.ObjectFactory.class});
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        JAXBElement relationshipsElement = (JAXBElement)unmarshaller.unmarshal((InputStream)relationshipsInputStream);
        return (CTRelationships)relationshipsElement.getValue();
    }

    private List<String> getRelsEntryNames(URL url) throws IOException {
        ZipEntry zipEntry;
        LinkedList<String> relsEntryNames = new LinkedList<String>();
        ZipInputStream zipInputStream = new ZipInputStream(url.openStream());
        while (null != (zipEntry = zipInputStream.getNextEntry())) {
            String entryName = zipEntry.getName();
            if (!entryName.endsWith(".rels")) continue;
            relsEntryNames.add(entryName);
        }
        return relsEntryNames;
    }

    private CTTypes getContentTypes(URL url) throws IOException, ParserConfigurationException, SAXException, JAXBException {
        ZipEntry zipEntry;
        ZipInputStream zipInputStream = new ZipInputStream(url.openStream());
        ZipInputStream contentTypesInputStream = null;
        while (null != (zipEntry = zipInputStream.getNextEntry())) {
            if (!"[Content_Types].xml".equals(zipEntry.getName())) continue;
            contentTypesInputStream = zipInputStream;
            break;
        }
        if (null == contentTypesInputStream) {
            return null;
        }
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        JAXBElement contentTypesElement = (JAXBElement)unmarshaller.unmarshal((InputStream)contentTypesInputStream);
        return (CTTypes)contentTypesElement.getValue();
    }

    public Document getSignatureDocument(URL url, String signatureResourceName) throws IOException, ParserConfigurationException, SAXException {
        return this.getSignatureDocument(url.openStream(), signatureResourceName);
    }

    public Document getSignatureDocument(InputStream documentInputStream, String signatureResourceName) throws IOException, ParserConfigurationException, SAXException {
        ZipEntry zipEntry;
        ZipInputStream zipInputStream = new ZipInputStream(documentInputStream);
        while (null != (zipEntry = zipInputStream.getNextEntry())) {
            if (!signatureResourceName.equals(zipEntry.getName())) continue;
            return OOXMLSignatureFacet.loadDocument(zipInputStream);
        }
        return null;
    }

    public List<String> getSignatureResourceNames(byte[] document) throws IOException, JAXBException {
        ZipEntry zipEntry;
        LinkedList<String> signatureResourceNames = new LinkedList<String>();
        ZipInputStream zipInputStream = new ZipInputStream(new ByteArrayInputStream(document));
        while (null != (zipEntry = zipInputStream.getNextEntry()) && !"_rels/.rels".equals(zipEntry.getName())) {
        }
        if (null == zipEntry) {
            LOG.debug((Object)"no _rels/.rels relationship part present");
            return signatureResourceNames;
        }
        String dsOriginPart = null;
        JAXBElement packageRelationshipsElement = (JAXBElement)this.relationshipsUnmarshaller.unmarshal((InputStream)zipInputStream);
        CTRelationships packageRelationships = (CTRelationships)packageRelationshipsElement.getValue();
        List<CTRelationship> packageRelationshipList = packageRelationships.getRelationship();
        for (CTRelationship packageRelationship : packageRelationshipList) {
            if (!DIGITAL_SIGNATURE_ORIGIN_REL_TYPE.equals(packageRelationship.getType())) continue;
            dsOriginPart = packageRelationship.getTarget();
            break;
        }
        if (null == dsOriginPart) {
            LOG.debug((Object)"no Digital Signature Origin part present");
            return signatureResourceNames;
        }
        LOG.debug((Object)("Digital Signature Origin part: " + dsOriginPart));
        String dsOriginName = dsOriginPart.substring(dsOriginPart.lastIndexOf("/") + 1);
        LOG.debug((Object)("Digital Signature Origin base: " + dsOriginName));
        String dsOriginSegment = dsOriginPart.substring(0, dsOriginPart.lastIndexOf("/")) + "/";
        LOG.debug((Object)("Digital Signature Origin segment: " + dsOriginSegment));
        String dsOriginRels = dsOriginSegment + "_rels/" + dsOriginName + ".rels";
        LOG.debug((Object)("Digital Signature Origin relationship part: " + dsOriginRels));
        zipInputStream = new ZipInputStream(new ByteArrayInputStream(document));
        while (null != (zipEntry = zipInputStream.getNextEntry()) && !dsOriginRels.equals(zipEntry.getName())) {
        }
        if (null == zipEntry) {
            LOG.debug((Object)"no Digital Signature Origin relationship part present");
            return signatureResourceNames;
        }
        JAXBElement dsoRelationshipsElement = (JAXBElement)this.relationshipsUnmarshaller.unmarshal((InputStream)zipInputStream);
        CTRelationships dsoRelationships = (CTRelationships)dsoRelationshipsElement.getValue();
        List<CTRelationship> dsoRelationshipList = dsoRelationships.getRelationship();
        for (CTRelationship dsoRelationship : dsoRelationshipList) {
            if (!DIGITAL_SIGNATURE_REL_TYPE.equals(dsoRelationship.getType())) continue;
            String signatureResourceName = dsOriginSegment + dsoRelationship.getTarget();
            signatureResourceNames.add(signatureResourceName);
        }
        return signatureResourceNames;
    }

    public boolean isValidOOXMLSignature(XMLSignature xmlSignature, byte[] document) throws IOException, TransformerException, SAXException, ParserConfigurationException {
        if (!xmlSignature.getSignedInfo().getCanonicalizationMethod().getAlgorithm().equals("http://www.w3.org/TR/2001/REC-xml-c14n-20010315")) {
            LOG.error((Object)"Invalid c18n method on OOXML Signature");
            return false;
        }
        List<Reference> refs = xmlSignature.getSignedInfo().getReferences();
        Reference idPackageObjectRef = this.findReferenceFromURI(refs, "#idPackageObject");
        if (null == idPackageObjectRef) {
            LOG.error((Object)"No \"idPackageObject\" reference found!");
            return false;
        }
        XMLObject idPackageObject = this.findObject(xmlSignature, "idPackageObject");
        if (null == idPackageObject) {
            LOG.error((Object)"No \"idPackageObject\" object found!");
            return false;
        }
        if (!this.isIdPackageObjectValid(xmlSignature.getId(), idPackageObject, document)) {
            LOG.error((Object)"Invalid \"idPackageObject\".");
            return false;
        }
        Reference idOfficeObjectRef = this.findReferenceFromURI(refs, "#idOfficeObject");
        if (null == idOfficeObjectRef) {
            LOG.error((Object)"No \"idOfficeObject\" reference found!");
            return false;
        }
        XMLObject idOfficeObject = this.findObject(xmlSignature, "idOfficeObject");
        if (null == idOfficeObject) {
            LOG.error((Object)"No \"idOfficeObject\" object found!");
            return false;
        }
        if (!this.isIdOfficeObjectValid(xmlSignature.getId(), idOfficeObject)) {
            LOG.error((Object)"Invalid \"idOfficeObject\".");
            return false;
        }
        return true;
    }

    private boolean isIdOfficeObjectValid(String signatureId, XMLObject idOfficeObject) {
        if (1 != idOfficeObject.getContent().size()) {
            LOG.error((Object)"Expect SignatureProperties element in \"idPackageObject\".");
            return false;
        }
        SignatureProperties signatureProperties = (SignatureProperties)idOfficeObject.getContent().get(0);
        if (signatureProperties.getProperties().size() != 1) {
            LOG.error((Object)"Unexpected # of SignatureProperty's in idOfficeObject");
            return false;
        }
        SignatureProperty signatureInfoProperty = signatureProperties.getProperties().get(0);
        if (!signatureInfoProperty.getId().equals("idOfficeV1Details")) {
            LOG.error((Object)("Unexpected SignatureProperty: expected id=idOfficeV1Details but got: " + signatureInfoProperty.getId()));
            return false;
        }
        if (!signatureInfoProperty.getTarget().equals("#" + signatureId)) {
            LOG.error((Object)("Unexpected SignatureProperty: expected target=#" + signatureId + " but got: " + signatureInfoProperty.getTarget()));
            LOG.warn((Object)"Allowing this error because of a bug in Office2010");
        }
        if (signatureInfoProperty.getContent().size() != 1) {
            LOG.error((Object)"Unexpected content in SignatureInfoProperty.");
            return false;
        }
        DOMStructure signatureInfoV1DOM = (DOMStructure)signatureInfoProperty.getContent().get(0);
        Node signatureInfoElement = signatureInfoV1DOM.getNode();
        if (!signatureInfoElement.getNamespaceURI().equals("http://schemas.microsoft.com/office/2006/digsig")) {
            LOG.error((Object)("Unexpected SignatureInfoProperty content: NS=" + signatureInfoElement.getNamespaceURI()));
            return false;
        }
        return true;
    }

    private boolean isIdPackageObjectValid(String signatureId, XMLObject idPackageObject, byte[] document) throws IOException, TransformerException, SAXException, ParserConfigurationException {
        ZipEntry zipEntry;
        if (2 != idPackageObject.getContent().size()) {
            LOG.error((Object)"Expect Manifest + SignatureProperties elements in \"idPackageObject\".");
            return false;
        }
        Manifest manifest = (Manifest)idPackageObject.getContent().get(0);
        SignatureProperties signatureProperties = (SignatureProperties)idPackageObject.getContent().get(1);
        List<Reference> refs = manifest.getReferences();
        ByteArrayInputStream bais = new ByteArrayInputStream(document);
        ZipInputStream zipInputStream = new ZipInputStream(bais);
        while (null != (zipEntry = zipInputStream.getNextEntry())) {
            String relationshipReferenceURI;
            if (!this.validZipEntryStream(zipEntry.getName()) || null != this.findReferenceFromURI(refs, relationshipReferenceURI = OOXMLSignatureFacet.getRelationshipReferenceURI(zipEntry.getName()))) continue;
            LOG.error((Object)("Did not find relationship ref: \"" + relationshipReferenceURI + "\""));
            if (relationshipReferenceURI.startsWith("/customXml")) continue;
            return false;
        }
        for (Map.Entry<String, String> resourceEntry : this.getResources(document).entrySet()) {
            String resourceReferenceURI = OOXMLSignatureFacet.getResourceReferenceURI(resourceEntry.getKey(), resourceEntry.getValue());
            if (null != this.findReferenceFromURI(refs, resourceReferenceURI)) continue;
            LOG.error((Object)("Did not find resource ref: \"" + resourceReferenceURI + "\""));
            return false;
        }
        if (signatureProperties.getProperties().size() != 1) {
            LOG.error((Object)"Unexpected # of SignatureProperty's in idPackageObject");
            return false;
        }
        return this.validateSignatureProperty(signatureProperties.getProperties().get(0), signatureId);
    }

    private boolean validateSignatureProperty(SignatureProperty signatureProperty, String signatureId) {
        if (!signatureProperty.getId().equals("idSignatureTime")) {
            LOG.error((Object)("Unexpected SignatureProperty: expected id=idSignatureTime but got: " + signatureProperty.getId()));
            return false;
        }
        if (!signatureProperty.getTarget().equals("#" + signatureId)) {
            LOG.error((Object)("Unexpected SignatureProperty: expected target=#" + signatureId + "but got: " + signatureProperty.getTarget()));
            return false;
        }
        List<XMLStructure> signatureTimeContent = signatureProperty.getContent();
        if (signatureTimeContent.size() != 1) {
            LOG.error((Object)"Unexpected SignatureTime content.");
            return false;
        }
        DOMStructure signatureTimeDOM = (DOMStructure)signatureTimeContent.get(0);
        Node signatureTimeElement = signatureTimeDOM.getNode();
        if (!signatureTimeElement.getNamespaceURI().equals("http://schemas.openxmlformats.org/package/2006/digital-signature")) {
            LOG.error((Object)("Invalid SignatureTime element: NS=" + signatureTimeElement.getNamespaceURI()));
            return false;
        }
        if (!signatureTimeElement.getLocalName().equals("SignatureTime")) {
            LOG.error((Object)("Invalid SignatureTime element: Name=" + signatureTimeElement.getLocalName()));
            return false;
        }
        if (signatureTimeElement.getChildNodes().getLength() != 2) {
            LOG.error((Object)("Invalid SignatureTime element: Childs=" + signatureTimeElement.getChildNodes().getLength() + ", expected 2 (Format+Value)"));
            return false;
        }
        Node formatElement = signatureTimeElement.getChildNodes().item(0);
        if (!formatElement.getNamespaceURI().equals("http://schemas.openxmlformats.org/package/2006/digital-signature")) {
            LOG.error((Object)("Invalid SignatureTime.Format element: NS=" + formatElement.getNamespaceURI()));
            return false;
        }
        if (!formatElement.getLocalName().equals("Format")) {
            LOG.error((Object)("Invalid SignatureTime.Format element: Name=" + formatElement.getLocalName()));
            return false;
        }
        Node valueElement = signatureTimeElement.getChildNodes().item(1);
        if (!valueElement.getNamespaceURI().equals("http://schemas.openxmlformats.org/package/2006/digital-signature")) {
            LOG.error((Object)("Invalid SignatureTime.Value element: NS=" + valueElement.getNamespaceURI()));
            return false;
        }
        if (!valueElement.getLocalName().equals("Value")) {
            LOG.error((Object)("Invalid SignatureTime.Value element: Name=" + valueElement.getLocalName()));
            return false;
        }
        return true;
    }

    private boolean validZipEntryStream(String zipEntryName) {
        if (!zipEntryName.endsWith(".rels")) {
            return false;
        }
        for (String excludedStream : excludedStreams) {
            if (!zipEntryName.startsWith(excludedStream + "/")) continue;
            return false;
        }
        return true;
    }

    private Map<String, String> getResources(byte[] document) throws IOException, ParserConfigurationException, SAXException, TransformerException {
        ZipEntry zipEntry;
        HashMap<String, String> signatureResources = new HashMap<String, String>();
        ByteArrayInputStream bais = new ByteArrayInputStream(document);
        ZipInputStream zipInputStream = new ZipInputStream(bais);
        while (null != (zipEntry = zipInputStream.getNextEntry())) {
            if (!"[Content_Types].xml".equals(zipEntry.getName())) continue;
            Document contentTypesDocument = OOXMLSignatureFacet.loadDocument(zipInputStream);
            Element nsElement = contentTypesDocument.createElement("ns");
            nsElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:tns", "http://schemas.openxmlformats.org/package/2006/content-types");
            for (String contentType : OOXMLSignatureFacet.contentTypes) {
                NodeList nodeList = XPathAPI.selectNodeList((Node)contentTypesDocument, (String)("/tns:Types/tns:Override[@ContentType='" + contentType + "']/@PartName"), (Node)nsElement);
                for (int nodeIdx = 0; nodeIdx < nodeList.getLength(); ++nodeIdx) {
                    String partName = nodeList.item(nodeIdx).getTextContent();
                    LOG.debug((Object)("part name: " + partName));
                    partName = partName.substring(1);
                    signatureResources.put(partName, contentType);
                }
            }
        }
        return signatureResources;
    }

    private XMLObject findObject(XMLSignature xmlSignature, String objectId) {
        List<XMLObject> objects = xmlSignature.getObjects();
        for (XMLObject object : objects) {
            if (!objectId.equals(object.getId())) continue;
            LOG.debug((Object)("Found \"" + objectId + "\" ds:object"));
            return object;
        }
        return null;
    }

    private Reference findReferenceFromURI(List<Reference> refs, String referenceURI) {
        for (Reference ref : refs) {
            if (!ref.getURI().equals(referenceURI)) continue;
            LOG.debug((Object)("Found \"" + referenceURI + "\" ds:reference"));
            return ref;
        }
        return null;
    }

    public List<String> getSignatureResourceNames(URL url) throws IOException, ParserConfigurationException, SAXException, TransformerException, JAXBException {
        byte[] document = IOUtils.toByteArray((InputStream)url.openStream());
        return this.getSignatureResourceNames(document);
    }
}

