/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.service.signer.odf;

import be.fedict.eid.applet.service.signer.odf.ODFNamespaceContext;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ODFUtil {
    public static String MANIFEST_FILE = "META-INF/manifest.xml";
    public static String MIMETYPE_FILE = "mimetype";
    public static String MIMETYPE_START = "application/vnd.oasis.opendocument";
    public static String SIGNATURE_FILE = "META-INF/documentsignatures.xml";
    public static String SIGNATURE_NS = "urn:oasis:names:tc:opendocument:xmlns:digitalsignature:1.0";
    public static String SIGNATURE_ELEMENT = "document-signatures";
    private static final Log LOG = LogFactory.getLog(ODFUtil.class);

    public static Document loadDocument(InputStream documentInputStream) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder documentBuilder = ODFUtil.getNewDocumentBuilder();
        Document document = documentBuilder.parse(documentInputStream);
        return document;
    }

    public static Document getNewDocument() throws ParserConfigurationException {
        return ODFUtil.getNewDocumentBuilder().newDocument();
    }

    public static DocumentBuilder getNewDocumentBuilder() throws ParserConfigurationException {
        LOG.debug((Object)"new DOM document builder");
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        return documentBuilderFactory.newDocumentBuilder();
    }

    public static InputStream findDataInputStream(InputStream inputStream, String uri) throws IOException {
        ZipEntry zipEntry;
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        while (null != (zipEntry = zipInputStream.getNextEntry())) {
            if (!zipEntry.getName().equals(uri)) continue;
            return zipInputStream;
        }
        return null;
    }

    public static boolean isContentFile(ZipEntry zipEntry) {
        return zipEntry.getName().endsWith("content.xml");
    }

    public static boolean isSignatureFile(ZipEntry zipEntry) {
        return zipEntry.getName().equals(SIGNATURE_FILE);
    }

    public static boolean isToBeSigned(ZipEntry zipEntry) {
        String name = zipEntry.getName();
        return !zipEntry.isDirectory() && !name.equals(SIGNATURE_FILE);
    }

    public static List getZipEntriesAsList(InputStream odfInputStream) throws IOException {
        ZipEntry zipEntry;
        ArrayList<String> list = new ArrayList<String>();
        ZipInputStream odfZipInputStream = new ZipInputStream(odfInputStream);
        while (null != (zipEntry = odfZipInputStream.getNextEntry())) {
            list.add(zipEntry.getName());
        }
        return list;
    }

    public static boolean isSelfContained(URL odfUrl) throws IOException, ParserConfigurationException, SAXException, XPathExpressionException {
        ZipEntry zipEntry;
        InputStream odfInputStream = odfUrl.openStream();
        List zipEntries = ODFUtil.getZipEntriesAsList(odfInputStream);
        odfInputStream = odfUrl.openStream();
        ZipInputStream odfZipInputStream = new ZipInputStream(odfInputStream);
        XPathFactory factory = XPathFactory.newInstance();
        ODFNamespaceContext namespaceContext = new ODFNamespaceContext();
        XPath xpath = factory.newXPath();
        xpath.setNamespaceContext(namespaceContext);
        XPathExpression expression = xpath.compile("//draw:object/@xlink:href|//draw:object-ole/@xlink:href|//draw:image/@xlink:href|//draw:floating-frame/@xlink:href");
        while (null != (zipEntry = odfZipInputStream.getNextEntry())) {
            if (!ODFUtil.isContentFile(zipEntry)) continue;
            Document content = ODFUtil.loadDocument(odfZipInputStream);
            NodeList nodes = (NodeList)expression.evaluate(content, XPathConstants.NODESET);
            return ODFUtil.checkNodes(nodes, zipEntries);
        }
        return true;
    }

    public static boolean checkNodes(NodeList nodes, List zipEntries) {
        for (int i = 0; i < nodes.getLength(); ++i) {
            String url = nodes.item(i).getNodeValue();
            if ("".equals(url)) {
                LOG.debug((Object)"Skip empty xlink:href");
                continue;
            }
            if (url.startsWith("./")) {
                url = url.substring(2);
            }
            if (zipEntries.contains(url)) continue;
            LOG.debug((Object)("Not self-contained: " + url + " outside package"));
            return false;
        }
        return true;
    }
}

