/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.service.signer.odf;

import be.fedict.eid.applet.service.signer.DigestAlgo;
import be.fedict.eid.applet.service.signer.SignatureFacet;
import be.fedict.eid.applet.service.signer.odf.AbstractODFSignatureService;
import be.fedict.eid.applet.service.signer.odf.ODFUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ODFSignatureFacet
implements SignatureFacet {
    private static final Log LOG = LogFactory.getLog(ODFSignatureFacet.class);
    private final AbstractODFSignatureService signatureService;
    private final DigestAlgo digestAlgo;

    public ODFSignatureFacet(AbstractODFSignatureService signatureService, DigestAlgo digestAlgo) {
        this.signatureService = signatureService;
        this.digestAlgo = digestAlgo;
    }

    @Override
    public void postSign(Element signatureElement, List<X509Certificate> signingCertificateChain) {
    }

    @Override
    public void preSign(XMLSignatureFactory signatureFactory, Document document, String signatureId, List<X509Certificate> signingCertificateChain, List<Reference> references, List<XMLObject> objects) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        try {
            ZipEntry zipEntry;
            URL odfUrl = this.signatureService.getOpenDocumentURL();
            InputStream odfInputStream = odfUrl.openStream();
            ZipInputStream odfZipInputStream = new ZipInputStream(odfInputStream);
            DigestMethod digestMethod = signatureFactory.newDigestMethod(this.digestAlgo.getXmlAlgoId(), null);
            while (null != (zipEntry = odfZipInputStream.getNextEntry())) {
                Reference reference;
                if (!ODFUtil.isToBeSigned(zipEntry)) continue;
                String name = zipEntry.getName();
                String uri = name.replaceAll(" ", "%20");
                if (name.endsWith(".xml") && !this.isEmpty(odfZipInputStream)) {
                    LinkedList<Transform> transforms = new LinkedList<Transform>();
                    Transform transform = signatureFactory.newTransform("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", (TransformParameterSpec)null);
                    transforms.add(transform);
                    reference = signatureFactory.newReference(uri, digestMethod, transforms, null, null);
                } else {
                    reference = signatureFactory.newReference(uri, digestMethod);
                }
                references.add(reference);
                LOG.debug((Object)("entry: " + name));
            }
        }
        catch (IOException e) {
            LOG.error((Object)("IO error: " + e.getMessage()), (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)("Error: " + e.getMessage()), (Throwable)e);
        }
    }

    private boolean isEmpty(InputStream inputStream) throws IOException {
        return 0L == inputStream.skip(1L);
    }
}

