/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.service.signer.odf;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ODFEntityResolver
implements EntityResolver {
    private static final Log LOG = LogFactory.getLog(ODFEntityResolver.class);

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        LOG.debug((Object)"resolveEntity");
        LOG.debug((Object)("publicId: " + publicId));
        LOG.debug((Object)("systemId: " + systemId));
        if ("-//OpenOffice.org//DTD Modified W3C MathML 1.01//EN".equals(publicId)) {
            InputStream mathmlDtdInputStream = ODFEntityResolver.class.getResourceAsStream("/mmlents/mathml.dtd");
            InputSource inputSource = new InputSource(mathmlDtdInputStream);
            return inputSource;
        }
        if (systemId.endsWith(".ent")) {
            String filename = FilenameUtils.getBaseName((String)systemId);
            LOG.debug((Object)("ent filename: " + filename));
            InputStream entInputStream = ODFEntityResolver.class.getResourceAsStream("/mmlents/" + filename + ".ent");
            InputSource inputSource = new InputSource(entInputStream);
            return inputSource;
        }
        LOG.warn((Object)("could not resolve: " + publicId));
        return null;
    }
}

