/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.service.signer.odf;

import be.fedict.eid.applet.service.signer.odf.ApacheData;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.xml.crypto.NodeSetData;
import org.apache.xml.security.signature.NodeFilter;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ApacheNodeSetData
implements ApacheData,
NodeSetData {
    private XMLSignatureInput xi;

    public ApacheNodeSetData(XMLSignatureInput xi) {
        this.xi = xi;
    }

    @Override
    public Iterator iterator() {
        if (this.xi.getNodeFilters() != null) {
            return Collections.unmodifiableSet(this.getNodeSet(this.xi.getNodeFilters())).iterator();
        }
        try {
            return Collections.unmodifiableSet(this.xi.getNodeSet()).iterator();
        }
        catch (Exception e) {
            throw new RuntimeException("unrecoverable error retrieving nodeset", e);
        }
    }

    @Override
    public XMLSignatureInput getXMLSignatureInput() {
        return this.xi;
    }

    private Set getNodeSet(List nodeFilters) {
        if (this.xi.isNeedsToBeExpanded()) {
            XMLUtils.circumventBug2650((Document)XMLUtils.getOwnerDocument((Node)this.xi.getSubNode()));
        }
        LinkedHashSet inputSet = new LinkedHashSet();
        XMLUtils.getSet((Node)this.xi.getSubNode(), inputSet, null, (!this.xi.isExcludeComments() ? 1 : 0) != 0);
        LinkedHashSet<Node> nodeSet = new LinkedHashSet<Node>();
        for (Node currentNode : inputSet) {
            Iterator it = nodeFilters.iterator();
            boolean skipNode = false;
            while (it.hasNext() && !skipNode) {
                NodeFilter nf = (NodeFilter)it.next();
                if (nf.isNodeInclude(currentNode) == 1) continue;
                skipNode = true;
            }
            if (skipNode) continue;
            nodeSet.add(currentNode);
        }
        return nodeSet;
    }
}

