/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.service.signer.facets;

import be.fedict.eid.applet.service.signer.DigestAlgo;
import be.fedict.eid.applet.service.signer.SignatureFacet;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.LinkedList;
import java.util.List;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EnvelopedSignatureFacet
implements SignatureFacet {
    private final DigestAlgo digestAlgo;

    public EnvelopedSignatureFacet() {
        this(DigestAlgo.SHA1);
    }

    public EnvelopedSignatureFacet(DigestAlgo digestAlgorithm) {
        this.digestAlgo = digestAlgorithm;
    }

    @Override
    public void postSign(Element signatureElement, List<X509Certificate> signingCertificateChain) {
    }

    @Override
    public void preSign(XMLSignatureFactory signatureFactory, Document document, String signatureId, List<X509Certificate> signingCertificateChain, List<Reference> references, List<XMLObject> objects) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        DigestMethod digestMethod = signatureFactory.newDigestMethod(this.digestAlgo.getXmlAlgoId(), null);
        LinkedList<Transform> transforms = new LinkedList<Transform>();
        Transform envelopedTransform = signatureFactory.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null);
        transforms.add(envelopedTransform);
        Transform exclusiveTransform = signatureFactory.newTransform("http://www.w3.org/2001/10/xml-exc-c14n#", (TransformParameterSpec)null);
        transforms.add(exclusiveTransform);
        Reference reference = signatureFactory.newReference("", digestMethod, transforms, null, null);
        references.add(reference);
    }
}

