/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.service.signer.cms;

import be.fedict.eid.applet.service.signer.DummyPrivateKey;
import be.fedict.eid.applet.service.signer.SHA1WithRSAProxySignature;
import be.fedict.eid.applet.service.signer.cms.CMSProvider;
import be.fedict.eid.applet.service.spi.AddressDTO;
import be.fedict.eid.applet.service.spi.DigestInfo;
import be.fedict.eid.applet.service.spi.IdentityDTO;
import be.fedict.eid.applet.service.spi.SignatureService;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509Certificate;
import java.util.LinkedList;
import java.util.List;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;

public abstract class AbstractCMSSignatureService
implements SignatureService {
    public String getFilesDigestAlgorithm() {
        return null;
    }

    public DigestInfo preSign(List<DigestInfo> digestInfos, List<X509Certificate> signingCertificateChain, IdentityDTO identity, AddressDTO address, byte[] photo) throws NoSuchAlgorithmException {
        CMSSignedDataGenerator generator = this.createCMSSignedDataGenerator(signingCertificateChain);
        byte[] toBeSigned = this.getToBeSigned();
        CMSProcessableByteArray content = new CMSProcessableByteArray(toBeSigned);
        CMSProvider provider = new CMSProvider();
        SHA1WithRSAProxySignature.reset();
        try {
            generator.generate((CMSProcessable)content, true, (Provider)provider);
        }
        catch (CMSException e) {
            throw new RuntimeException(e);
        }
        byte[] digestValue = SHA1WithRSAProxySignature.getDigestValue();
        String description = this.getSignatureDescription();
        DigestInfo digestInfo = new DigestInfo(digestValue, "SHA1", description);
        return digestInfo;
    }

    public void postSign(byte[] signatureValue, List<X509Certificate> signingCertificateChain) {
        byte[] cmsSignature;
        CMSSignedData signedData;
        CMSSignedDataGenerator generator;
        try {
            generator = this.createCMSSignedDataGenerator(signingCertificateChain);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        byte[] toBeSigned = this.getToBeSigned();
        CMSProcessableByteArray content = new CMSProcessableByteArray(toBeSigned);
        CMSProvider provider = new CMSProvider();
        SHA1WithRSAProxySignature.reset();
        SHA1WithRSAProxySignature.setSignatureValue(signatureValue);
        try {
            signedData = generator.generate((CMSProcessable)content, true, (Provider)provider);
        }
        catch (CMSException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        try {
            cmsSignature = signedData.getEncoded();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.storeCMSSignature(cmsSignature);
    }

    private CMSSignedDataGenerator createCMSSignedDataGenerator(List<X509Certificate> signingCertificateChain) throws NoSuchAlgorithmException {
        CMSSignedDataGenerator generator = new CMSSignedDataGenerator();
        if (null != signingCertificateChain) {
            CertStore certStore;
            X509Certificate signerCertificate = signingCertificateChain.get(0);
            DummyPrivateKey dummyPrivateKey = new DummyPrivateKey();
            generator.addSigner((PrivateKey)dummyPrivateKey, signerCertificate, CMSSignedDataGenerator.DIGEST_SHA1);
            LinkedList<X509Certificate> certList = new LinkedList<X509Certificate>();
            certList.add(signerCertificate);
            try {
                certStore = CertStore.getInstance("Collection", new CollectionCertStoreParameters(certList));
            }
            catch (InvalidAlgorithmParameterException e) {
                throw new NoSuchAlgorithmException(e);
            }
            try {
                generator.addCertificatesAndCRLs(certStore);
            }
            catch (CertStoreException e) {
                throw new RuntimeException(e);
            }
            catch (CMSException e) {
                throw new RuntimeException(e);
            }
        }
        return generator;
    }

    protected abstract byte[] getToBeSigned();

    protected abstract String getSignatureDescription();

    protected abstract void storeCMSSignature(byte[] var1);
}

