/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.service.signer.asic;

import be.fedict.eid.applet.service.signer.KeyInfoKeySelector;
import be.fedict.eid.applet.service.signer.asic.ASiCURIDereferencer;
import be.fedict.eid.applet.service.signer.asic.ASiCUtil;
import be.fedict.eid.applet.service.signer.odf.ODFUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ASiCSignatureVerifier {
    private ASiCSignatureVerifier() {
    }

    public static List<X509Certificate> verifySignatures(byte[] asicDocument) throws IOException, ParserConfigurationException, SAXException, MarshalException, XMLSignatureException {
        ZipEntry zipEntry;
        ZipInputStream zipInputStream = new ZipInputStream(new ByteArrayInputStream(asicDocument));
        while (null != (zipEntry = zipInputStream.getNextEntry()) && !ASiCUtil.isSignatureZipEntry(zipEntry)) {
        }
        LinkedList<X509Certificate> signatories = new LinkedList<X509Certificate>();
        if (null == zipEntry) {
            return signatories;
        }
        Document documentSignaturesDocument = ODFUtil.loadDocument(zipInputStream);
        NodeList signatureNodeList = documentSignaturesDocument.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        for (int idx = 0; idx < signatureNodeList.getLength(); ++idx) {
            Element signatureElement = (Element)signatureNodeList.item(idx);
            Element signedPropertiesElement = (Element)signatureElement.getElementsByTagNameNS("http://uri.etsi.org/01903/v1.3.2#", "SignedProperties").item(0);
            signedPropertiesElement.setIdAttribute("Id", true);
            KeyInfoKeySelector keySelector = new KeyInfoKeySelector();
            DOMValidateContext domValidateContext = new DOMValidateContext(keySelector, (Node)signatureElement);
            ASiCURIDereferencer dereferencer = new ASiCURIDereferencer(asicDocument);
            domValidateContext.setURIDereferencer(dereferencer);
            XMLSignatureFactory xmlSignatureFactory = XMLSignatureFactory.getInstance();
            XMLSignature xmlSignature = xmlSignatureFactory.unmarshalXMLSignature(domValidateContext);
            boolean valid = xmlSignature.validate(domValidateContext);
            if (!valid) continue;
            X509Certificate signer = keySelector.getCertificate();
            signatories.add(signer);
        }
        return signatories;
    }
}

