/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.service.signer.asic;

import be.fedict.eid.applet.service.signer.asic.ASiCUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ASiCSignatureOutputStream
extends ByteArrayOutputStream {
    private static final Log LOG = LogFactory.getLog(ASiCSignatureOutputStream.class);
    private final File originalZipFile;
    private final OutputStream targetOutputStream;

    public ASiCSignatureOutputStream(File originalZipFile, OutputStream targetOutputStream) {
        this.originalZipFile = originalZipFile;
        this.targetOutputStream = targetOutputStream;
    }

    @Override
    public void close() throws IOException {
        ZipEntry zipEntry;
        super.close();
        byte[] signatureData = this.toByteArray();
        ZipOutputStream zipOutputStream = new ZipOutputStream(this.targetOutputStream);
        ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(this.originalZipFile));
        while (null != (zipEntry = zipInputStream.getNextEntry())) {
            if (zipEntry.getName().equals(ASiCUtil.SIGNATURE_FILE)) continue;
            ZipEntry newZipEntry = new ZipEntry(zipEntry.getName());
            zipOutputStream.putNextEntry(newZipEntry);
            LOG.debug((Object)("copying " + zipEntry.getName()));
            IOUtils.copy((InputStream)zipInputStream, (OutputStream)zipOutputStream);
        }
        zipInputStream.close();
        zipEntry = new ZipEntry(ASiCUtil.SIGNATURE_FILE);
        LOG.debug((Object)("writing " + zipEntry.getName()));
        zipOutputStream.putNextEntry(zipEntry);
        IOUtils.write((byte[])signatureData, (OutputStream)zipOutputStream);
        zipOutputStream.close();
    }
}

