/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.service.signer;

import java.security.Key;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class KeyInfoKeySelector
extends KeySelector
implements KeySelectorResult {
    private static final Log LOG = LogFactory.getLog(KeyInfoKeySelector.class);
    protected X509Certificate certificate;

    @Override
    public KeySelectorResult select(KeyInfo keyInfo, KeySelector.Purpose purpose, AlgorithmMethod method, XMLCryptoContext context) throws KeySelectorException {
        LOG.debug((Object)"select key");
        if (null == keyInfo) {
            throw new KeySelectorException("no ds:KeyInfo present");
        }
        List<XMLStructure> keyInfoContent = keyInfo.getContent();
        this.certificate = null;
        for (XMLStructure keyInfoStructure : keyInfoContent) {
            if (!(keyInfoStructure instanceof X509Data)) continue;
            X509Data x509Data = (X509Data)keyInfoStructure;
            List<?> x509DataList = x509Data.getContent();
            for (Object x509DataObject : x509DataList) {
                if (!(x509DataObject instanceof X509Certificate)) continue;
                X509Certificate certificate = (X509Certificate)x509DataObject;
                LOG.debug((Object)("certificate: " + certificate.getSubjectX500Principal()));
                if (null != this.certificate) continue;
                this.certificate = certificate;
                LOG.debug((Object)("signer certificate: " + certificate.getSubjectX500Principal()));
            }
            if (null == this.certificate) continue;
            return this;
        }
        throw new KeySelectorException("No key found!");
    }

    @Override
    public Key getKey() {
        return this.certificate.getPublicKey();
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }
}

