/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.service.signer;

import be.fedict.eid.applet.service.signer.TemporaryDataStorage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpSessionTemporaryDataStorage
implements TemporaryDataStorage {
    private static final Log LOG = LogFactory.getLog(HttpSessionTemporaryDataStorage.class);
    public static final String TEMP_OUTPUT_STREAM_ATTRIBUTE = HttpSessionTemporaryDataStorage.class.getName() + ".tempData";
    public static final String TEMP_ATTRIBUTES_ATTRIBUTE = HttpSessionTemporaryDataStorage.class.getName() + ".tempAttribs";

    @Override
    public InputStream getTempInputStream() {
        LOG.debug((Object)"get temp input stream");
        HttpSession httpSession = HttpSessionTemporaryDataStorage.getHttpSession();
        ByteArrayOutputStream tempOutputStream = (ByteArrayOutputStream)httpSession.getAttribute(TEMP_OUTPUT_STREAM_ATTRIBUTE);
        if (null == tempOutputStream) {
            LOG.warn((Object)"missing temp output stream");
            return null;
        }
        byte[] tempData = tempOutputStream.toByteArray();
        ByteArrayInputStream tempInputStream = new ByteArrayInputStream(tempData);
        return tempInputStream;
    }

    @Override
    public OutputStream getTempOutputStream() {
        LOG.debug((Object)"get new temp output stream");
        HttpSession httpSession = HttpSessionTemporaryDataStorage.getHttpSession();
        ByteArrayOutputStream tempOutputStream = new ByteArrayOutputStream();
        httpSession.setAttribute(TEMP_OUTPUT_STREAM_ATTRIBUTE, (Object)tempOutputStream);
        return tempOutputStream;
    }

    public static HttpSession getHttpSession() {
        HttpServletRequest httpServletRequest;
        try {
            httpServletRequest = (HttpServletRequest)PolicyContext.getContext((String)"javax.servlet.http.HttpServletRequest");
        }
        catch (PolicyContextException e) {
            throw new RuntimeException("JACC error: " + e.getMessage());
        }
        HttpSession httpSession = httpServletRequest.getSession();
        return httpSession;
    }

    private Map<String, Serializable> getAttributes() {
        HttpSession httpSession = HttpSessionTemporaryDataStorage.getHttpSession();
        HashMap<String, Serializable> attributes = (HashMap<String, Serializable>)httpSession.getAttribute(TEMP_ATTRIBUTES_ATTRIBUTE);
        if (null != attributes) {
            return attributes;
        }
        attributes = new HashMap<String, Serializable>();
        httpSession.setAttribute(TEMP_ATTRIBUTES_ATTRIBUTE, attributes);
        return attributes;
    }

    @Override
    public Serializable getAttribute(String attributeName) {
        Map<String, Serializable> attributes = this.getAttributes();
        return attributes.get(attributeName);
    }

    @Override
    public void setAttribute(String attributeName, Serializable attributeValue) {
        Map<String, Serializable> attributes = this.getAttributes();
        attributes.put(attributeName, attributeValue);
    }
}

