/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.sc;

import be.fedict.eid.applet.View;
import be.fedict.eid.applet.sc.PcscEid;
import be.fedict.eid.applet.sc.Task;

public class TaskRunner {
    private static final int TRIES = 3;
    private static final int BACKOFF_SLEEP = 2000;
    private final PcscEid pcscEidSpi;
    private final View view;

    public TaskRunner(PcscEid pcscEidSpi, View view) {
        this.pcscEidSpi = pcscEidSpi;
        this.view = view;
    }

    public <T> T run(Task<T> task) {
        for (int tries = 3; tries != 0; --tries) {
            try {
                T result = task.run();
                return result;
            }
            catch (Exception e) {
                this.addDetailMessage("task exception detected: " + e.getMessage());
                this.addDetailMessage("exception type: " + e.getClass().getName());
                Throwable cause = e.getCause();
                if (null != cause) {
                    this.addDetailMessage("exception cause: " + cause.getMessage());
                    this.addDetailMessage("exception cause type: " + cause.getClass().getName());
                }
                this.addDetailMessage("will sleep and retry...");
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e2) {
                    throw new RuntimeException("error sleeping");
                }
                this.pcscEidSpi.selectBelpicJavaCardApplet();
                continue;
            }
        }
        throw new RuntimeException("maximum tries exceeded. I give up.");
    }

    private void addDetailMessage(String detailMessage) {
        this.view.addDetailMessage(detailMessage);
    }
}

