/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.sc;

import be.fedict.eid.applet.Dialogs;
import be.fedict.eid.applet.Messages;
import be.fedict.eid.applet.Status;
import be.fedict.eid.applet.UserCancelledException;
import be.fedict.eid.applet.View;
import be.fedict.eid.applet.sc.Constants;
import be.fedict.eid.applet.sc.LibJ2PCSCGNULinuxFix;
import be.fedict.eid.applet.sc.Logger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Observable;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.smartcardio.ATR;
import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CardTerminals;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import javax.smartcardio.TerminalFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public class PcscEid
extends Observable {
    public static final int MIN_PIN_SIZE = 4;
    public static final int MAX_PIN_SIZE = 12;
    public static final int PUK_SIZE = 6;
    public static final byte AUTHN_KEY_ID = -126;
    public static final byte NON_REP_KEY_ID = -125;
    private static final byte[] ATR_PATTERN = new byte[]{59, -104, 0, 64, 0, 0, 0, 0, 1, 1, -83, 19, 16};
    private static final byte[] ATR_MASK = new byte[]{-1, -1, 0, -1, 0, 0, 0, 0, -1, -1, -1, -1, -16};
    public static final byte[] IDENTITY_FILE_ID = new byte[]{63, 0, -33, 1, 64, 49};
    public static final byte[] IDENTITY_SIGN_FILE_ID = new byte[]{63, 0, -33, 1, 64, 50};
    public static final byte[] ADDRESS_FILE_ID = new byte[]{63, 0, -33, 1, 64, 51};
    public static final byte[] ADDRESS_SIGN_FILE_ID = new byte[]{63, 0, -33, 1, 64, 52};
    public static final byte[] PHOTO_FILE_ID = new byte[]{63, 0, -33, 1, 64, 53};
    public static final byte[] AUTHN_CERT_FILE_ID = new byte[]{63, 0, -33, 0, 80, 56};
    public static final byte[] SIGN_CERT_FILE_ID = new byte[]{63, 0, -33, 0, 80, 57};
    public static final byte[] CA_CERT_FILE_ID = new byte[]{63, 0, -33, 0, 80, 58};
    public static final byte[] ROOT_CERT_FILE_ID = new byte[]{63, 0, -33, 0, 80, 59};
    public static final byte[] RRN_CERT_FILE_ID = new byte[]{63, 0, -33, 0, 80, 60};
    public static final byte[] BELPIC_AID = new byte[]{-96, 0, 0, 1, 119, 80, 75, 67, 83, 45, 49, 53};
    public static final byte[] APPLET_AID = new byte[]{-96, 0, 0, 0, 48, 41, 5, 112, 0, -83, 19, 16, 1, 1, -1};
    private final View view;
    private final TerminalFactory terminalFactory;
    private List<CardTerminal> cardTerminalList;
    private Dialogs dialogs;
    private Locale locale;
    private static final int BLOCK_SIZE = 255;
    private Card card;
    private CardChannel cardChannel;
    private CardTerminal cardTerminal;
    public static final byte FEATURE_VERIFY_PIN_START_TAG = 1;
    public static final byte FEATURE_VERIFY_PIN_FINISH_TAG = 2;
    public static final byte FEATURE_MODIFY_PIN_START_TAG = 3;
    public static final byte FEATURE_MODIFY_PIN_FINISH_TAG = 4;
    public static final byte FEATURE_GET_KEY_PRESSED_TAG = 5;
    public static final byte FEATURE_VERIFY_PIN_DIRECT_TAG = 6;
    public static final byte FEATURE_MODIFY_PIN_DIRECT_TAG = 7;
    public static final byte FEATURE_EID_PIN_PAD_READER_TAG = -128;
    private Set<String> ppduNames = new HashSet<String>();

    public PcscEid(View view, Messages messages) {
        this.view = view;
        Logger logger = new Logger(view);
        LibJ2PCSCGNULinuxFix.fixNativeLibrary(logger);
        this.terminalFactory = TerminalFactory.getDefault();
        this.dialogs = new Dialogs(this.view, messages);
        this.locale = messages.getLocale();
    }

    public void setMessages(Messages messages) {
        this.dialogs = new Dialogs(this.view, messages);
        this.locale = messages.getLocale();
    }

    public List<String> getReaderList() {
        List<CardTerminal> cardTerminalList;
        LinkedList<String> readerList = new LinkedList<String>();
        TerminalFactory factory = TerminalFactory.getDefault();
        CardTerminals cardTerminals = factory.terminals();
        try {
            cardTerminalList = cardTerminals.list();
        }
        catch (CardException e) {
            this.view.addDetailMessage("error on card terminals list: " + e.getMessage());
            this.view.addDetailMessage("no card readers connected?");
            Throwable cause = e.getCause();
            if (null != cause) {
                this.view.addDetailMessage("cause: " + cause.getMessage());
                this.view.addDetailMessage("cause type: " + cause.getClass().getName());
            }
            return readerList;
        }
        for (CardTerminal cardTerminal : cardTerminalList) {
            readerList.add(cardTerminal.getName());
        }
        return readerList;
    }

    public byte[] readFile(byte[] fileId) throws CardException, IOException {
        this.selectFile(fileId);
        byte[] data = this.readBinary();
        return data;
    }

    public void close() {
        try {
            this.card.disconnect(true);
        }
        catch (CardException e) {
            this.view.addDetailMessage("error disconnecting card: " + e.getMessage());
        }
    }

    private byte[] readBinary() throws CardException, IOException {
        CommandAPDU readBinaryApdu;
        ResponseAPDU responseApdu;
        int sw;
        int offset = 0;
        this.view.addDetailMessage("read binary");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while (27392 != (sw = (responseApdu = this.transmit(readBinaryApdu = new CommandAPDU(0, 176, offset >> 8, offset & 0xFF, 255))).getSW())) {
            if (36864 != sw) {
                throw new IOException("APDU response error: " + responseApdu.getSW());
            }
            this.setChanged();
            this.notifyObservers();
            byte[] data = responseApdu.getData();
            baos.write(data);
            offset += data.length;
            if (255 == data.length) continue;
        }
        return baos.toByteArray();
    }

    public Card getCard() {
        return this.card;
    }

    public CardChannel getCardChannel() {
        return this.cardChannel;
    }

    public boolean hasCardReader() {
        try {
            TerminalFactory factory = TerminalFactory.getDefault();
            CardTerminals cardTerminals = factory.terminals();
            List<CardTerminal> terminalList = cardTerminals.list();
            if (!terminalList.isEmpty()) {
                this.cardTerminalList = terminalList;
                return true;
            }
            return false;
        }
        catch (CardException e) {
            this.view.addDetailMessage("card terminals list error: " + e.getMessage());
            return false;
        }
    }

    public void waitForCardReader() {
        try {
            List<CardTerminal> terminalList;
            TerminalFactory terminalFactory = TerminalFactory.getDefault();
            CardTerminals terminals = terminalFactory.terminals();
            try {
                terminalList = terminals.list();
            }
            catch (CardException e) {
                terminalList = Collections.emptyList();
            }
            while (terminalList.isEmpty()) {
                this.view.addDetailMessage("no reader found yet, wait a bit...");
                Thread.sleep(2000L);
                terminals = terminalFactory.terminals();
                try {
                    terminalList = terminals.list();
                }
                catch (CardException e) {
                    terminalList = Collections.emptyList();
                }
            }
            this.cardTerminalList = terminalList;
            this.view.addDetailMessage("reader found...");
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isEidPresent() throws CardException {
        if (null == this.cardTerminalList || this.cardTerminalList.isEmpty()) {
            try {
                this.cardTerminalList = this.terminalFactory.terminals().list();
            }
            catch (CardException e) {
                this.view.addDetailMessage("card terminals list error: " + e.getMessage());
                this.view.addDetailMessage("no card readers connected?");
                Throwable cause = e.getCause();
                if (null != cause) {
                    this.view.addDetailMessage("cause: " + cause.getMessage());
                    this.view.addDetailMessage("cause type: " + cause.getClass().getName());
                    if ("SCARD_E_NO_READERS_AVAILABLE".equals(cause.getMessage())) {
                        this.view.addDetailMessage("no reader available");
                    }
                }
                return false;
            }
        }
        this.view.setStatusMessage(Status.NORMAL, Messages.MESSAGE_ID.INSERT_CARD_QUESTION);
        HashSet<CardTerminal> eIDCardTerminals = new HashSet<CardTerminal>();
        for (CardTerminal cardTerminal : this.cardTerminalList) {
            Card card;
            boolean cardPresent;
            this.view.addDetailMessage("Scanning card terminal: " + cardTerminal.getName());
            try {
                cardPresent = cardTerminal.isCardPresent();
            }
            catch (CardException e) {
                this.view.addDetailMessage("card exception: " + e.getMessage());
                cardPresent = false;
            }
            if (!cardPresent && !this.isOSX()) continue;
            try {
                card = cardTerminal.connect("T=0");
                card.beginExclusive();
            }
            catch (CardException e) {
                this.view.addDetailMessage("could not connect to card: " + e.getMessage());
                continue;
            }
            ATR atr = card.getATR();
            if (this.matchesEidAtr(atr)) {
                eIDCardTerminals.add(cardTerminal);
            } else {
                byte[] atrBytes = atr.getBytes();
                StringBuffer atrStringBuffer = new StringBuffer();
                for (byte atrByte : atrBytes) {
                    atrStringBuffer.append(Integer.toHexString(atrByte & 0xFF));
                }
                this.view.addDetailMessage("not a supported eID card. ATR= " + atrStringBuffer);
            }
            card.endExclusive();
            card.disconnect(true);
        }
        if (eIDCardTerminals.isEmpty()) {
            return false;
        }
        if (eIDCardTerminals.size() == 1) {
            this.cardTerminal = (CardTerminal)eIDCardTerminals.iterator().next();
        } else {
            try {
                this.cardTerminal = this.selectCardTerminal(eIDCardTerminals);
            }
            catch (IOException e) {
                this.view.addDetailMessage("error: " + e.getMessage());
                return false;
            }
        }
        if (null == this.cardTerminal) {
            return false;
        }
        this.view.addDetailMessage("eID card detected in card terminal : " + this.cardTerminal.getName());
        this.card = this.cardTerminal.connect("T=0");
        this.card.beginExclusive();
        this.cardChannel = this.card.getBasicChannel();
        return true;
    }

    private CardTerminal selectCardTerminal(Set<CardTerminal> eIDCardTerminals) throws CardException, IOException {
        this.view.addDetailMessage("multiple eID card detected...");
        DefaultListModel<ListData> listModel = new DefaultListModel<ListData>();
        Iterator<CardTerminal> iterator = eIDCardTerminals.iterator();
        while (iterator.hasNext()) {
            CardTerminal cardTerminal;
            this.cardTerminal = cardTerminal = iterator.next();
            this.card = this.cardTerminal.connect("T=0");
            this.card.beginExclusive();
            this.cardChannel = this.card.getBasicChannel();
            this.view.addDetailMessage("reading photo from: " + this.cardTerminal.getName());
            byte[] photoFile = this.readFile(PHOTO_FILE_ID);
            BufferedImage photo = ImageIO.read(new ByteArrayInputStream(photoFile));
            listModel.addElement(new ListData(cardTerminal, photo));
            this.card.endExclusive();
            this.card.disconnect(true);
        }
        final JDialog dialog = new JDialog((Frame)null, "Select eID card", true);
        final ListData selectedListData = new ListData(null, null);
        dialog.setLayout(new BorderLayout());
        JList list = new JList(listModel);
        list.setCellRenderer(new EidListCellRenderer());
        dialog.getContentPane().add(list);
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int index;
                JList theList = (JList)mouseEvent.getSource();
                if (mouseEvent.getClickCount() == 2 && (index = theList.locationToIndex(mouseEvent.getPoint())) >= 0) {
                    Object object = theList.getModel().getElementAt(index);
                    ListData listData = (ListData)object;
                    selectedListData.cardTerminal = listData.cardTerminal;
                    selectedListData.photo = listData.photo;
                    dialog.dispose();
                }
            }
        };
        list.addMouseListener(mouseListener);
        dialog.pack();
        dialog.setLocationRelativeTo(this.view.getParentComponent());
        dialog.setResizable(false);
        dialog.setAlwaysOnTop(true);
        dialog.setVisible(true);
        return selectedListData.getCardTerminal();
    }

    private void selectFile(byte[] fileId) throws CardException, FileNotFoundException {
        this.view.addDetailMessage("selecting file");
        CommandAPDU selectFileApdu = new CommandAPDU(0, 164, 8, 12, fileId);
        ResponseAPDU responseApdu = this.transmit(selectFileApdu);
        if (36864 != responseApdu.getSW()) {
            throw new FileNotFoundException("wrong status word after selecting file: " + Integer.toHexString(responseApdu.getSW()));
        }
        try {
            Thread.sleep(20L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("sleep error: " + e.getMessage());
        }
    }

    private boolean matchesEidAtr(ATR atr) {
        byte[] atrBytes = atr.getBytes();
        if (atrBytes.length != ATR_PATTERN.length) {
            return false;
        }
        for (int idx = 0; idx < atrBytes.length; ++idx) {
            int n = idx;
            atrBytes[n] = (byte)(atrBytes[n] & ATR_MASK[idx]);
        }
        return Arrays.equals(atrBytes, ATR_PATTERN);
    }

    /*
     * Unable to fully structure code
     */
    public void waitForEidPresent() throws CardException, InterruptedException {
        do lbl-1000:
        // 3 sources

        {
            block6: {
                if (!this.isOSX()) break block6;
                this.view.addDetailMessage("sleeping...");
                Thread.sleep(1000L);
                if (!this.isEidPresent()) ** GOTO lbl-1000
                return;
            }
            try {
                this.terminalFactory.terminals().waitForChange();
            }
            catch (CardException e) {
                this.view.addDetailMessage("card error: " + e.getMessage());
                cause = e.getCause();
                if (null != cause && "SCARD_E_NO_READERS_AVAILABLE".equals(cause.getMessage())) {
                    this.view.addDetailMessage("no readers available.");
                    this.view.setStatusMessage(Status.NORMAL, Messages.MESSAGE_ID.CONNECT_READER);
                }
                this.view.addDetailMessage("sleeping...");
                Thread.sleep(1000L);
            }
            catch (IllegalStateException e) {
                this.view.addDetailMessage("no terminals at all. sleeping...");
                this.view.addDetailMessage("Maybe you should connect a smart card reader?");
                if (System.getProperty("os.name").startsWith("Linux")) {
                    this.view.addDetailMessage("Maybe the pcscd service is not running?");
                }
                Thread.sleep(1000L);
            }
            Thread.sleep(50L);
        } while (!this.isEidPresent());
    }

    public void removeCard() throws CardException {
        while (this.isCardStillPresent()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                this.view.addDetailMessage("sleep error: " + e.getMessage());
            }
        }
    }

    public boolean isCardStillPresent() throws CardException {
        return this.cardTerminal.isCardPresent();
    }

    public void yieldExclusive(boolean yield) throws CardException {
        if (yield) {
            this.getCard().endExclusive();
        } else {
            this.getCard().beginExclusive();
        }
    }

    public List<X509Certificate> getAuthnCertificateChain() throws CardException, IOException, CertificateException {
        LinkedList<X509Certificate> authnCertificateChain = new LinkedList<X509Certificate>();
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        this.view.addDetailMessage("reading authn certificate...");
        byte[] authnCertFile = this.readFile(AUTHN_CERT_FILE_ID);
        X509Certificate authnCert = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(authnCertFile));
        authnCertificateChain.add(authnCert);
        this.view.addDetailMessage("reading Citizen CA certificate...");
        byte[] citizenCaCertFile = this.readFile(CA_CERT_FILE_ID);
        X509Certificate citizenCaCert = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(citizenCaCertFile));
        authnCertificateChain.add(citizenCaCert);
        this.view.addDetailMessage("reading Root CA certificate...");
        byte[] rootCaCertFile = this.readFile(ROOT_CERT_FILE_ID);
        X509Certificate rootCaCert = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(rootCaCertFile));
        authnCertificateChain.add(rootCaCert);
        return authnCertificateChain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Byte, CCIDFeature> getCCIDFeatures() {
        byte[] features;
        boolean onMsWindows = System.getProperty("os.name") != null && System.getProperty("os.name").startsWith("Windows");
        this.view.addDetailMessage("CCID GET_FEATURE IOCTL...");
        String osName = System.getProperty("os.name");
        int ioctl = osName.startsWith("Windows") ? 3224864 : 1107299656;
        try {
            features = this.card.transmitControlCommand(ioctl, new byte[0]);
            HashMap<Byte, CCIDFeature> ccidFeatures = new HashMap<Byte, CCIDFeature>();
            for (int idx = 0; idx < features.length; ++idx) {
                byte tag = features[idx];
                ++idx;
                ++idx;
                int n = 0;
                for (int count = 0; count < 3; ++count) {
                    n |= features[idx] & 0xFF;
                    ++idx;
                    n <<= 8;
                }
                n |= features[idx] & 0xFF;
                ccidFeatures.put(tag, new CCIDFeature(tag, n));
            }
            if (ccidFeatures.isEmpty() && onMsWindows && this.isPPDUCardTerminal(this.cardTerminal.getName())) {
                this.view.addDetailMessage("trying PPDU interface...");
                ResponseAPDU responseAPDU = this.cardChannel.transmit(new CommandAPDU(-1, -62, 1, 0, new byte[0], 32));
                this.view.addDetailMessage("PPDU response: " + Integer.toHexString(responseAPDU.getSW()));
                if (responseAPDU.getSW() == 36864) {
                    for (byte feature : features = responseAPDU.getData()) {
                        ccidFeatures.put(feature, new CCIDFeature(feature));
                        this.view.addDetailMessage("PPDU feature: " + feature);
                    }
                    HashMap<Byte, CCIDFeature> hashMap = ccidFeatures;
                    return hashMap;
                }
                Map map = Collections.EMPTY_MAP;
                return map;
            }
            HashMap<Byte, CCIDFeature> responseAPDU = ccidFeatures;
            return responseAPDU;
        }
        catch (CardException e) {
            this.view.addDetailMessage("GET_FEATURES IOCTL error: " + e.getMessage());
            try {
                if (!onMsWindows || !this.isPPDUCardTerminal(this.cardTerminal.getName())) {
                    Map idx = Collections.EMPTY_MAP;
                    return idx;
                }
                this.view.addDetailMessage("trying PPDU interface...");
            }
            catch (CardException e2) {
                this.view.addDetailMessage("PPDU failed: " + e2.getMessage());
                Throwable cause = e2.getCause();
                if (null != cause) {
                    StackTraceElement[] map;
                    this.view.addDetailMessage("cause: " + cause.getMessage());
                    for (StackTraceElement stackTraceElement : map = cause.getStackTrace()) {
                        this.view.addDetailMessage("at " + stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName() + ":" + stackTraceElement.getLineNumber());
                    }
                }
                this.selectBelpicJavaCardApplet();
                Map map = Collections.EMPTY_MAP;
                return map;
            }
            ResponseAPDU responseAPDU = this.cardChannel.transmit(new CommandAPDU(-1, -62, 1, 0, new byte[0], 32));
            this.view.addDetailMessage("PPDU response: " + Integer.toHexString(responseAPDU.getSW()));
            if (responseAPDU.getSW() == 36864) {
                HashMap<Byte, CCIDFeature> ccidFeatures = new HashMap<Byte, CCIDFeature>();
                for (byte feature : features = responseAPDU.getData()) {
                    ccidFeatures.put(feature, new CCIDFeature(feature));
                    this.view.addDetailMessage("PPDU feature: " + feature);
                }
                HashMap<Byte, CCIDFeature> hashMap = ccidFeatures;
                return hashMap;
            }
            Map ccidFeatures = Collections.EMPTY_MAP;
            return ccidFeatures;
        }
        finally {
            try {
                Thread.sleep(25L);
            }
            catch (InterruptedException responseAPDU) {}
        }
    }

    public void addPPDUName(String name) {
        this.ppduNames.add(name.toLowerCase());
    }

    private boolean isPPDUCardTerminal(String name) {
        name = name.toLowerCase();
        for (String ppduName : this.ppduNames) {
            if (!name.contains(ppduName)) continue;
            return true;
        }
        return false;
    }

    public byte[] sign(byte[] digestValue, String digestAlgo, byte keyId, boolean requireSecureReader) throws CardException, IOException, InterruptedException, UserCancelledException {
        Map<Byte, CCIDFeature> ccidFeatures = this.getCCIDFeatures();
        for (Map.Entry<Byte, CCIDFeature> ccidFeature : ccidFeatures.entrySet()) {
            this.view.addDetailMessage("CCID feature: " + ccidFeature.getKey());
        }
        CCIDFeature directPinVerifyFeature = ccidFeatures.get((byte)6);
        CCIDFeature verifyPinStartFeature = ccidFeatures.get((byte)1);
        CCIDFeature eIDPINPadReaderFeature = ccidFeatures.get((byte)-128);
        if (null != eIDPINPadReaderFeature) {
            this.view.addDetailMessage("eID-aware secure PIN pad reader detected");
        }
        if (requireSecureReader && null == directPinVerifyFeature && null == verifyPinStartFeature) {
            throw new SecurityException("not a secure reader");
        }
        this.view.addDetailMessage("selecting key...");
        byte algoRef = "SHA-1-PSS".equals(digestAlgo) ? (byte)16 : ("SHA-256-PSS".equals(digestAlgo) ? (byte)32 : 1);
        CommandAPDU setApdu = new CommandAPDU(0, 34, 65, 182, new byte[]{4, -128, algoRef, -124, keyId});
        ResponseAPDU responseApdu = this.transmit(setApdu);
        if (36864 != responseApdu.getSW()) {
            throw new RuntimeException("SELECT error");
        }
        if (-125 == keyId) {
            this.view.addDetailMessage("non-repudiation key detected, immediate PIN verify");
            this.verifyPin(directPinVerifyFeature, verifyPinStartFeature, ccidFeatures);
        }
        ByteArrayOutputStream digestInfo = new ByteArrayOutputStream();
        if ("SHA-1".equals(digestAlgo) || "SHA1".equals(digestAlgo)) {
            digestInfo.write(Constants.SHA1_DIGEST_INFO_PREFIX);
        } else if ("SHA-224".equals(digestAlgo)) {
            digestInfo.write(Constants.SHA224_DIGEST_INFO_PREFIX);
        } else if ("SHA-256".equals(digestAlgo)) {
            digestInfo.write(Constants.SHA256_DIGEST_INFO_PREFIX);
        } else if ("SHA-384".equals(digestAlgo)) {
            digestInfo.write(Constants.SHA384_DIGEST_INFO_PREFIX);
        } else if ("SHA-512".equals(digestAlgo)) {
            digestInfo.write(Constants.SHA512_DIGEST_INFO_PREFIX);
        } else if ("RIPEMD160".equals(digestAlgo)) {
            digestInfo.write(Constants.RIPEMD160_DIGEST_INFO_PREFIX);
        } else if ("RIPEMD128".equals(digestAlgo)) {
            digestInfo.write(Constants.RIPEMD128_DIGEST_INFO_PREFIX);
        } else if ("RIPEMD256".equals(digestAlgo)) {
            digestInfo.write(Constants.RIPEMD256_DIGEST_INFO_PREFIX);
        } else if (Constants.PLAIN_TEXT_DIGEST_ALGO_OID.equals(digestAlgo)) {
            byte[] digestInfoPrefix = Arrays.copyOf(Constants.PLAIN_TEXT_DIGEST_INFO_PREFIX, Constants.PLAIN_TEXT_DIGEST_INFO_PREFIX.length);
            digestInfoPrefix[1] = (byte)(digestValue.length + 13);
            digestInfoPrefix[14] = (byte)digestValue.length;
            digestInfo.write(digestInfoPrefix);
        } else if (!"SHA-1-PSS".equals(digestAlgo) && !"SHA-256-PSS".equals(digestAlgo)) {
            throw new RuntimeException("digest also not supported: " + digestAlgo);
        }
        digestInfo.write(digestValue);
        CommandAPDU computeDigitalSignatureApdu = new CommandAPDU(0, 42, 158, 154, digestInfo.toByteArray());
        this.view.addDetailMessage("computing digital signature...");
        responseApdu = this.transmit(computeDigitalSignatureApdu);
        if (36864 == responseApdu.getSW()) {
            byte[] signatureValue = responseApdu.getData();
            return signatureValue;
        }
        if (27010 != responseApdu.getSW()) {
            this.view.addDetailMessage("SW: " + Integer.toHexString(responseApdu.getSW()));
            throw new RuntimeException("compute digital signature error");
        }
        this.view.addDetailMessage("PIN verification required...");
        this.verifyPin(directPinVerifyFeature, verifyPinStartFeature, ccidFeatures);
        this.view.addDetailMessage("computing digital signature...");
        responseApdu = this.cardChannel.transmit(computeDigitalSignatureApdu);
        if (36864 != responseApdu.getSW()) {
            throw new RuntimeException("compute digital signature error: " + Integer.toHexString(responseApdu.getSW()));
        }
        byte[] signatureValue = responseApdu.getData();
        return signatureValue;
    }

    public void verifyPin() throws IOException, CardException, InterruptedException, UserCancelledException {
        Map<Byte, CCIDFeature> ccidFeatures = this.getCCIDFeatures();
        CCIDFeature directPinVerifyFeature = ccidFeatures.get((byte)6);
        CCIDFeature verifyPinStartFeature = ccidFeatures.get((byte)1);
        this.verifyPin(directPinVerifyFeature, verifyPinStartFeature, ccidFeatures);
    }

    public void endExclusive() throws CardException {
        if (this.isWindows8()) {
            this.card.endExclusive();
        }
    }

    public void beginExclusive() throws CardException {
        if (this.isWindows8()) {
            this.card.beginExclusive();
        }
    }

    private void verifyPin(CCIDFeature directPinVerifyFeature, CCIDFeature verifyPinStartFeature, Map<Byte, CCIDFeature> ccidFeatures) throws IOException, CardException, InterruptedException, UserCancelledException {
        ResponseAPDU responseApdu;
        if (this.isWindows8()) {
            this.card.endExclusive();
        }
        int retriesLeft = -1;
        do {
            if (36864 == (responseApdu = null != directPinVerifyFeature ? this.verifyPinDirect(retriesLeft, directPinVerifyFeature) : (null != verifyPinStartFeature ? this.verifyPin(retriesLeft, verifyPinStartFeature, ccidFeatures) : this.verifyPin(retriesLeft))).getSW()) continue;
            this.view.addDetailMessage("VERIFY_PIN error");
            this.view.addDetailMessage("SW: " + Integer.toHexString(responseApdu.getSW()));
            if (27011 == responseApdu.getSW()) {
                this.dialogs.showPinBlockedDialog();
                throw new RuntimeException("eID card blocked!");
            }
            if (99 != responseApdu.getSW1()) {
                this.view.addDetailMessage("PIN verification error.");
                throw new RuntimeException("PIN verification error.");
            }
            retriesLeft = responseApdu.getSW2() & 0xF;
            this.view.addDetailMessage("retries left: " + retriesLeft);
        } while (36864 != responseApdu.getSW());
        if (this.isWindows8()) {
            this.card.beginExclusive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResponseAPDU verifyPin(int retriesLeft, CCIDFeature verifyPinStartFeature, Map<Byte, CCIDFeature> ccidFeatures) throws IOException, CardException, InterruptedException, UserCancelledException {
        this.view.addDetailMessage("CCID verify PIN start/end sequence...");
        byte[] verifyCommandData = this.createPINVerificationDataStructure(32);
        this.dialogs.showPINPadFrame(retriesLeft);
        try {
            CCIDFeature getKeyPressedFeature = ccidFeatures.get((byte)5);
            verifyPinStartFeature.transmitByteResponse(verifyCommandData, this.card, this.cardChannel);
            this.ccidWaitForOK(getKeyPressedFeature);
        }
        finally {
            this.dialogs.disposePINPadFrame();
        }
        CCIDFeature verifyPinFinishIoctl = ccidFeatures.get((byte)2);
        ResponseAPDU responseApdu = verifyPinFinishIoctl.transmit(new byte[0], this.card, this.cardChannel);
        return responseApdu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResponseAPDU verifyPinDirect(int retriesLeft, CCIDFeature directPinVerifyFeature) throws IOException, CardException, UserCancelledException {
        ResponseAPDU responseApdu;
        this.view.addDetailMessage("direct PIN verification...");
        byte[] verifyCommandData = this.createPINVerificationDataStructure(32);
        this.dialogs.showPINPadFrame(retriesLeft);
        try {
            responseApdu = directPinVerifyFeature.transmit(verifyCommandData, this.card, this.cardChannel);
        }
        finally {
            this.dialogs.disposePINPadFrame();
        }
        if (25601 == responseApdu.getSW()) {
            this.view.addDetailMessage("canceled by user");
            throw new UserCancelledException();
        }
        if (25600 == responseApdu.getSW()) {
            this.view.addDetailMessage("PIN pad timeout");
        }
        return responseApdu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResponseAPDU verifyPukDirect(int retriesLeft, CCIDFeature directPinVerifyFeature) throws IOException, CardException, UserCancelledException {
        ResponseAPDU responseApdu;
        this.view.addDetailMessage("direct PUK verification...");
        byte[] verifyCommandData = this.createPINVerificationDataStructure(44);
        this.dialogs.showPUKPadFrame(retriesLeft);
        try {
            responseApdu = directPinVerifyFeature.transmit(verifyCommandData, this.card, this.cardChannel);
        }
        finally {
            this.dialogs.disposePINPadFrame();
        }
        if (25601 == responseApdu.getSW()) {
            this.view.addDetailMessage("canceled by user");
            throw new UserCancelledException();
        }
        if (25600 == responseApdu.getSW()) {
            this.view.addDetailMessage("PIN pad timeout");
        }
        return responseApdu;
    }

    private byte[] createPINVerificationDataStructure(int apduIns) throws IOException {
        ByteArrayOutputStream verifyCommand = new ByteArrayOutputStream();
        verifyCommand.write(30);
        verifyCommand.write(30);
        verifyCommand.write(137);
        verifyCommand.write(71);
        verifyCommand.write(4);
        verifyCommand.write(new byte[]{12, 4});
        verifyCommand.write(2);
        verifyCommand.write(1);
        verifyCommand.write(new byte[]{this.getLanguageId(), 4});
        verifyCommand.write(0);
        verifyCommand.write(new byte[]{0, 0, 0});
        byte[] verifyApdu = new byte[]{0, (byte)apduIns, 0, 1, 8, 32, -1, -1, -1, -1, -1, -1, -1};
        verifyCommand.write(verifyApdu.length & 0xFF);
        verifyCommand.write(0);
        verifyCommand.write(0);
        verifyCommand.write(0);
        verifyCommand.write(verifyApdu);
        byte[] verifyCommandData = verifyCommand.toByteArray();
        return verifyCommandData;
    }

    private byte getLanguageId() {
        if (Locale.FRENCH.equals(this.locale)) {
            return 12;
        }
        if (Locale.GERMAN.equals(this.locale)) {
            return 7;
        }
        String language = this.locale.getLanguage();
        if ("nl".equals(language)) {
            return 19;
        }
        return 9;
    }

    private byte[] createPINModificationDataStructure(int apduIns) throws IOException {
        ByteArrayOutputStream modifyCommand = new ByteArrayOutputStream();
        modifyCommand.write(30);
        modifyCommand.write(30);
        modifyCommand.write(137);
        modifyCommand.write(71);
        modifyCommand.write(4);
        modifyCommand.write(0);
        modifyCommand.write(8);
        modifyCommand.write(new byte[]{12, 4});
        modifyCommand.write(3);
        modifyCommand.write(2);
        modifyCommand.write(3);
        modifyCommand.write(new byte[]{this.getLanguageId(), 4});
        modifyCommand.write(0);
        modifyCommand.write(1);
        modifyCommand.write(2);
        modifyCommand.write(new byte[]{0, 0, 0});
        byte[] modifyApdu = new byte[]{0, (byte)apduIns, 0, 1, 16, 32, -1, -1, -1, -1, -1, -1, -1, 32, -1, -1, -1, -1, -1, -1, -1};
        modifyCommand.write(modifyApdu.length & 0xFF);
        modifyCommand.write(0);
        modifyCommand.write(0);
        modifyCommand.write(0);
        modifyCommand.write(modifyApdu);
        byte[] modifyCommandData = modifyCommand.toByteArray();
        return modifyCommandData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResponseAPDU verifyPin(int retriesLeft) throws CardException, UserCancelledException {
        char[] pin = this.dialogs.getPin(retriesLeft);
        byte[] verifyData = new byte[]{(byte)(0x20 | pin.length), -1, -1, -1, -1, -1, -1, -1};
        for (int idx = 0; idx < pin.length; idx += 2) {
            byte value;
            char digit1 = pin[idx];
            int digit2 = idx + 1 < pin.length ? pin[idx + 1] : 63;
            verifyData[idx / 2 + 1] = value = (byte)((digit1 - 48 << 4) + (digit2 - 48));
        }
        Arrays.fill(pin, '\u0000');
        this.view.addDetailMessage("verifying PIN...");
        CommandAPDU verifyApdu = new CommandAPDU(0, 32, 0, 1, verifyData);
        try {
            ResponseAPDU responseApdu;
            ResponseAPDU responseAPDU = responseApdu = this.transmit(verifyApdu);
            return responseAPDU;
        }
        finally {
            Arrays.fill(verifyData, (byte)0);
        }
    }

    public byte[] signAuthn(byte[] toBeSigned, boolean requireSecureReader) throws NoSuchAlgorithmException, CardException, IOException, InterruptedException, UserCancelledException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
        byte[] digest = messageDigest.digest(toBeSigned);
        byte keyId = -126;
        byte[] signatureValue = this.sign(digest, "SHA-1", keyId, requireSecureReader);
        return signatureValue;
    }

    public void changePin(boolean requireSecureReader) throws Exception {
        ResponseAPDU responseApdu;
        Map<Byte, CCIDFeature> ccidFeatures = this.getCCIDFeatures();
        CCIDFeature directPinModifyFeature = ccidFeatures.get((byte)7);
        CCIDFeature modifyPinStartFeature = ccidFeatures.get((byte)3);
        if (requireSecureReader && null == directPinModifyFeature && null == modifyPinStartFeature) {
            throw new SecurityException("not a secure reader");
        }
        if (this.isWindows8()) {
            this.card.endExclusive();
        }
        int retriesLeft = -1;
        do {
            if (null != modifyPinStartFeature) {
                this.view.addDetailMessage("using modify pin start/finish...");
                responseApdu = this.doChangePinStartFinish(retriesLeft, modifyPinStartFeature, ccidFeatures);
            } else if (null != directPinModifyFeature) {
                this.view.addDetailMessage("could use direct PIN modify here...");
                responseApdu = this.doChangePinDirect(retriesLeft, directPinModifyFeature);
            } else {
                responseApdu = this.doChangePin(retriesLeft);
            }
            if (36864 == responseApdu.getSW()) continue;
            this.view.addDetailMessage("CHANGE PIN error");
            this.view.addDetailMessage("SW: " + Integer.toHexString(responseApdu.getSW()));
            if (27011 == responseApdu.getSW()) {
                this.dialogs.showPinBlockedDialog();
                throw new RuntimeException("eID card blocked!");
            }
            if (99 != responseApdu.getSW1()) {
                this.view.addDetailMessage("PIN change error. Card blocked?");
                throw new RuntimeException("PIN change error.");
            }
            retriesLeft = responseApdu.getSW2() & 0xF;
            this.view.addDetailMessage("retries left: " + retriesLeft);
        } while (36864 != responseApdu.getSW());
        this.dialogs.showPinChanged();
        if (this.isWindows8()) {
            this.card.beginExclusive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResponseAPDU doChangePinStartFinish(int retriesLeft, CCIDFeature modifyPinStartFeature, Map<Byte, CCIDFeature> ccidFeatures) throws IOException, CardException, InterruptedException, UserCancelledException {
        byte[] modifyCommandData = this.createPINModificationDataStructure(36);
        modifyPinStartFeature.transmitByteResponse(modifyCommandData, this.card, this.cardChannel);
        CCIDFeature getKeyPressedFeature = ccidFeatures.get((byte)5);
        try {
            this.view.addDetailMessage("enter old PIN...");
            this.dialogs.showPINModifyOldPINFrame(retriesLeft);
            this.ccidWaitForOK(getKeyPressedFeature);
            this.dialogs.disposePINPadFrame();
            this.dialogs.showPINModifyNewPINFrame(retriesLeft);
            this.view.addDetailMessage("enter new PIN...");
            this.ccidWaitForOK(getKeyPressedFeature);
            this.dialogs.disposePINPadFrame();
            this.dialogs.showPINModifyNewPINAgainFrame(retriesLeft);
            this.view.addDetailMessage("enter new PIN again...");
            this.ccidWaitForOK(getKeyPressedFeature);
        }
        finally {
            this.dialogs.disposePINPadFrame();
        }
        CCIDFeature modifyPinFinishIoctl = ccidFeatures.get((byte)4);
        ResponseAPDU responseApdu = modifyPinFinishIoctl.transmit(new byte[0], this.card, this.cardChannel);
        return responseApdu;
    }

    private void ccidWaitForOK(CCIDFeature getKeyPressedFeature) throws CardException, InterruptedException, UserCancelledException {
        block8: while (true) {
            byte[] getKeyPressedResult = getKeyPressedFeature.transmitByteResponse(new byte[0], this.card, this.cardChannel);
            byte key = getKeyPressedResult[0];
            switch (key) {
                case 0: {
                    Thread.sleep(200L);
                    continue block8;
                }
                case 43: {
                    this.view.addDetailMessage("PIN digit");
                    continue block8;
                }
                case 10: {
                    this.view.addDetailMessage("erase PIN digit");
                    continue block8;
                }
                case 13: {
                    this.view.addDetailMessage("user confirmed");
                    break block8;
                }
                case 27: {
                    this.view.addDetailMessage("user canceled");
                    throw new UserCancelledException();
                }
                case 64: {
                    this.view.addDetailMessage("PIN abort");
                    break block8;
                }
                default: {
                    this.view.addDetailMessage("CCID get key pressed result: " + key + " hex: " + Integer.toHexString(key));
                    continue block8;
                }
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResponseAPDU doChangePinDirect(int retriesLeft, CCIDFeature directPinModifyFeature) throws IOException, CardException, UserCancelledException {
        ResponseAPDU responseApdu;
        this.view.addDetailMessage("direct PIN modification...");
        byte[] modifyCommandData = this.createPINModificationDataStructure(36);
        this.dialogs.showPINChangePadFrame(retriesLeft);
        try {
            responseApdu = directPinModifyFeature.transmit(modifyCommandData, this.card, this.cardChannel);
        }
        finally {
            this.dialogs.disposePINPadFrame();
        }
        if (25602 == responseApdu.getSW()) {
            this.view.addDetailMessage("PINs differ");
        } else {
            if (25601 == responseApdu.getSW()) {
                this.view.addDetailMessage("canceled by user");
                throw new UserCancelledException();
            }
            if (25600 == responseApdu.getSW()) {
                this.view.addDetailMessage("PIN pad timeout");
            }
        }
        return responseApdu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResponseAPDU doChangePin(int retriesLeft) throws CardException {
        byte value;
        int digit2;
        char digit1;
        int idx;
        Dialogs.Pins pins = this.dialogs.getPins(retriesLeft);
        char[] oldPin = pins.getOldPin();
        char[] newPin = pins.getNewPin();
        byte[] changePinData = new byte[]{(byte)(0x20 | oldPin.length), -1, -1, -1, -1, -1, -1, -1, (byte)(0x20 | newPin.length), -1, -1, -1, -1, -1, -1, -1};
        for (idx = 0; idx < oldPin.length; idx += 2) {
            digit1 = oldPin[idx];
            digit2 = idx + 1 < oldPin.length ? oldPin[idx + 1] : 63;
            changePinData[idx / 2 + 1] = value = (byte)((digit1 - 48 << 4) + (digit2 - 48));
        }
        Arrays.fill(oldPin, '\u0000');
        for (idx = 0; idx < newPin.length; idx += 2) {
            digit1 = newPin[idx];
            digit2 = idx + 1 < newPin.length ? newPin[idx + 1] : 63;
            changePinData[idx / 2 + 1 + 8] = value = (byte)((digit1 - 48 << 4) + (digit2 - 48));
        }
        Arrays.fill(newPin, '\u0000');
        CommandAPDU changePinApdu = new CommandAPDU(0, 36, 0, 1, changePinData);
        try {
            ResponseAPDU responseApdu;
            ResponseAPDU responseAPDU = responseApdu = this.transmit(changePinApdu);
            return responseAPDU;
        }
        finally {
            Arrays.fill(changePinData, (byte)0);
        }
    }

    public void unblockPin(boolean requireSecureReader) throws Exception {
        ResponseAPDU responseApdu;
        Map<Byte, CCIDFeature> ccidFeatures = this.getCCIDFeatures();
        CCIDFeature directPinVerifyFeature = ccidFeatures.get((byte)6);
        if (requireSecureReader && null == directPinVerifyFeature) {
            throw new SecurityException("not a secure reader");
        }
        if (this.isWindows8()) {
            this.card.endExclusive();
        }
        int retriesLeft = -1;
        do {
            if (null != directPinVerifyFeature) {
                this.view.addDetailMessage("could use direct PIN verify here...");
                responseApdu = this.verifyPukDirect(retriesLeft, directPinVerifyFeature);
            } else {
                responseApdu = this.doUnblockPin(retriesLeft);
            }
            if (36864 == responseApdu.getSW()) continue;
            this.view.addDetailMessage("PIN unblock error");
            this.view.addDetailMessage("SW: " + Integer.toHexString(responseApdu.getSW()));
            if (27011 == responseApdu.getSW()) {
                this.dialogs.showPinBlockedDialog();
                throw new RuntimeException("eID card blocked!");
            }
            if (99 != responseApdu.getSW1()) {
                this.view.addDetailMessage("PIN unblock error.");
                throw new RuntimeException("PIN unblock error.");
            }
            retriesLeft = responseApdu.getSW2() & 0xF;
            this.view.addDetailMessage("retries left: " + retriesLeft);
        } while (36864 != responseApdu.getSW());
        this.dialogs.showPinUnblocked();
        if (this.isWindows8()) {
            this.card.beginExclusive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResponseAPDU doUnblockPin(int retriesLeft) throws CardException {
        char[] puk1 = new char[6];
        char[] puk2 = new char[6];
        this.dialogs.getPuks(retriesLeft, puk1, puk2);
        char[] fullPuk = new char[12];
        System.arraycopy(puk2, 0, fullPuk, 0, 6);
        Arrays.fill(puk2, '\u0000');
        System.arraycopy(puk1, 0, fullPuk, 6, 6);
        Arrays.fill(puk1, '\u0000');
        byte[] unblockPinData = new byte[]{44, -1, -1, -1, -1, -1, -1, -1};
        for (int idx = 0; idx < fullPuk.length; idx += 2) {
            byte value;
            char digit1 = fullPuk[idx];
            char digit2 = fullPuk[idx + 1];
            unblockPinData[idx / 2 + 1] = value = (byte)((digit1 - 48 << 4) + (digit2 - 48));
        }
        Arrays.fill(fullPuk, '\u0000');
        CommandAPDU changePinApdu = new CommandAPDU(0, 44, 0, 1, unblockPinData);
        try {
            ResponseAPDU responseApdu;
            ResponseAPDU responseAPDU = responseApdu = this.transmit(changePinApdu);
            return responseAPDU;
        }
        finally {
            Arrays.fill(unblockPinData, (byte)0);
        }
    }

    public List<X509Certificate> getSignCertificateChain() throws CardException, IOException, CertificateException {
        LinkedList<X509Certificate> signCertificateChain = new LinkedList<X509Certificate>();
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        this.view.addDetailMessage("reading sign certificate...");
        byte[] signCertFile = this.readFile(SIGN_CERT_FILE_ID);
        X509Certificate signCert = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(signCertFile));
        signCertificateChain.add(signCert);
        this.view.addDetailMessage("reading Citizen CA certificate...");
        byte[] citizenCaCertFile = this.readFile(CA_CERT_FILE_ID);
        X509Certificate citizenCaCert = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(citizenCaCertFile));
        signCertificateChain.add(citizenCaCert);
        this.view.addDetailMessage("reading Root CA certificate...");
        byte[] rootCaCertFile = this.readFile(ROOT_CERT_FILE_ID);
        X509Certificate rootCaCert = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(rootCaCertFile));
        signCertificateChain.add(rootCaCert);
        return signCertificateChain;
    }

    public byte[] sign(byte[] digestValue, String digestAlgo, boolean requireSecureReader) throws NoSuchAlgorithmException, CardException, IOException, InterruptedException, UserCancelledException {
        byte keyId = -125;
        byte[] signatureValue = this.sign(digestValue, digestAlgo, keyId, requireSecureReader);
        return signatureValue;
    }

    public void logoff() throws Exception {
        CommandAPDU logoffApdu = new CommandAPDU(128, 230, 0, 0);
        this.view.addDetailMessage("logoff...");
        ResponseAPDU responseApdu = this.transmit(logoffApdu);
        if (36864 != responseApdu.getSW()) {
            this.view.addDetailMessage("logoff status word: " + Integer.toHexString(responseApdu.getSW()));
            if (28160 == responseApdu.getSW()) {
                return;
            }
            throw new RuntimeException("logoff failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logoff(String readerName) throws Exception {
        this.view.addDetailMessage("logoff from reader: \"" + readerName + "\"");
        TerminalFactory factory = TerminalFactory.getDefault();
        CardTerminals cardTerminals = factory.terminals();
        CardTerminal cardTerminal = cardTerminals.getTerminal(readerName);
        if (null == cardTerminal) {
            this.view.addDetailMessage("logoff: card reader not found: " + readerName);
            List<String> readerList = this.getReaderList();
            this.view.addDetailMessage("reader list: " + readerList);
            return;
        }
        Card card = cardTerminal.connect("T=0");
        try {
            CardChannel cardChannel = card.getBasicChannel();
            CommandAPDU logoffApdu = new CommandAPDU(128, 230, 0, 0);
            ResponseAPDU responseApdu = cardChannel.transmit(logoffApdu);
            this.view.addDetailMessage("logoff... " + readerName);
            if (36864 != responseApdu.getSW()) {
                this.view.addDetailMessage("logoff status word: " + Integer.toHexString(responseApdu.getSW()));
                if (28160 == responseApdu.getSW()) {
                    return;
                }
                throw new RuntimeException("logoff failed");
            }
        }
        finally {
            card.disconnect(true);
        }
    }

    private ResponseAPDU transmit(CommandAPDU commandApdu) throws CardException {
        ResponseAPDU responseApdu = this.cardChannel.transmit(commandApdu);
        if (108 == responseApdu.getSW1()) {
            this.view.addDetailMessage("sleeping...");
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("cannot sleep");
            }
            responseApdu = this.cardChannel.transmit(commandApdu);
        }
        return responseApdu;
    }

    public void selectBelpicJavaCardApplet() {
        ResponseAPDU responseApdu;
        CommandAPDU selectApplicationApdu = new CommandAPDU(0, 164, 4, 12, BELPIC_AID);
        try {
            responseApdu = this.transmit(selectApplicationApdu);
        }
        catch (CardException e) {
            this.view.addDetailMessage("error selecting BELPIC");
            return;
        }
        if (36864 != responseApdu.getSW()) {
            this.view.addDetailMessage("could not select BELPIC");
            this.view.addDetailMessage("status word: " + Integer.toHexString(responseApdu.getSW()));
            selectApplicationApdu = new CommandAPDU(0, 164, 4, 0, APPLET_AID);
            try {
                responseApdu = this.transmit(selectApplicationApdu);
            }
            catch (CardException e) {
                this.view.addDetailMessage("error selecting Applet");
                return;
            }
            if (36864 != responseApdu.getSW()) {
                this.view.addDetailMessage("could not select applet");
            } else {
                this.view.addDetailMessage("BELPIC JavaCard applet selected");
            }
        } else {
            this.view.addDetailMessage("BELPIC JavaCard applet selected");
        }
    }

    public byte[] signAuthn(byte[] toBeSigned) throws NoSuchAlgorithmException, CardException, IOException, InterruptedException, UserCancelledException {
        return this.signAuthn(toBeSigned, false);
    }

    public byte[] sign(byte[] digestValue, String digestAlgo) throws NoSuchAlgorithmException, CardException, IOException, InterruptedException, UserCancelledException {
        return this.sign(digestValue, digestAlgo, false);
    }

    public void changePin() throws Exception {
        this.changePin(false);
    }

    public void unblockPin() throws Exception {
        this.unblockPin(false);
    }

    public byte[] getChallenge(int size) throws CardException {
        CommandAPDU getChallengeApdu = new CommandAPDU(0, 132, 0, 0, new byte[0], 0, 0, size);
        ResponseAPDU responseApdu = this.cardChannel.transmit(getChallengeApdu);
        if (36864 != responseApdu.getSW()) {
            this.view.addDetailMessage("get challenge failure: " + Integer.toHexString(responseApdu.getSW()));
            throw new RuntimeException("get challenge failure: " + Integer.toHexString(responseApdu.getSW()));
        }
        if (size != responseApdu.getData().length) {
            throw new RuntimeException("challenge size incorrect: " + responseApdu.getData().length);
        }
        return responseApdu.getData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] signTransactionMessage(String transactionMessage, boolean requireSecureReader) throws CardException, IOException, InterruptedException, UserCancelledException {
        byte[] signature;
        Map<Byte, CCIDFeature> ccidFeatures = this.getCCIDFeatures();
        CCIDFeature eIDPINPadReaderFeature = ccidFeatures.get((byte)-128);
        if (null != eIDPINPadReaderFeature) {
            this.dialogs.showSecureReaderTransactionFrame();
        }
        try {
            signature = this.sign(transactionMessage.getBytes(), Constants.PLAIN_TEXT_DIGEST_ALGO_OID, (byte)-126, requireSecureReader);
        }
        finally {
            if (null != eIDPINPadReaderFeature) {
                this.dialogs.disposeSecureReaderTransactionFrame();
            }
        }
        return signature;
    }

    public boolean isOSX() {
        String osName = System.getProperty("os.name");
        return osName.contains("OS X");
    }

    public boolean isWindows8() {
        String osName = System.getProperty("os.name");
        boolean win8 = osName.contains("Windows 8");
        if (win8) {
            return true;
        }
        boolean win10 = osName.contains("Windows 10");
        return win10;
    }

    private static class CCIDFeature {
        private final byte feature;
        private final Integer ioctl;

        public CCIDFeature(byte feature) {
            this.feature = feature;
            this.ioctl = null;
        }

        public CCIDFeature(byte feature, Integer ioctl) {
            this.feature = feature;
            this.ioctl = ioctl;
        }

        public Integer getIoctl() {
            return this.ioctl;
        }

        public ResponseAPDU transmit(byte[] command, Card card, CardChannel cardChannel) throws CardException {
            if (this.ioctl == null) {
                return cardChannel.transmit(new CommandAPDU(255, 194, 1, (int)this.feature, command));
            }
            byte[] result = card.transmitControlCommand(this.ioctl, command);
            ResponseAPDU responseApdu = new ResponseAPDU(result);
            return responseApdu;
        }

        public byte[] transmitByteResponse(byte[] command, Card card, CardChannel cardChannel) throws CardException {
            if (this.ioctl == null) {
                return cardChannel.transmit(new CommandAPDU(255, 194, 1, (int)this.feature, command)).getData();
            }
            byte[] result = card.transmitControlCommand(this.ioctl, command);
            return result;
        }
    }

    private static class EidListCellRenderer
    extends JPanel
    implements ListCellRenderer {
        private static final long serialVersionUID = 1L;

        private EidListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JPanel panel = new JPanel();
            ListData listData = (ListData)value;
            panel.setLayout(new FlowLayout(0));
            JLabel photoLabel = new JLabel(new ImageIcon(listData.getPhoto()));
            panel.add(photoLabel);
            JLabel nameLabel = new JLabel(listData.getCardTerminal().getName());
            if (isSelected) {
                panel.setBackground(list.getSelectionBackground());
            } else {
                panel.setBackground(list.getBackground());
            }
            panel.add(nameLabel);
            return panel;
        }
    }

    private static class ListData {
        private CardTerminal cardTerminal;
        private BufferedImage photo;

        public ListData(CardTerminal cardTerminal, BufferedImage photo) {
            this.cardTerminal = cardTerminal;
            this.photo = photo;
        }

        public CardTerminal getCardTerminal() {
            return this.cardTerminal;
        }

        public BufferedImage getPhoto() {
            return this.photo;
        }
    }
}

