/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.io;

import be.fedict.eid.applet.shared.protocol.HttpReceiver;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class HttpURLConnectionHttpReceiver
implements HttpReceiver {
    private final HttpURLConnection connection;

    public HttpURLConnectionHttpReceiver(HttpURLConnection connection) {
        this.connection = connection;
    }

    @Override
    public byte[] getBody() {
        try {
            int n;
            InputStream inputStream = this.connection.getInputStream();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            do {
                if (-1 == (n = inputStream.read(buffer))) continue;
                baos.write(buffer, 0, n);
            } while (-1 != n);
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("IO error: " + e.getMessage());
        }
    }

    @Override
    public List<String> getHeaderNames() {
        Map<String, List<String>> headerFields = this.connection.getHeaderFields();
        LinkedList<String> headerNames = new LinkedList<String>();
        for (String headerName : headerFields.keySet()) {
            if (null == headerName) continue;
            headerNames.add(headerName);
        }
        return headerNames;
    }

    @Override
    public String getHeaderValue(String headerName) {
        return this.connection.getHeaderField(headerName);
    }

    @Override
    public boolean isSecure() {
        if ("localhost".equals(this.connection.getURL().getHost())) {
            return true;
        }
        return false != "https".equals(this.connection.getURL().getProtocol());
    }
}

