/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.UIManager;

public class Messages {
    public static final String RESOURCE_BUNDLE_NAME = "be.fedict.eid.applet.Messages";
    private final ResourceBundle resourceBundle;
    private final Locale locale;

    public Messages(Locale locale) {
        ResourceBundle bundle;
        this.locale = locale;
        try {
            bundle = ResourceBundle.getBundle(RESOURCE_BUNDLE_NAME, this.locale);
        }
        catch (MissingResourceException e) {
            bundle = ResourceBundle.getBundle(RESOURCE_BUNDLE_NAME, Locale.ENGLISH);
        }
        this.resourceBundle = bundle;
        UIManager.put("OptionPane.cancelButtonText", this.getMessage(MESSAGE_ID.CANCEL_BUTTON));
        UIManager.put("OptionPane.noButtonText", this.getMessage(MESSAGE_ID.NO_BUTTON));
        UIManager.put("OptionPane.okButtonText", this.getMessage(MESSAGE_ID.OK_BUTTON));
        UIManager.put("OptionPane.yesButtonText", this.getMessage(MESSAGE_ID.YES_BUTTON));
    }

    public String getMessage(MESSAGE_ID messageId) {
        String message = this.resourceBundle.getString(messageId.id);
        return message;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public static enum MESSAGE_ID {
        LOADING("loading"),
        SECURITY_ERROR("securityError"),
        CARD_ERROR("cardError"),
        GENERIC_ERROR("genericError"),
        DETECTING_CARD("detectingCard"),
        INSERT_CARD_QUESTION("insertCardQuestion"),
        READING_IDENTITY("readingIdentity"),
        TRANSMITTING_IDENTITY("transmittingIdentity"),
        DONE("done"),
        PRIVACY_QUESTION("privacyQuestion"),
        AUTHENTICATING("authenticating"),
        REMOVE_CARD("removeCard"),
        SIGNING("signing"),
        SELECT_FILES("selectFiles"),
        DIGESTING_FILES("digestingFiles"),
        COPY_ALL("copyAll"),
        MAIL("mail"),
        PIN_BLOCKED("pinBlocked"),
        PIN_CHANGED("pinChanged"),
        PIN_UNBLOCKED("pinUnblocked"),
        RETRIES_LEFT("retriesLeft"),
        PIN_INCORRECT("pinIncorrect"),
        CONNECT_READER("connectReader"),
        PIN_PAD("pinPad"),
        CURRENT_PIN("currentPin"),
        NEW_PIN("newPin"),
        OK("ok"),
        CANCEL("cancel"),
        PUK_PAD("pukPad"),
        PIN_PAD_CHANGE("pinPadChange"),
        ENTER_PIN("enterPin"),
        LABEL_PIN("labelPin"),
        PIN_CHANGE("pinChange"),
        PIN_UNBLOCK("pinUnblock"),
        PIN_PAD_MODIFY_OLD("pinPadModifyOld"),
        PIN_PAD_MODIFY_NEW("pinPadModifyNew"),
        PIN_PAD_MODIFY_NEW_AGAIN("pinPadModifyNewAgain"),
        CERTIFICATE_EXPIRED_ERROR("certificateExpiredError"),
        CERTIFICATE_REVOKED_ERROR("certificateRevokedError"),
        IDENTITY_INFO("identityInfo"),
        IDENTITY_IDENTITY("identityIdentity"),
        IDENTITY_ADDRESS("identityAddress"),
        IDENTITY_PHOTO("identityPhoto"),
        DETAILS_BUTTON("detailsButtonText"),
        CANCEL_BUTTON("cancelButtonText"),
        NO_BUTTON("noButtonText"),
        OK_BUTTON("okButtonText"),
        YES_BUTTON("yesButtonText"),
        CERTIFICATE_NOT_TRUSTED("certificateNotTrusted"),
        SIGNATURE_CREATION("signatureCreation"),
        SIGN_QUESTION("signQuestion"),
        SIGNATURE_ALGO("signatureAlgo"),
        PROTOCOL_SIGNATURE("protocolSignature"),
        USAGE("usage"),
        AUTHORIZATION_ERROR("authorizationError"),
        SAFARI_SANDBOX_1("safariSandbox1"),
        SAFARI_SANDBOX_2("safariSandBox2"),
        SAFARI_SANDBOX_10("safariSandbox10");

        private final String id;

        private MESSAGE_ID(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }
    }
}

