/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet;

import be.fedict.eid.applet.Messages;
import be.fedict.eid.applet.Status;
import be.fedict.eid.applet.View;
import be.fedict.eid.applet.sc.PcscEid;
import java.awt.Component;
import javax.smartcardio.CardException;

public class ExclusiveAccessViewDecorator
implements View {
    private final View delegate;
    private final PcscEid pcscEid;

    public ExclusiveAccessViewDecorator(View delegate, PcscEid pcscEid) {
        this.delegate = delegate;
        this.pcscEid = pcscEid;
    }

    @Override
    public void addDetailMessage(String detailMessage) {
        this.delegate.addDetailMessage(detailMessage);
    }

    @Override
    public void setStatusMessage(Status status, Messages.MESSAGE_ID messageId) {
        this.delegate.setStatusMessage(status, messageId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean privacyQuestion(boolean includeAddress, boolean includePhoto, String identityDataUsage) {
        try {
            this.pcscEid.endExclusive();
        }
        catch (CardException e) {
            this.delegate.addDetailMessage("could not end exclusive card access");
            return false;
        }
        try {
            boolean bl = this.delegate.privacyQuestion(includeAddress, includePhoto, identityDataUsage);
            return bl;
        }
        finally {
            try {
                this.pcscEid.beginExclusive();
            }
            catch (CardException e) {
                this.delegate.addDetailMessage("could not acquire exclusive card access");
                return false;
            }
        }
    }

    @Override
    public Component getParentComponent() {
        return this.delegate.getParentComponent();
    }

    @Override
    public void setProgressIndeterminate() {
        this.delegate.setProgressIndeterminate();
    }

    @Override
    public void resetProgress(int max) {
        this.delegate.resetProgress(max);
    }

    @Override
    public void increaseProgress() {
        this.delegate.increaseProgress();
    }

    @Override
    public void confirmAuthenticationSignature(String message) {
        try {
            this.pcscEid.endExclusive();
        }
        catch (CardException e) {
            throw new SecurityException("could not end exclusive card access");
        }
        try {
            this.delegate.confirmAuthenticationSignature(message);
        }
        finally {
            try {
                this.pcscEid.beginExclusive();
            }
            catch (CardException e) {
                throw new SecurityException("could not acquire exclusive card access");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int confirmSigning(String description, String digestAlgo) {
        try {
            this.pcscEid.endExclusive();
        }
        catch (CardException e) {
            this.delegate.addDetailMessage("could not end exclusive card access");
            return 2;
        }
        try {
            int n = this.delegate.confirmSigning(description, digestAlgo);
            return n;
        }
        finally {
            try {
                this.pcscEid.beginExclusive();
            }
            catch (CardException e) {
                this.delegate.addDetailMessage("could not acquire exclusive card access");
                return 2;
            }
        }
    }
}

