/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.shared.protocol;

import be.fedict.eid.applet.shared.annotation.HttpBody;
import be.fedict.eid.applet.shared.annotation.HttpHeader;
import be.fedict.eid.applet.shared.annotation.MessageDiscriminator;
import be.fedict.eid.applet.shared.annotation.NotNull;
import be.fedict.eid.applet.shared.annotation.PostConstruct;
import be.fedict.eid.applet.shared.annotation.ProtocolVersion;
import be.fedict.eid.applet.shared.annotation.ValidateSemanticalIntegrity;
import be.fedict.eid.applet.shared.protocol.HttpReceiver;
import be.fedict.eid.applet.shared.protocol.ProtocolMessageCatalog;
import be.fedict.eid.applet.shared.protocol.SemanticValidator;
import be.fedict.eid.applet.shared.protocol.SemanticValidatorException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Unmarshaller {
    private String protocolMessageDiscriminatorHeaderName;
    private Map<String, Class<?>> protocolMessageClasses;
    private String protocolVersionHeaderName;
    private Integer protocolVersion;

    public Unmarshaller(ProtocolMessageCatalog catalog) {
        this.processMessageCatalog(catalog);
    }

    private void processMessageCatalog(ProtocolMessageCatalog catalog) {
        this.protocolMessageClasses = new HashMap();
        List<Class<?>> messageClasses = catalog.getCatalogClasses();
        for (Class<?> messageClass : messageClasses) {
            Integer protocolVersion;
            String discriminatorValue;
            Field discriminatorField = this.findDiscriminatorField(messageClass);
            HttpHeader httpHeaderAnnotation = discriminatorField.getAnnotation(HttpHeader.class);
            String discriminatorHttpHeaderName = httpHeaderAnnotation.value();
            if (null == this.protocolMessageDiscriminatorHeaderName) {
                this.protocolMessageDiscriminatorHeaderName = discriminatorHttpHeaderName;
            } else if (!this.protocolMessageDiscriminatorHeaderName.equals(discriminatorHttpHeaderName)) {
                throw new RuntimeException("discriminator field not the same over all message classes");
            }
            try {
                discriminatorValue = (String)discriminatorField.get(null);
            }
            catch (Exception e) {
                throw new RuntimeException("error reading field: " + e.getMessage());
            }
            if (this.protocolMessageClasses.containsValue(discriminatorValue)) {
                throw new RuntimeException("discriminator field not unique for: " + messageClass.getName());
            }
            this.protocolMessageClasses.put(discriminatorValue, messageClass);
            Field protocolVersionField = this.findProtocolVersionField(messageClass);
            httpHeaderAnnotation = protocolVersionField.getAnnotation(HttpHeader.class);
            String protocolVersionHttpHeaderName = httpHeaderAnnotation.value();
            if (null == this.protocolVersionHeaderName) {
                this.protocolVersionHeaderName = protocolVersionHttpHeaderName;
            } else if (!this.protocolVersionHeaderName.equals(this.protocolVersionHeaderName)) {
                throw new RuntimeException("protocol version field not the same over all message classes");
            }
            try {
                protocolVersion = (Integer)protocolVersionField.get(null);
            }
            catch (Exception e) {
                throw new RuntimeException("error reading field: " + e.getMessage());
            }
            if (null == this.protocolVersion) {
                this.protocolVersion = protocolVersion;
                continue;
            }
            if (this.protocolVersion.equals(protocolVersion)) continue;
            throw new RuntimeException("protocol version not the same over all message classes");
        }
    }

    private Field findDiscriminatorField(Class<?> messageClass) {
        Field[] fields;
        for (Field field : fields = messageClass.getFields()) {
            MessageDiscriminator messageDiscriminatorAnnotation = field.getAnnotation(MessageDiscriminator.class);
            if (null == messageDiscriminatorAnnotation) continue;
            if (16 != (field.getModifiers() & 0x10)) {
                throw new RuntimeException("message discriminator should be final");
            }
            if (8 != (field.getModifiers() & 8)) {
                throw new RuntimeException("message discriminator should be static");
            }
            if (!String.class.equals(field.getType())) {
                throw new RuntimeException("message discriminator should be a String");
            }
            HttpHeader httpHeaderAnnotation = field.getAnnotation(HttpHeader.class);
            if (null == httpHeaderAnnotation) {
                throw new RuntimeException("message discriminator should be a HTTP header");
            }
            return field;
        }
        throw new RuntimeException("no message discriminator field found on " + messageClass.getName());
    }

    private Field findProtocolVersionField(Class<?> messageClass) {
        Field[] fields;
        for (Field field : fields = messageClass.getFields()) {
            ProtocolVersion protocolVersionAnnotation = field.getAnnotation(ProtocolVersion.class);
            if (null == protocolVersionAnnotation) continue;
            if (16 != (field.getModifiers() & 0x10)) {
                throw new RuntimeException("protocol version field should be final");
            }
            if (8 != (field.getModifiers() & 8)) {
                throw new RuntimeException("protocol version field should be static");
            }
            if (!Integer.TYPE.equals(field.getType())) {
                throw new RuntimeException("protocol version field should be an int");
            }
            HttpHeader httpHeaderAnnotation = field.getAnnotation(HttpHeader.class);
            if (null == httpHeaderAnnotation) {
                throw new RuntimeException("protocol version field should be a HTTP header");
            }
            return field;
        }
        throw new RuntimeException("no protocol version field field found on " + messageClass.getName());
    }

    public Object receive(HttpReceiver httpReceiver) {
        Object transferObject;
        if (!httpReceiver.isSecure()) {
            throw new SecurityException("HTTP receiver over unsecure channel");
        }
        String protocolVersionHeader = httpReceiver.getHeaderValue(this.protocolVersionHeaderName);
        if (null == protocolVersionHeader) {
            throw new RuntimeException("no protocol version header");
        }
        Integer protocolVersion = Integer.parseInt(protocolVersionHeader);
        if (!this.protocolVersion.equals(protocolVersion)) {
            throw new RuntimeException("protocol version mismatch");
        }
        String discriminatorValue = httpReceiver.getHeaderValue(this.protocolMessageDiscriminatorHeaderName);
        Class<?> protocolMessageClass = this.protocolMessageClasses.get(discriminatorValue);
        if (null == protocolMessageClass) {
            throw new RuntimeException("unsupported message: " + discriminatorValue);
        }
        try {
            transferObject = protocolMessageClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("error: " + e.getMessage(), e);
        }
        try {
            this.injectHttpHeaderFields(httpReceiver, protocolMessageClass, transferObject);
        }
        catch (Exception e) {
            throw new RuntimeException("error: " + e.getMessage(), e);
        }
        Field[] fields = protocolMessageClass.getFields();
        this.injectHttpBody(httpReceiver, transferObject, fields);
        this.inputValidation(transferObject, fields);
        this.semanticValidation(protocolMessageClass, transferObject);
        this.postConstructSemantics(protocolMessageClass, transferObject);
        return transferObject;
    }

    private void injectHttpBody(HttpReceiver httpReceiver, Object transferObject, Field[] fields) {
        Field bodyField = null;
        for (Field field : fields) {
            HttpBody httpBodyAnnotation = field.getAnnotation(HttpBody.class);
            if (null == httpBodyAnnotation) continue;
            if (null == bodyField) {
                bodyField = field;
                continue;
            }
            throw new RuntimeException("multiple body fields detected");
        }
        if (null != bodyField) {
            Object bodyValue;
            byte[] body = httpReceiver.getBody();
            if (List.class.equals(bodyField.getType())) {
                LinkedList<String> bodyList = new LinkedList<String>();
                BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(body)));
                try {
                    String line;
                    while (null != (line = reader.readLine())) {
                        bodyList.add(line);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("IO error: " + e.getMessage());
                }
                bodyValue = bodyList;
            } else {
                bodyValue = body;
            }
            try {
                bodyField.set(transferObject, bodyValue);
            }
            catch (Exception e) {
                throw new RuntimeException("error: " + e.getMessage(), e);
            }
        }
    }

    private void postConstructSemantics(Class<?> protocolMessageClass, Object transferObject) {
        Method[] methods;
        for (Method method : methods = protocolMessageClass.getMethods()) {
            PostConstruct postConstructAnnotation = method.getAnnotation(PostConstruct.class);
            if (null == postConstructAnnotation) continue;
            try {
                method.invoke(transferObject, new Object[0]);
            }
            catch (InvocationTargetException e) {
                Throwable methodException = e.getTargetException();
                if (methodException instanceof RuntimeException) {
                    RuntimeException runtimeException = (RuntimeException)methodException;
                    throw runtimeException;
                }
                throw new RuntimeException("@PostConstruct method invocation error: " + methodException.getMessage(), methodException);
            }
            catch (Exception e) {
                throw new RuntimeException("@PostConstruct error: " + e.getMessage(), e);
            }
        }
    }

    private void semanticValidation(Class<?> protocolMessageClass, Object transferObject) {
        ValidateSemanticalIntegrity validateSemanticalIntegrity = protocolMessageClass.getAnnotation(ValidateSemanticalIntegrity.class);
        if (null != validateSemanticalIntegrity) {
            SemanticValidator<?> validator;
            Class<SemanticValidator<?>> validatorClass = validateSemanticalIntegrity.value();
            try {
                validator = validatorClass.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("error: " + e.getMessage(), e);
            }
            try {
                validator.validate(transferObject);
            }
            catch (SemanticValidatorException e) {
                throw new RuntimeException("semantic validation error: " + e.getMessage());
            }
        }
    }

    private void inputValidation(Object transferObject, Field[] fields) {
        for (Field field : fields) {
            Object fieldValue;
            NotNull notNullAnnotation = field.getAnnotation(NotNull.class);
            if (null == notNullAnnotation) continue;
            try {
                fieldValue = field.get(transferObject);
            }
            catch (Exception e) {
                throw new RuntimeException("error: " + e.getMessage(), e);
            }
            if (null != fieldValue) continue;
            throw new RuntimeException("field should not be null: " + field.getName());
        }
    }

    private void injectHttpHeaderFields(HttpReceiver httpReceiver, Class<?> protocolMessageClass, Object transferObject) throws IllegalArgumentException, IllegalAccessException {
        List<String> headerNames = httpReceiver.getHeaderNames();
        for (String headerName : headerNames) {
            Field httpHeaderField = this.findHttpHeaderField(protocolMessageClass, headerName);
            if (null == httpHeaderField) continue;
            String headerValue = httpReceiver.getHeaderValue(headerName);
            if (0 != (httpHeaderField.getModifiers() & 0x10)) {
                String constantValue;
                if (String.class.equals(httpHeaderField.getType())) {
                    constantValue = (String)httpHeaderField.get(transferObject);
                } else if (Integer.TYPE.equals(httpHeaderField.getType())) {
                    constantValue = ((Integer)httpHeaderField.get(transferObject)).toString();
                } else {
                    throw new RuntimeException("unsupported type: " + httpHeaderField.getType().getName());
                }
                if (constantValue.equals(headerValue)) continue;
                throw new RuntimeException("constant value mismatch: " + httpHeaderField.getName() + "; expected value: " + constantValue + "; actual value: " + headerValue);
            }
            if (String.class.equals(httpHeaderField.getType())) {
                httpHeaderField.set(transferObject, headerValue);
                continue;
            }
            if (Integer.TYPE.equals(httpHeaderField.getType()) || Integer.class.equals(httpHeaderField.getType())) {
                Integer intValue = Integer.parseInt(headerValue);
                httpHeaderField.set(transferObject, intValue);
                continue;
            }
            if (Boolean.TYPE.equals(httpHeaderField.getType()) || Boolean.class.equals(httpHeaderField.getType())) {
                Boolean boolValue = Boolean.parseBoolean(headerValue);
                httpHeaderField.set(transferObject, boolValue);
                continue;
            }
            if (httpHeaderField.getType().isEnum()) {
                Enum e = (Enum)httpHeaderField.getType().getEnumConstants()[0];
                Object value = Enum.valueOf(e.getClass(), headerValue);
                httpHeaderField.set(transferObject, value);
                continue;
            }
            throw new RuntimeException("unsupported http header field type: " + httpHeaderField.getType());
        }
    }

    private Field findHttpHeaderField(Class<?> protocolMessageClass, String headerName) {
        Field[] fields;
        if (null == headerName) {
            throw new RuntimeException("header name should not be null");
        }
        for (Field field : fields = protocolMessageClass.getFields()) {
            String fieldHttpHeaderName;
            HttpHeader httpHeaderAnnotation = field.getAnnotation(HttpHeader.class);
            if (null == httpHeaderAnnotation || !headerName.equalsIgnoreCase(fieldHttpHeaderName = httpHeaderAnnotation.value())) continue;
            return field;
        }
        return null;
    }
}

