/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.shared;

import be.fedict.eid.applet.shared.AbstractProtocolMessage;
import be.fedict.eid.applet.shared.FinishedMessage;
import be.fedict.eid.applet.shared.IdentityDataMessageSemanticValidator;
import be.fedict.eid.applet.shared.annotation.HttpBody;
import be.fedict.eid.applet.shared.annotation.HttpHeader;
import be.fedict.eid.applet.shared.annotation.MessageDiscriminator;
import be.fedict.eid.applet.shared.annotation.NotNull;
import be.fedict.eid.applet.shared.annotation.PostConstruct;
import be.fedict.eid.applet.shared.annotation.ProtocolStateAllowed;
import be.fedict.eid.applet.shared.annotation.ResponsesAllowed;
import be.fedict.eid.applet.shared.annotation.ValidateSemanticalIntegrity;
import be.fedict.eid.applet.shared.protocol.ProtocolState;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

@ValidateSemanticalIntegrity(value=IdentityDataMessageSemanticValidator.class)
@ResponsesAllowed(value={FinishedMessage.class})
@ProtocolStateAllowed(value=ProtocolState.IDENTIFY)
public class IdentityDataMessage
extends AbstractProtocolMessage {
    @HttpHeader(value="X-AppletProtocol-Type")
    @MessageDiscriminator
    public static final String TYPE = IdentityDataMessage.class.getSimpleName();
    @HttpHeader(value="X-AppletProtocol-IdentityFileSize")
    @NotNull
    public Integer identityFileSize;
    @HttpHeader(value="X-AppletProtocol-AddressFileSize")
    public Integer addressFileSize;
    @HttpHeader(value="X-AppletProtocol-PhotoFileSize")
    public Integer photoFileSize;
    @HttpHeader(value="X-AppletProtocol-IdentitySignatureFileSize")
    public Integer identitySignatureFileSize;
    @HttpHeader(value="X-AppletProtocol-AddressSignatureFileSize")
    public Integer addressSignatureFileSize;
    @HttpHeader(value="X-AppletProtocol-RrnCertFileSize")
    public Integer rrnCertFileSize;
    @HttpHeader(value="X-AppletProtocol-RootCertFileSize")
    public Integer rootCertFileSize;
    @HttpHeader(value="X-AppletProtocol-AuthnCertFileSize")
    public Integer authnCertFileSize;
    @HttpHeader(value="X-AppletProtocol-SignCertFileSize")
    public Integer signCertFileSize;
    @HttpHeader(value="X-AppletProtocol-CaCertFileSize")
    public Integer caCertFileSize;
    @HttpBody
    @NotNull
    public byte[] body;
    public byte[] idFile;
    public byte[] addressFile;
    public byte[] photoFile;
    public byte[] identitySignatureFile;
    public byte[] addressSignatureFile;
    public byte[] rrnCertFile;
    public byte[] rootCertFile;
    public byte[] authnCertFile;
    public byte[] signCertFile;
    public byte[] caCertFile;

    public IdentityDataMessage() {
    }

    public IdentityDataMessage(byte[] idFile, byte[] addressFile, byte[] photoFile, byte[] identitySignatureFile, byte[] addressSignatureFile, byte[] rrnCertFile, byte[] rootCertFile, byte[] authnCertFile, byte[] signCertFile, byte[] caCertFile) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.identityFileSize = idFile.length;
        baos.write(idFile);
        if (null != addressFile) {
            baos.write(addressFile);
            this.addressFileSize = addressFile.length;
        }
        if (null != photoFile) {
            baos.write(photoFile);
            this.photoFileSize = photoFile.length;
        }
        if (null != identitySignatureFile) {
            baos.write(identitySignatureFile);
            this.identitySignatureFileSize = identitySignatureFile.length;
        }
        if (null != addressSignatureFile) {
            baos.write(addressSignatureFile);
            this.addressSignatureFileSize = addressSignatureFile.length;
        }
        if (null != authnCertFile) {
            baos.write(authnCertFile);
            this.authnCertFileSize = authnCertFile.length;
        }
        if (null != signCertFile) {
            baos.write(signCertFile);
            this.signCertFileSize = signCertFile.length;
        }
        if (null != caCertFile) {
            baos.write(caCertFile);
            this.caCertFileSize = caCertFile.length;
        }
        if (null != rrnCertFile) {
            baos.write(rrnCertFile);
            this.rrnCertFileSize = rrnCertFile.length;
        }
        if (null != rootCertFile) {
            baos.write(rootCertFile);
            this.rootCertFileSize = rootCertFile.length;
        }
        this.body = baos.toByteArray();
    }

    private byte[] copy(byte[] source, int idx, int count) {
        byte[] result = new byte[count];
        System.arraycopy(source, idx, result, 0, count);
        return result;
    }

    @PostConstruct
    public void postConstruct() {
        int idx = 0;
        this.idFile = this.copy(this.body, 0, this.identityFileSize);
        idx += this.identityFileSize.intValue();
        if (null != this.addressFileSize) {
            this.addressFile = this.copy(this.body, idx, this.addressFileSize);
            idx += this.addressFileSize.intValue();
        }
        if (null != this.photoFileSize) {
            this.photoFile = this.copy(this.body, idx, this.photoFileSize);
            idx += this.photoFileSize.intValue();
        }
        if (null != this.identitySignatureFileSize) {
            this.identitySignatureFile = this.copy(this.body, idx, this.identitySignatureFileSize);
            idx += this.identitySignatureFileSize.intValue();
        }
        if (null != this.addressSignatureFileSize) {
            this.addressSignatureFile = this.copy(this.body, idx, this.addressSignatureFileSize);
            idx += this.addressSignatureFileSize.intValue();
        }
        if (null != this.authnCertFileSize) {
            this.authnCertFile = this.copy(this.body, idx, this.authnCertFileSize);
            idx += this.authnCertFileSize.intValue();
        }
        if (null != this.signCertFileSize) {
            this.signCertFile = this.copy(this.body, idx, this.signCertFileSize);
            idx += this.signCertFileSize.intValue();
        }
        if (null != this.caCertFileSize) {
            this.caCertFile = this.copy(this.body, idx, this.caCertFileSize);
            idx += this.caCertFileSize.intValue();
        }
        if (null != this.rrnCertFileSize) {
            this.rrnCertFile = this.copy(this.body, idx, this.rrnCertFileSize);
            idx += this.rrnCertFileSize.intValue();
        }
        if (null != this.rootCertFileSize) {
            this.rootCertFile = this.copy(this.body, idx, this.rootCertFileSize);
            idx += this.rootCertFileSize.intValue();
        }
    }
}

