/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.service.impl.handler;

import be.fedict.eid.applet.service.impl.ServiceLocator;
import be.fedict.eid.applet.service.impl.UserIdentifierUtil;
import be.fedict.eid.applet.service.impl.handler.HandlesMessage;
import be.fedict.eid.applet.service.impl.handler.InitParam;
import be.fedict.eid.applet.service.impl.handler.MessageHandler;
import be.fedict.eid.applet.service.spi.AuditService;
import be.fedict.eid.applet.service.spi.CertificateSecurityException;
import be.fedict.eid.applet.service.spi.ExpiredCertificateSecurityException;
import be.fedict.eid.applet.service.spi.RevokedCertificateSecurityException;
import be.fedict.eid.applet.service.spi.SignatureService;
import be.fedict.eid.applet.service.spi.TrustCertificateSecurityException;
import be.fedict.eid.applet.shared.ErrorCode;
import be.fedict.eid.applet.shared.FinishedMessage;
import be.fedict.eid.applet.shared.SignatureDataMessage;
import java.io.ByteArrayOutputStream;
import java.lang.reflect.Method;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.X509Certificate;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

@HandlesMessage(value=SignatureDataMessage.class)
public class SignatureDataMessageHandler
implements MessageHandler<SignatureDataMessage> {
    private static final Log LOG = LogFactory.getLog(SignatureDataMessageHandler.class);
    public static final byte[] SHA1_DIGEST_INFO_PREFIX = new byte[]{48, 33, 48, 9, 6, 5, 43, 14, 3, 2, 26, 5, 0, 4, 20};
    public static final byte[] SHA224_DIGEST_INFO_PREFIX = new byte[]{48, 45, 48, 13, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 4, 5, 0, 4, 28};
    public static final byte[] SHA256_DIGEST_INFO_PREFIX = new byte[]{48, 49, 48, 13, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 1, 5, 0, 4, 32};
    public static final byte[] SHA384_DIGEST_INFO_PREFIX = new byte[]{48, 65, 48, 13, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 2, 5, 0, 4, 48};
    public static final byte[] SHA512_DIGEST_INFO_PREFIX = new byte[]{48, 81, 48, 13, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 3, 5, 0, 4, 64};
    public static final byte[] RIPEMD160_DIGEST_INFO_PREFIX = new byte[]{48, 33, 48, 9, 6, 5, 43, 36, 3, 2, 1, 5, 0, 4, 20};
    public static final byte[] RIPEMD128_DIGEST_INFO_PREFIX = new byte[]{48, 29, 48, 9, 6, 5, 43, 36, 3, 2, 2, 5, 0, 4, 16};
    public static final byte[] RIPEMD256_DIGEST_INFO_PREFIX = new byte[]{48, 45, 48, 9, 6, 5, 43, 36, 3, 2, 3, 5, 0, 4, 32};
    @InitParam(value="SignatureService")
    private ServiceLocator<SignatureService> signatureServiceLocator;
    @InitParam(value="AuditService")
    private ServiceLocator<AuditService> auditServiceLocator;
    public static final String DIGEST_VALUE_SESSION_ATTRIBUTE = SignatureDataMessageHandler.class.getName() + ".digestValue";
    public static final String DIGEST_ALGO_SESSION_ATTRIBUTE = SignatureDataMessageHandler.class.getName() + ".digestAlgo";

    @Override
    public Object handleMessage(SignatureDataMessage message, Map<String, String> httpHeaders, HttpServletRequest request, HttpSession session) throws ServletException {
        X509Certificate signingCertificate;
        List certificateChain;
        byte[] signatureValue;
        block40: {
            Signature signature;
            LOG.debug((Object)"signature data message received");
            signatureValue = message.signatureValue;
            certificateChain = message.certificateChain;
            if (certificateChain.isEmpty()) {
                throw new ServletException("certificate chain is empty");
            }
            signingCertificate = (X509Certificate)certificateChain.get(0);
            if (null == signingCertificate) {
                throw new ServletException("non-repudiation certificate missing");
            }
            LOG.debug((Object)("non-repudiation signing certificate: " + signingCertificate.getSubjectX500Principal()));
            PublicKey signingPublicKey = signingCertificate.getPublicKey();
            String digestAlgo = SignatureDataMessageHandler.getDigestAlgo(session);
            byte[] expectedDigestValue = SignatureDataMessageHandler.getDigestValue(session);
            if (digestAlgo.endsWith("-PSS")) {
                LOG.debug((Object)"verifying RSA/PSS signature");
                try {
                    signature = Signature.getInstance("RAWRSASSA-PSS", BouncyCastleProvider.PROVIDER_NAME);
                    if ("SHA-256-PSS".equals(digestAlgo)) {
                        LOG.debug((Object)"RSA/PSS SHA256");
                        signature.setParameter(new PSSParameterSpec("SHA-256", "MGF1", new MGF1ParameterSpec("SHA-256"), 32, 1));
                    }
                    signature.initVerify(signingPublicKey);
                    signature.update(expectedDigestValue);
                    boolean result = signature.verify(signatureValue);
                    if (!result) {
                        throw new SecurityException("signature incorrect");
                    }
                    break block40;
                }
                catch (Exception e) {
                    LOG.debug((Object)("signature verification error: " + e.getMessage()), (Throwable)e);
                    throw new ServletException("signature verification error: " + e.getMessage(), (Throwable)e);
                }
            }
            try {
                signature = Signature.getInstance("RawRSA", BouncyCastleProvider.PROVIDER_NAME);
                signature.initVerify(signingPublicKey);
                ByteArrayOutputStream digestInfo = new ByteArrayOutputStream();
                if ("SHA-1".equals(digestAlgo) || "SHA1".equals(digestAlgo)) {
                    digestInfo.write(SHA1_DIGEST_INFO_PREFIX);
                } else if ("SHA-224".equals(digestAlgo)) {
                    digestInfo.write(SHA224_DIGEST_INFO_PREFIX);
                } else if ("SHA-256".equals(digestAlgo)) {
                    digestInfo.write(SHA256_DIGEST_INFO_PREFIX);
                } else if ("SHA-384".equals(digestAlgo)) {
                    digestInfo.write(SHA384_DIGEST_INFO_PREFIX);
                } else if ("SHA-512".equals(digestAlgo)) {
                    digestInfo.write(SHA512_DIGEST_INFO_PREFIX);
                } else if ("RIPEMD160".equals(digestAlgo)) {
                    digestInfo.write(RIPEMD160_DIGEST_INFO_PREFIX);
                } else if ("RIPEMD128".equals(digestAlgo)) {
                    digestInfo.write(RIPEMD128_DIGEST_INFO_PREFIX);
                } else if ("RIPEMD256".equals(digestAlgo)) {
                    digestInfo.write(RIPEMD256_DIGEST_INFO_PREFIX);
                }
                digestInfo.write(expectedDigestValue);
                signature.update(digestInfo.toByteArray());
                boolean result = signature.verify(signatureValue);
                if (!result) {
                    AuditService auditService = this.auditServiceLocator.locateService();
                    if (null != auditService) {
                        String remoteAddress = request.getRemoteAddr();
                        auditService.signatureError(remoteAddress, signingCertificate);
                    }
                    throw new SecurityException("signature incorrect");
                }
            }
            catch (Exception e) {
                LOG.debug((Object)("signature verification error: " + e.getMessage()));
                throw new ServletException("signature verification error: " + e.getMessage(), (Throwable)e);
            }
        }
        AuditService auditService = this.auditServiceLocator.locateService();
        if (null != auditService) {
            String userId = UserIdentifierUtil.getUserId(signingCertificate);
            auditService.signed(userId);
        }
        SignatureService signatureService = this.signatureServiceLocator.locateService();
        try {
            signatureService.postSign(signatureValue, certificateChain);
        }
        catch (ExpiredCertificateSecurityException e) {
            return new FinishedMessage(ErrorCode.CERTIFICATE_EXPIRED);
        }
        catch (RevokedCertificateSecurityException e) {
            return new FinishedMessage(ErrorCode.CERTIFICATE_REVOKED);
        }
        catch (TrustCertificateSecurityException e) {
            return new FinishedMessage(ErrorCode.CERTIFICATE_NOT_TRUSTED);
        }
        catch (CertificateSecurityException e) {
            return new FinishedMessage(ErrorCode.CERTIFICATE);
        }
        catch (Exception e) {
            if ("javax.ejb.EJBException".equals(e.getClass().getName())) {
                Exception exception;
                try {
                    Method getCausedByExceptionMethod = e.getClass().getMethod("getCausedByException", new Class[0]);
                    exception = (Exception)getCausedByExceptionMethod.invoke((Object)e, new Object[0]);
                }
                catch (Exception e2) {
                    LOG.debug((Object)("error: " + e.getMessage()), (Throwable)e);
                    throw new SecurityException("error retrieving the root cause: " + e2.getMessage());
                }
                if (exception instanceof ExpiredCertificateSecurityException) {
                    return new FinishedMessage(ErrorCode.CERTIFICATE_EXPIRED);
                }
                if (exception instanceof RevokedCertificateSecurityException) {
                    return new FinishedMessage(ErrorCode.CERTIFICATE_REVOKED);
                }
                if (exception instanceof TrustCertificateSecurityException) {
                    return new FinishedMessage(ErrorCode.CERTIFICATE_NOT_TRUSTED);
                }
                if (exception instanceof CertificateSecurityException) {
                    return new FinishedMessage(ErrorCode.CERTIFICATE);
                }
            }
            throw new SecurityException("signature service error: " + e.getMessage(), e);
        }
        return new FinishedMessage();
    }

    @Override
    public void init(ServletConfig config) throws ServletException {
    }

    public static byte[] getDigestValue(HttpSession session) {
        return (byte[])session.getAttribute(DIGEST_VALUE_SESSION_ATTRIBUTE);
    }

    public static void setDigestValue(byte[] digestValue, String digestAlgo, HttpSession session) {
        session.setAttribute(DIGEST_VALUE_SESSION_ATTRIBUTE, (Object)digestValue);
        session.setAttribute(DIGEST_ALGO_SESSION_ATTRIBUTE, (Object)digestAlgo);
    }

    public static String getDigestAlgo(HttpSession session) {
        String digestAlgo = (String)session.getAttribute(DIGEST_ALGO_SESSION_ATTRIBUTE);
        return digestAlgo;
    }
}

