/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.service.impl.handler;

import be.fedict.eid.applet.service.Address;
import be.fedict.eid.applet.service.EIdCertsData;
import be.fedict.eid.applet.service.EIdData;
import be.fedict.eid.applet.service.Identity;
import be.fedict.eid.applet.service.impl.RequestContext;
import be.fedict.eid.applet.service.impl.ServiceLocator;
import be.fedict.eid.applet.service.impl.handler.HandlesMessage;
import be.fedict.eid.applet.service.impl.handler.InitParam;
import be.fedict.eid.applet.service.impl.handler.MessageHandler;
import be.fedict.eid.applet.service.impl.tlv.TlvParser;
import be.fedict.eid.applet.service.spi.AuditService;
import be.fedict.eid.applet.service.spi.CertificateSecurityException;
import be.fedict.eid.applet.service.spi.ExpiredCertificateSecurityException;
import be.fedict.eid.applet.service.spi.IdentityIntegrityService;
import be.fedict.eid.applet.service.spi.RevokedCertificateSecurityException;
import be.fedict.eid.applet.service.spi.TrustCertificateSecurityException;
import be.fedict.eid.applet.shared.ErrorCode;
import be.fedict.eid.applet.shared.FinishedMessage;
import be.fedict.eid.applet.shared.IdentityDataMessage;
import java.io.ByteArrayInputStream;
import java.lang.reflect.Method;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@HandlesMessage(value=IdentityDataMessage.class)
public class IdentityDataMessageHandler
implements MessageHandler<IdentityDataMessage> {
    private static final Log LOG = LogFactory.getLog(IdentityDataMessageHandler.class);
    public static final String IDENTITY_SESSION_ATTRIBUTE = "eid.identity";
    public static final String ADDRESS_SESSION_ATTRIBUTE = "eid.address";
    public static final String PHOTO_SESSION_ATTRIBUTE = "eid.photo";
    public static final String EID_SESSION_ATTRIBUTE = "eid";
    public static final String EID_CERTS_SESSION_ATTRIBUTE = "eid.certs";
    public static final String AUTHN_CERT_SESSION_ATTRIBUTE = "eid.certs.authn";
    public static final String SIGN_CERT_SESSION_ATTRIBUTE = "eid.certs.sign";
    public static final String CA_CERT_SESSION_ATTRIBUTE = "eid.certs.ca";
    public static final String ROOT_CERT_SESSION_ATTRIBTUE = "eid.certs.root";
    public static final String ROOT_CERT_SESSION_ATTRIBUTE = "eid.certs.root";
    public static final String SKIP_NATIONAL_NUMBER_CHECK_INIT_PARAM_NAME = "SkipNationalNumberCheck";
    public static final String INCLUDE_DATA_FILES = "IncludeDataFiles";
    public static final String EID_DATA_IDENTITY_SESSION_ATTRIBUTE = "eid.data.identity";
    public static final String EID_DATA_ADDRESS_SESSION_ATTRIBUTE = "eid.data.address";
    @InitParam(value="SkipNationalNumberCheck")
    private boolean skipNationalNumberCheck;
    @InitParam(value="IdentityIntegrityService")
    private ServiceLocator<IdentityIntegrityService> identityIntegrityServiceLocator;
    @InitParam(value="AuditService")
    private ServiceLocator<AuditService> auditServiceLocator;
    @InitParam(value="IncludeDataFiles")
    private boolean includeDataFiles;

    @Override
    public Object handleMessage(IdentityDataMessage message, Map<String, String> httpHeaders, HttpServletRequest request, HttpSession session) throws ServletException {
        AuditService auditService;
        EIdData eidData;
        Date cardValidityDateEndDate;
        Date now;
        GregorianCalendar cardValidityDateEndGregorianCalendar;
        IdentityIntegrityService identityIntegrityService;
        Address address;
        LOG.debug((Object)"received identity data");
        LOG.debug((Object)("identity file size: " + message.idFile.length));
        Identity identity = TlvParser.parse(message.idFile, Identity.class);
        RequestContext requestContext = new RequestContext(session);
        boolean includeAddress = requestContext.includeAddress();
        boolean includeCertificates = requestContext.includeCertificates();
        boolean includePhoto = requestContext.includePhoto();
        if (null != message.addressFile) {
            LOG.debug((Object)("address file size: " + message.addressFile.length));
            if (!includeAddress) {
                throw new ServletException("Address included while not requested");
            }
            address = TlvParser.parse(message.addressFile, Address.class);
        } else {
            if (includeAddress) {
                throw new ServletException("Address not included while requested");
            }
            address = null;
        }
        X509Certificate authnCert = null;
        X509Certificate signCert = null;
        X509Certificate caCert = null;
        X509Certificate rootCert = null;
        if (includeCertificates) {
            if (null == message.authnCertFile) {
                throw new ServletException("authn cert not included while requested");
            }
            if (null == message.signCertFile) {
                throw new ServletException("sign cert not included while requested");
            }
            if (null == message.caCertFile) {
                throw new ServletException("CA cert not included while requested");
            }
            if (null == message.rootCertFile) {
                throw new ServletException("root cert not included while requested");
            }
            authnCert = this.getCertificate(message.authnCertFile);
            signCert = this.getCertificate(message.signCertFile);
            caCert = this.getCertificate(message.caCertFile);
            rootCert = this.getCertificate(message.rootCertFile);
        }
        if (null != (identityIntegrityService = this.identityIntegrityServiceLocator.locateService())) {
            String authnUserId;
            if (null == message.identitySignatureFile) {
                throw new ServletException("identity signature data not included while request");
            }
            LOG.debug((Object)("identity signature file size: " + message.identitySignatureFile.length));
            if (includeAddress) {
                if (null == message.addressSignatureFile) {
                    throw new ServletException("address signature data not included while requested");
                }
                LOG.debug((Object)("address signature file size: " + message.addressSignatureFile.length));
            }
            if (null == message.rrnCertFile) {
                throw new ServletException("national registry certificate not included while requested");
            }
            LOG.debug((Object)("RRN certificate file size: " + message.rrnCertFile.length));
            X509Certificate rrnCertificate = this.getCertificate(message.rrnCertFile);
            PublicKey rrnPublicKey = rrnCertificate.getPublicKey();
            this.verifySignature(rrnCertificate.getSigAlgName(), message.identitySignatureFile, rrnPublicKey, request, new byte[][]{message.idFile});
            if (!this.skipNationalNumberCheck && null != (authnUserId = (String)session.getAttribute("eid.identifier")) && !authnUserId.equals(identity.nationalNumber)) {
                throw new ServletException("national number mismatch");
            }
            if (includeAddress) {
                byte[] addressFile = this.trimRight(message.addressFile);
                this.verifySignature(rrnCertificate.getSigAlgName(), message.addressSignatureFile, rrnPublicKey, request, addressFile, message.identitySignatureFile);
            }
            LOG.debug((Object)("checking national registration certificate: " + rrnCertificate.getSubjectX500Principal()));
            X509Certificate rootCertificate = this.getCertificate(message.rootCertFile);
            LinkedList<X509Certificate> rrnCertificateChain = new LinkedList<X509Certificate>();
            rrnCertificateChain.add(rrnCertificate);
            rrnCertificateChain.add(rootCertificate);
            try {
                identityIntegrityService.checkNationalRegistrationCertificate(rrnCertificateChain);
            }
            catch (ExpiredCertificateSecurityException e) {
                return new FinishedMessage(ErrorCode.CERTIFICATE_EXPIRED);
            }
            catch (RevokedCertificateSecurityException e) {
                return new FinishedMessage(ErrorCode.CERTIFICATE_REVOKED);
            }
            catch (TrustCertificateSecurityException e) {
                return new FinishedMessage(ErrorCode.CERTIFICATE_NOT_TRUSTED);
            }
            catch (CertificateSecurityException e) {
                return new FinishedMessage(ErrorCode.CERTIFICATE);
            }
            catch (Exception e) {
                if ("javax.ejb.EJBException".equals(e.getClass().getName())) {
                    Exception exception;
                    try {
                        Method getCausedByExceptionMethod = e.getClass().getMethod("getCausedByException", new Class[0]);
                        exception = (Exception)getCausedByExceptionMethod.invoke((Object)e, new Object[0]);
                    }
                    catch (Exception e2) {
                        LOG.debug((Object)("error: " + e.getMessage()), (Throwable)e);
                        throw new SecurityException("error retrieving the root cause: " + e2.getMessage());
                    }
                    if (exception instanceof ExpiredCertificateSecurityException) {
                        return new FinishedMessage(ErrorCode.CERTIFICATE_EXPIRED);
                    }
                    if (exception instanceof RevokedCertificateSecurityException) {
                        return new FinishedMessage(ErrorCode.CERTIFICATE_REVOKED);
                    }
                    if (exception instanceof TrustCertificateSecurityException) {
                        return new FinishedMessage(ErrorCode.CERTIFICATE_NOT_TRUSTED);
                    }
                    if (exception instanceof CertificateSecurityException) {
                        return new FinishedMessage(ErrorCode.CERTIFICATE);
                    }
                }
                throw new SecurityException("error checking the NRN certificate: " + e.getMessage(), e);
            }
        }
        if (null != message.photoFile) {
            LOG.debug((Object)("photo file size: " + message.photoFile.length));
            if (!includePhoto) {
                throw new ServletException("photo include while not requested");
            }
            byte[] expectedPhotoDigest = identity.photoDigest;
            byte[] actualPhotoDigest = this.digestPhoto(this.getDigestAlgo(expectedPhotoDigest.length), message.photoFile);
            if (!Arrays.equals(expectedPhotoDigest, actualPhotoDigest)) {
                throw new ServletException("photo digest incorrect");
            }
        } else if (includePhoto) {
            throw new ServletException("photo not included while requested");
        }
        if (null != (cardValidityDateEndGregorianCalendar = identity.getCardValidityDateEnd()) && (now = new Date()).after(cardValidityDateEndDate = cardValidityDateEndGregorianCalendar.getTime())) {
            throw new SecurityException("eID card has expired");
        }
        session.setAttribute(IDENTITY_SESSION_ATTRIBUTE, (Object)identity);
        if (null != address) {
            session.setAttribute(ADDRESS_SESSION_ATTRIBUTE, (Object)address);
        }
        if (null != message.photoFile) {
            session.setAttribute(PHOTO_SESSION_ATTRIBUTE, (Object)message.photoFile);
        }
        if (includeCertificates) {
            session.setAttribute(AUTHN_CERT_SESSION_ATTRIBUTE, (Object)authnCert);
            session.setAttribute(SIGN_CERT_SESSION_ATTRIBUTE, (Object)signCert);
            session.setAttribute(CA_CERT_SESSION_ATTRIBUTE, (Object)caCert);
            session.setAttribute("eid.certs.root", (Object)rootCert);
        }
        if (null == (eidData = (EIdData)session.getAttribute(EID_SESSION_ATTRIBUTE))) {
            eidData = new EIdData();
            session.setAttribute(EID_SESSION_ATTRIBUTE, (Object)eidData);
        }
        eidData.identity = identity;
        eidData.address = address;
        eidData.photo = message.photoFile;
        if (includeCertificates) {
            EIdCertsData eidCertsData = new EIdCertsData();
            session.setAttribute(EID_CERTS_SESSION_ATTRIBUTE, (Object)eidCertsData);
            eidData.certs = eidCertsData;
            eidCertsData.authn = authnCert;
            eidCertsData.sign = signCert;
            eidCertsData.ca = caCert;
            eidCertsData.root = rootCert;
            session.setAttribute(AUTHN_CERT_SESSION_ATTRIBUTE, (Object)authnCert);
            session.setAttribute(SIGN_CERT_SESSION_ATTRIBUTE, (Object)signCert);
            session.setAttribute(CA_CERT_SESSION_ATTRIBUTE, (Object)caCert);
            session.setAttribute("eid.certs.root", (Object)rootCert);
        }
        if (this.includeDataFiles) {
            session.setAttribute(EID_DATA_IDENTITY_SESSION_ATTRIBUTE, (Object)message.idFile);
            session.setAttribute(EID_DATA_ADDRESS_SESSION_ATTRIBUTE, (Object)message.addressFile);
        }
        if (null != (auditService = this.auditServiceLocator.locateService())) {
            String userId = identity.nationalNumber;
            auditService.identified(userId);
        }
        return new FinishedMessage();
    }

    private byte[] trimRight(byte[] addressFile) {
        int idx;
        for (idx = 0; idx < addressFile.length && 0 != addressFile[idx]; ++idx) {
        }
        byte[] result = new byte[idx];
        System.arraycopy(addressFile, 0, result, 0, idx);
        return result;
    }

    private void verifySignature(String signAlgo, byte[] signatureData, PublicKey publicKey, HttpServletRequest request, byte[] ... data) throws ServletException {
        Signature signature;
        try {
            signature = Signature.getInstance(signAlgo);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ServletException("algo error: " + e.getMessage(), (Throwable)e);
        }
        try {
            signature.initVerify(publicKey);
        }
        catch (InvalidKeyException e) {
            throw new ServletException("key error: " + e.getMessage(), (Throwable)e);
        }
        try {
            for (byte[] dataItem : data) {
                signature.update(dataItem);
            }
            boolean result = signature.verify(signatureData);
            if (!result) {
                AuditService auditService = this.auditServiceLocator.locateService();
                if (null != auditService) {
                    String remoteAddress = request.getRemoteAddr();
                    auditService.identityIntegrityError(remoteAddress);
                }
                throw new ServletException("signature incorrect");
            }
        }
        catch (SignatureException e) {
            AuditService auditService = this.auditServiceLocator.locateService();
            if (null != auditService) {
                String remoteAddress = request.getRemoteAddr();
                auditService.identityIntegrityError(remoteAddress);
            }
            throw new ServletException("signature error: " + e.getMessage(), (Throwable)e);
        }
    }

    private X509Certificate getCertificate(byte[] certFile) {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X509");
            X509Certificate certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(certFile));
            return certificate;
        }
        catch (CertificateException e) {
            LOG.warn((Object)("certificate error: " + e.getMessage()), (Throwable)e);
            LOG.debug((Object)("certificate size: " + certFile.length));
            LOG.debug((Object)("certificate file content: " + Hex.encodeHexString((byte[])certFile)));
            if (1300 == certFile.length) {
                boolean missingCertificate = true;
                for (int idx = 0; idx < certFile.length; ++idx) {
                    if (0 == certFile[idx]) continue;
                    missingCertificate = false;
                }
                if (missingCertificate) {
                    LOG.debug((Object)"the certificate data indicates a missing certificate");
                }
            }
            return null;
        }
    }

    private byte[] digestPhoto(String digestAlgoName, byte[] photoFile) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance(digestAlgoName);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("digest error: " + e.getMessage(), e);
        }
        byte[] photoDigest = messageDigest.digest(photoFile);
        return photoDigest;
    }

    private String getDigestAlgo(int hashSize) throws RuntimeException {
        switch (hashSize) {
            case 20: {
                return "SHA-1";
            }
            case 28: {
                return "SHA-224";
            }
            case 32: {
                return "SHA-256";
            }
            case 48: {
                return "SHA-384";
            }
            case 64: {
                return "SHA-512";
            }
        }
        throw new RuntimeException("Failed to find guess algorithm for hash size of " + hashSize + " bytes");
    }

    @Override
    public void init(ServletConfig config) throws ServletException {
    }
}

