/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.service.impl.handler;

import be.fedict.eid.applet.service.impl.AuthenticationChallenge;
import be.fedict.eid.applet.service.impl.RequestContext;
import be.fedict.eid.applet.service.impl.ServiceLocator;
import be.fedict.eid.applet.service.impl.handler.HandlesMessage;
import be.fedict.eid.applet.service.impl.handler.InitParam;
import be.fedict.eid.applet.service.impl.handler.MessageHandler;
import be.fedict.eid.applet.service.impl.handler.SignatureDataMessageHandler;
import be.fedict.eid.applet.service.spi.AuthenticationService;
import be.fedict.eid.applet.service.spi.AuthorizationException;
import be.fedict.eid.applet.service.spi.DigestInfo;
import be.fedict.eid.applet.service.spi.IdentityIntegrityService;
import be.fedict.eid.applet.service.spi.IdentityRequest;
import be.fedict.eid.applet.service.spi.IdentityService;
import be.fedict.eid.applet.service.spi.PrivacyService;
import be.fedict.eid.applet.service.spi.SecureCardReaderService;
import be.fedict.eid.applet.service.spi.SecureClientEnvironmentService;
import be.fedict.eid.applet.service.spi.SignatureService;
import be.fedict.eid.applet.shared.AdministrationMessage;
import be.fedict.eid.applet.shared.AuthenticationRequestMessage;
import be.fedict.eid.applet.shared.CheckClientMessage;
import be.fedict.eid.applet.shared.ErrorCode;
import be.fedict.eid.applet.shared.FilesDigestRequestMessage;
import be.fedict.eid.applet.shared.FinishedMessage;
import be.fedict.eid.applet.shared.HelloMessage;
import be.fedict.eid.applet.shared.IdentificationRequestMessage;
import be.fedict.eid.applet.shared.SignCertificatesRequestMessage;
import be.fedict.eid.applet.shared.SignRequestMessage;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@HandlesMessage(value=HelloMessage.class)
public class HelloMessageHandler
implements MessageHandler<HelloMessage> {
    private static final Log LOG = LogFactory.getLog(HelloMessageHandler.class);
    public static final String INCLUDE_IDENTITY_INIT_PARAM_NAME = "IncludeIdentity";
    public static final String INCLUDE_PHOTO_INIT_PARAM_NAME = "IncludePhoto";
    public static final String INCLUDE_CERTS_INIT_PARAM_NAME = "IncludeCertificates";
    public static final String INCLUDE_ADDRESS_INIT_PARAM_NAME = "IncludeAddress";
    public static final String SECURE_CLIENT_ENV_SERVICE_INIT_PARAM_NAME = "SecureClientEnvironmentService";
    public static final String IDENTITY_INTEGRITY_SERVICE_INIT_PARAM_NAME = "IdentityIntegrityService";
    public static final String SIGNATURE_SERVICE_INIT_PARAM_NAME = "SignatureService";
    public static final String PRIVACY_SERVICE_INIT_PARAM_NAME = "PrivacyService";
    public static final String REMOVE_CARD_INIT_PARAM_NAME = "RemoveCard";
    public static final String HOSTNAME_INIT_PARAM_NAME = "Hostname";
    public static final String INET_ADDRESS_INIT_PARAM_NAME = "InetAddress";
    public static final String CHANGE_PIN_INIT_PARAM_NAME = "ChangePin";
    public static final String UNBLOCK_PIN_INIT_PARAM_NAME = "UnblockPin";
    public static final String LOGOFF_INIT_PARAM_NAME = "Logoff";
    public static final String PRE_LOGOFF_INIT_PARAM_NAME = "PreLogoff";
    public static final String SESSION_ID_CHANNEL_BINDING_INIT_PARAM_NAME = "SessionIdChannelBinding";
    public static final String CHANNEL_BINDING_SERVER_CERTIFICATE = "ChannelBindingServerCertificate";
    public static final String CHANNEL_BINDING_SERVICE = "ChannelBindingService";
    public static final String REQUIRE_SECURE_READER_INIT_PARAM_NAME = "RequireSecureReader";
    public static final String IDENTITY_SERVICE_INIT_PARAM_NAME = "IdentityService";
    public static final String SECURE_CARD_READER_SERVICE_INIT_PARAM_NAME = "SecureCardReaderService";
    @InitParam(value="IncludePhoto")
    private boolean includePhoto;
    @InitParam(value="IncludeAddress")
    private boolean includeAddress;
    @InitParam(value="IncludeIdentity")
    private boolean includeIdentity;
    @InitParam(value="RemoveCard")
    private boolean removeCard;
    private boolean includeHostname;
    private boolean includeInetAddress;
    @InitParam(value="ChangePin")
    private boolean changePin;
    @InitParam(value="UnblockPin")
    private boolean unblockPin;
    @InitParam(value="Logoff")
    private boolean logoff;
    @InitParam(value="PreLogoff")
    private boolean preLogoff;
    @InitParam(value="IncludeCertificates")
    private boolean includeCertificates;
    @InitParam(value="SessionIdChannelBinding")
    private boolean sessionIdChannelBinding;
    private boolean serverCertificateChannelBinding;
    @InitParam(value="RequireSecureReader")
    private boolean requireSecureReader;
    @InitParam(value="SecureClientEnvironmentService")
    private ServiceLocator<SecureClientEnvironmentService> secureClientEnvServiceLocator;
    @InitParam(value="IdentityIntegrityService")
    private ServiceLocator<IdentityIntegrityService> identityIntegrityServiceLocator;
    @InitParam(value="AuthenticationService")
    private ServiceLocator<AuthenticationService> authenticationServiceLocator;
    @InitParam(value="SignatureService")
    private ServiceLocator<SignatureService> signatureServiceLocator;
    @InitParam(value="PrivacyService")
    private ServiceLocator<PrivacyService> privacyServiceLocator;
    @InitParam(value="IdentityService")
    private ServiceLocator<IdentityService> identityServiceLocator;
    @InitParam(value="SecureCardReaderService")
    private ServiceLocator<SecureCardReaderService> secureCardReaderServiceLocator;
    private static final String CLIENT_LANGUAGE_SESSION_ATTRIBUTE = HelloMessageHandler.class.getName() + ".clientLanguage";

    @Override
    public Object handleMessage(HelloMessage message, Map<String, String> httpHeaders, HttpServletRequest request, HttpSession session) throws ServletException {
        boolean removeCard;
        boolean includeCertificates;
        boolean includePhoto;
        boolean includeAddress;
        LOG.debug((Object)"hello message received");
        this.storeClientLanguage(message.language, session);
        SecureClientEnvironmentService secureClientEnvService = this.secureClientEnvServiceLocator.locateService();
        if (null != secureClientEnvService) {
            CheckClientMessage checkClientMessage = new CheckClientMessage();
            return checkClientMessage;
        }
        if (this.changePin || this.unblockPin) {
            AdministrationMessage administrationMessage = new AdministrationMessage(this.changePin, this.unblockPin, this.logoff, this.removeCard, this.requireSecureReader);
            return administrationMessage;
        }
        SignatureService signatureService = this.signatureServiceLocator.locateService();
        if (null != signatureService) {
            boolean removeCard2;
            DigestInfo digestInfo;
            String filesDigestAlgo = signatureService.getFilesDigestAlgorithm();
            if (null != filesDigestAlgo) {
                LOG.debug((Object)("files digest algo: " + filesDigestAlgo));
                FilesDigestRequestMessage filesDigestRequestMessage = new FilesDigestRequestMessage();
                filesDigestRequestMessage.digestAlgo = filesDigestAlgo;
                return filesDigestRequestMessage;
            }
            if (this.includeCertificates) {
                boolean includePhoto2;
                boolean includeAddress2;
                boolean includeIdentity;
                LOG.debug((Object)"include signing certificate chain during pre-sign");
                IdentityIntegrityService identityIntegrityService = this.identityIntegrityServiceLocator.locateService();
                boolean includeIntegrityData = null != identityIntegrityService;
                IdentityService identityService = this.identityServiceLocator.locateService();
                if (null != identityService) {
                    IdentityRequest identityRequest = identityService.getIdentityRequest();
                    includeIdentity = identityRequest.includeIdentity();
                    includeAddress2 = identityRequest.includeAddress();
                    includePhoto2 = identityRequest.includePhoto();
                } else {
                    includeIdentity = this.includeIdentity;
                    includeAddress2 = this.includeAddress;
                    includePhoto2 = this.includePhoto;
                }
                RequestContext requestContext = new RequestContext(session);
                requestContext.setIncludeIdentity(includeIdentity);
                requestContext.setIncludeAddress(includeAddress2);
                requestContext.setIncludePhoto(includePhoto2);
                SignCertificatesRequestMessage signCertificatesRequestMessage = new SignCertificatesRequestMessage(includeIdentity, includeAddress2, includePhoto2, includeIntegrityData);
                return signCertificatesRequestMessage;
            }
            try {
                digestInfo = signatureService.preSign(null, null, null, null, null);
            }
            catch (NoSuchAlgorithmException e) {
                throw new ServletException("no such algo: " + e.getMessage(), (Throwable)e);
            }
            catch (AuthorizationException e) {
                return new FinishedMessage(ErrorCode.AUTHORIZATION);
            }
            SignatureDataMessageHandler.setDigestValue(digestInfo.digestValue, digestInfo.digestAlgo, session);
            IdentityService identityService = this.identityServiceLocator.locateService();
            if (null != identityService) {
                IdentityRequest identityRequest = identityService.getIdentityRequest();
                removeCard2 = identityRequest.removeCard();
            } else {
                removeCard2 = this.removeCard;
            }
            SignRequestMessage signRequestMessage = new SignRequestMessage(digestInfo.digestValue, digestInfo.digestAlgo, digestInfo.description, this.logoff, removeCard2, this.requireSecureReader);
            return signRequestMessage;
        }
        AuthenticationService authenticationService = this.authenticationServiceLocator.locateService();
        if (null != authenticationService) {
            boolean removeCard3;
            boolean includeCertificates2;
            boolean includePhoto3;
            boolean includeAddress3;
            boolean includeIdentity;
            byte[] challenge = AuthenticationChallenge.generateChallenge(session);
            IdentityIntegrityService identityIntegrityService = this.identityIntegrityServiceLocator.locateService();
            boolean includeIntegrityData = null != identityIntegrityService;
            IdentityService identityService = this.identityServiceLocator.locateService();
            if (null != identityService) {
                IdentityRequest identityRequest = identityService.getIdentityRequest();
                includeIdentity = identityRequest.includeIdentity();
                includeAddress3 = identityRequest.includeAddress();
                includePhoto3 = identityRequest.includePhoto();
                includeCertificates2 = identityRequest.includeCertificates();
                removeCard3 = identityRequest.removeCard();
            } else {
                includeIdentity = this.includeIdentity;
                includeAddress3 = this.includeAddress;
                includePhoto3 = this.includePhoto;
                includeCertificates2 = this.includeCertificates;
                removeCard3 = this.removeCard;
            }
            RequestContext requestContext = new RequestContext(session);
            requestContext.setIncludeIdentity(includeIdentity);
            requestContext.setIncludeAddress(includeAddress3);
            requestContext.setIncludePhoto(includePhoto3);
            requestContext.setIncludeCertificates(includeCertificates2);
            String transactionMessage = null;
            SecureCardReaderService secureCardReaderService = this.secureCardReaderServiceLocator.locateService();
            if (null != secureCardReaderService) {
                transactionMessage = secureCardReaderService.getTransactionMessage();
                if (null != transactionMessage && transactionMessage.length() > 64) {
                    transactionMessage = transactionMessage.substring(0, 64);
                }
                LOG.debug((Object)("transaction message: " + transactionMessage));
            }
            requestContext.setTransactionMessage(transactionMessage);
            AuthenticationRequestMessage authenticationRequestMessage = new AuthenticationRequestMessage(challenge, this.includeHostname, this.includeInetAddress, this.logoff, this.preLogoff, removeCard3, this.sessionIdChannelBinding, this.serverCertificateChannelBinding, includeIdentity, includeCertificates2, includeAddress3, includePhoto3, includeIntegrityData, this.requireSecureReader, transactionMessage);
            return authenticationRequestMessage;
        }
        IdentityIntegrityService identityIntegrityService = this.identityIntegrityServiceLocator.locateService();
        boolean includeIntegrityData = null != identityIntegrityService;
        PrivacyService privacyService = this.privacyServiceLocator.locateService();
        String identityDataUsage = null != privacyService ? privacyService.getIdentityDataUsage(message.language) : null;
        IdentityService identityService = this.identityServiceLocator.locateService();
        if (null != identityService) {
            IdentityRequest identityRequest = identityService.getIdentityRequest();
            includeAddress = identityRequest.includeAddress();
            includePhoto = identityRequest.includePhoto();
            includeCertificates = identityRequest.includeCertificates();
            removeCard = identityRequest.removeCard();
        } else {
            includeAddress = this.includeAddress;
            includePhoto = this.includePhoto;
            includeCertificates = this.includeCertificates;
            removeCard = this.removeCard;
        }
        RequestContext requestContext = new RequestContext(session);
        requestContext.setIncludeAddress(includeAddress);
        requestContext.setIncludePhoto(includePhoto);
        requestContext.setIncludeCertificates(includeCertificates);
        IdentificationRequestMessage responseMessage = new IdentificationRequestMessage(includeAddress, includePhoto, includeIntegrityData, includeCertificates, removeCard, identityDataUsage);
        return responseMessage;
    }

    private void storeClientLanguage(String language, HttpSession httpSession) {
        httpSession.setAttribute(CLIENT_LANGUAGE_SESSION_ATTRIBUTE, (Object)language);
    }

    public static String getClientLanguage(HttpSession httpSession) {
        String clientLanguage = (String)httpSession.getAttribute(CLIENT_LANGUAGE_SESSION_ATTRIBUTE);
        return clientLanguage;
    }

    @Override
    public void init(ServletConfig config) throws ServletException {
        String channelBindingService;
        String channelBindingServerCertificate;
        String inetAddress;
        String hostname = config.getInitParameter(HOSTNAME_INIT_PARAM_NAME);
        if (null != hostname) {
            this.includeHostname = true;
        }
        if (null != (inetAddress = config.getInitParameter(INET_ADDRESS_INIT_PARAM_NAME))) {
            this.includeInetAddress = true;
        }
        if (null != (channelBindingServerCertificate = config.getInitParameter(CHANNEL_BINDING_SERVER_CERTIFICATE))) {
            this.serverCertificateChannelBinding = true;
        }
        if (null != (channelBindingService = config.getInitParameter(CHANNEL_BINDING_SERVICE))) {
            this.serverCertificateChannelBinding = true;
        }
    }
}

