/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.service.impl.handler;

import be.fedict.eid.applet.service.impl.AuthenticationChallenge;
import be.fedict.eid.applet.service.impl.RequestContext;
import be.fedict.eid.applet.service.impl.ServiceLocator;
import be.fedict.eid.applet.service.impl.handler.HandlesMessage;
import be.fedict.eid.applet.service.impl.handler.HelloMessageHandler;
import be.fedict.eid.applet.service.impl.handler.InitParam;
import be.fedict.eid.applet.service.impl.handler.MessageHandler;
import be.fedict.eid.applet.service.impl.handler.SignatureDataMessageHandler;
import be.fedict.eid.applet.service.spi.AuthenticationService;
import be.fedict.eid.applet.service.spi.AuthorizationException;
import be.fedict.eid.applet.service.spi.DigestInfo;
import be.fedict.eid.applet.service.spi.IdentityIntegrityService;
import be.fedict.eid.applet.service.spi.IdentityRequest;
import be.fedict.eid.applet.service.spi.IdentityService;
import be.fedict.eid.applet.service.spi.PrivacyService;
import be.fedict.eid.applet.service.spi.SecureCardReaderService;
import be.fedict.eid.applet.service.spi.SignatureService;
import be.fedict.eid.applet.shared.AdministrationMessage;
import be.fedict.eid.applet.shared.AuthenticationRequestMessage;
import be.fedict.eid.applet.shared.ContinueInsecureMessage;
import be.fedict.eid.applet.shared.ErrorCode;
import be.fedict.eid.applet.shared.FilesDigestRequestMessage;
import be.fedict.eid.applet.shared.FinishedMessage;
import be.fedict.eid.applet.shared.IdentificationRequestMessage;
import be.fedict.eid.applet.shared.SignRequestMessage;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@HandlesMessage(value=ContinueInsecureMessage.class)
public class ContinueInsecureMessageHandler
implements MessageHandler<ContinueInsecureMessage> {
    private static final Log LOG = LogFactory.getLog(ContinueInsecureMessageHandler.class);
    @InitParam(value="IncludePhoto")
    private boolean includePhoto;
    @InitParam(value="IncludeAddress")
    private boolean includeAddress;
    @InitParam(value="IncludeIdentity")
    private boolean includeIdentity;
    private boolean includeInetAddress;
    @InitParam(value="IdentityIntegrityService")
    private ServiceLocator<IdentityIntegrityService> identityIntegrityServiceLocator;
    @InitParam(value="AuthenticationService")
    private ServiceLocator<AuthenticationService> authenticationServiceLocator;
    @InitParam(value="PrivacyService")
    private ServiceLocator<PrivacyService> privacyServiceLocator;
    private SecureRandom secureRandom;
    @InitParam(value="RemoveCard")
    private boolean removeCard;
    @InitParam(value="ChangePin")
    private boolean changePin;
    @InitParam(value="UnblockPin")
    private boolean unblockPin;
    private boolean includeHostname;
    @InitParam(value="Logoff")
    private boolean logoff;
    @InitParam(value="PreLogoff")
    private boolean preLogoff;
    @InitParam(value="IncludeCertificates")
    private boolean includeCertificates;
    @InitParam(value="SessionIdChannelBinding")
    private boolean sessionIdChannelBinding;
    private boolean serverCertificateChannelBinding;
    @InitParam(value="RequireSecureReader")
    private boolean requireSecureReader;
    @InitParam(value="SignatureService")
    private ServiceLocator<SignatureService> signatureServiceLocator;
    @InitParam(value="IdentityService")
    private ServiceLocator<IdentityService> identityServiceLocator;
    @InitParam(value="SecureCardReaderService")
    private ServiceLocator<SecureCardReaderService> secureCardReaderServiceLocator;

    @Override
    public Object handleMessage(ContinueInsecureMessage message, Map<String, String> httpHeaders, HttpServletRequest request, HttpSession session) throws ServletException {
        boolean removeCard;
        boolean includeCertificates;
        boolean includePhoto;
        boolean includeAddress;
        String identityDataUsage;
        if (this.changePin || this.unblockPin) {
            AdministrationMessage administrationMessage = new AdministrationMessage(this.changePin, this.unblockPin, this.logoff, this.removeCard, this.requireSecureReader);
            return administrationMessage;
        }
        SignatureService signatureService = this.signatureServiceLocator.locateService();
        if (null != signatureService) {
            boolean removeCard2;
            DigestInfo digestInfo;
            String filesDigestAlgo = signatureService.getFilesDigestAlgorithm();
            if (null != filesDigestAlgo) {
                LOG.debug((Object)("files digest algo: " + filesDigestAlgo));
                FilesDigestRequestMessage filesDigestRequestMessage = new FilesDigestRequestMessage();
                filesDigestRequestMessage.digestAlgo = filesDigestAlgo;
                return filesDigestRequestMessage;
            }
            try {
                digestInfo = signatureService.preSign(null, null, null, null, null);
            }
            catch (NoSuchAlgorithmException e) {
                throw new ServletException("no such algo: " + e.getMessage(), (Throwable)e);
            }
            catch (AuthorizationException e) {
                return new FinishedMessage(ErrorCode.AUTHORIZATION);
            }
            SignatureDataMessageHandler.setDigestValue(digestInfo.digestValue, digestInfo.digestAlgo, session);
            IdentityService identityService = this.identityServiceLocator.locateService();
            if (null != identityService) {
                IdentityRequest identityRequest = identityService.getIdentityRequest();
                removeCard2 = identityRequest.removeCard();
            } else {
                removeCard2 = this.removeCard;
            }
            SignRequestMessage signRequestMessage = new SignRequestMessage(digestInfo.digestValue, digestInfo.digestAlgo, digestInfo.description, this.logoff, removeCard2, this.requireSecureReader);
            return signRequestMessage;
        }
        AuthenticationService authenticationService = this.authenticationServiceLocator.locateService();
        if (null != authenticationService) {
            boolean removeCard3;
            boolean includeCertificates2;
            boolean includePhoto2;
            boolean includeAddress2;
            boolean includeIdentity;
            byte[] challenge = AuthenticationChallenge.generateChallenge(session);
            IdentityIntegrityService identityIntegrityService = this.identityIntegrityServiceLocator.locateService();
            boolean includeIntegrityData = null != identityIntegrityService;
            IdentityService identityService = this.identityServiceLocator.locateService();
            if (null != identityService) {
                IdentityRequest identityRequest = identityService.getIdentityRequest();
                includeIdentity = identityRequest.includeIdentity();
                includeAddress2 = identityRequest.includeAddress();
                includePhoto2 = identityRequest.includePhoto();
                includeCertificates2 = identityRequest.includeCertificates();
                removeCard3 = identityRequest.removeCard();
            } else {
                includeIdentity = this.includeIdentity;
                includeAddress2 = this.includeAddress;
                includePhoto2 = this.includePhoto;
                includeCertificates2 = this.includeCertificates;
                removeCard3 = this.removeCard;
            }
            RequestContext requestContext = new RequestContext(session);
            requestContext.setIncludeIdentity(includeIdentity);
            requestContext.setIncludeAddress(includeAddress2);
            requestContext.setIncludePhoto(includePhoto2);
            requestContext.setIncludeCertificates(includeCertificates2);
            String transactionMessage = null;
            SecureCardReaderService secureCardReaderService = this.secureCardReaderServiceLocator.locateService();
            if (null != secureCardReaderService) {
                transactionMessage = secureCardReaderService.getTransactionMessage();
                if (null != transactionMessage && transactionMessage.length() > 64) {
                    transactionMessage = transactionMessage.substring(0, 64);
                }
                LOG.debug((Object)("transaction message: " + transactionMessage));
            }
            requestContext.setTransactionMessage(transactionMessage);
            AuthenticationRequestMessage authenticationRequestMessage = new AuthenticationRequestMessage(challenge, this.includeHostname, this.includeInetAddress, this.logoff, this.preLogoff, removeCard3, this.sessionIdChannelBinding, this.serverCertificateChannelBinding, includeIdentity, includeCertificates2, includeAddress2, includePhoto2, includeIntegrityData, this.requireSecureReader, transactionMessage);
            return authenticationRequestMessage;
        }
        IdentityIntegrityService identityIntegrityService = this.identityIntegrityServiceLocator.locateService();
        boolean includeIntegrityData = null != identityIntegrityService;
        PrivacyService privacyService = this.privacyServiceLocator.locateService();
        if (null != privacyService) {
            String clientLanguage = HelloMessageHandler.getClientLanguage(session);
            identityDataUsage = privacyService.getIdentityDataUsage(clientLanguage);
        } else {
            identityDataUsage = null;
        }
        IdentityService identityService = this.identityServiceLocator.locateService();
        if (null != identityService) {
            IdentityRequest identityRequest = identityService.getIdentityRequest();
            includeAddress = identityRequest.includeAddress();
            includePhoto = identityRequest.includePhoto();
            includeCertificates = identityRequest.includeCertificates();
            removeCard = identityRequest.removeCard();
        } else {
            includeAddress = this.includeAddress;
            includePhoto = this.includePhoto;
            includeCertificates = this.includeCertificates;
            removeCard = this.removeCard;
        }
        RequestContext requestContext = new RequestContext(session);
        requestContext.setIncludeAddress(includeAddress);
        requestContext.setIncludePhoto(includePhoto);
        requestContext.setIncludeCertificates(includeCertificates);
        IdentificationRequestMessage responseMessage = new IdentificationRequestMessage(includeAddress, includePhoto, includeIntegrityData, includeCertificates, removeCard, identityDataUsage);
        return responseMessage;
    }

    @Override
    public void init(ServletConfig config) throws ServletException {
        String channelBindingService;
        String channelBindingServerCertificate;
        String inetAddress;
        this.secureRandom = new SecureRandom();
        this.secureRandom.setSeed(System.currentTimeMillis());
        String hostname = config.getInitParameter("Hostname");
        if (null != hostname) {
            this.includeHostname = true;
        }
        if (null != (inetAddress = config.getInitParameter("InetAddress"))) {
            this.includeInetAddress = true;
        }
        if (null != (channelBindingServerCertificate = config.getInitParameter("ChannelBindingServerCertificate"))) {
            this.serverCertificateChannelBinding = true;
        }
        if (null != (channelBindingService = config.getInitParameter("ChannelBindingService"))) {
            this.serverCertificateChannelBinding = true;
        }
    }
}

