/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.service.impl.handler;

import be.fedict.eid.applet.service.impl.AuthenticationSignatureContextImpl;
import be.fedict.eid.applet.service.impl.ServiceLocator;
import be.fedict.eid.applet.service.impl.handler.HandlesMessage;
import be.fedict.eid.applet.service.impl.handler.InitParam;
import be.fedict.eid.applet.service.impl.handler.MessageHandler;
import be.fedict.eid.applet.service.spi.AuthenticationSignatureContext;
import be.fedict.eid.applet.service.spi.AuthenticationSignatureService;
import be.fedict.eid.applet.shared.AuthSignResponseMessage;
import be.fedict.eid.applet.shared.FinishedMessage;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@HandlesMessage(value=AuthSignResponseMessage.class)
public class AuthSignResponseMessageHandler
implements MessageHandler<AuthSignResponseMessage> {
    private static final Log LOG = LogFactory.getLog(AuthSignResponseMessageHandler.class);
    @InitParam(value="AuthenticationSignatureService")
    private ServiceLocator<AuthenticationSignatureService> authenticationSignatureServiceLocator;

    @Override
    public Object handleMessage(AuthSignResponseMessage message, Map<String, String> httpHeaders, HttpServletRequest request, HttpSession session) throws ServletException {
        LOG.debug((Object)"handleMessage");
        byte[] signatureValue = message.signatureValue;
        AuthenticationSignatureService authenticationSignatureService = this.authenticationSignatureServiceLocator.locateService();
        AuthenticationSignatureContextImpl authenticationSignatureContext = new AuthenticationSignatureContextImpl(session);
        authenticationSignatureService.postSign(signatureValue, null, (AuthenticationSignatureContext)authenticationSignatureContext);
        FinishedMessage finishedMessage = new FinishedMessage();
        return finishedMessage;
    }

    @Override
    public void init(ServletConfig config) throws ServletException {
        LOG.debug((Object)"init");
    }
}

