/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.service.impl;

import be.fedict.eid.applet.service.Address;
import be.fedict.eid.applet.service.EIdData;
import be.fedict.eid.applet.service.Identity;
import be.fedict.eid.applet.service.util.KmlLight;
import be.fedict.eid.applet.service.util.KmlLightDocument;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class KmlGenerator {
    private static final Log LOG = LogFactory.getLog(KmlGenerator.class);

    public byte[] generateKml(EIdData eIdData) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        KmlLight kml = new KmlLight(baos);
        KmlLightDocument doc = new KmlLightDocument();
        String htmlDescription = "";
        if (null != eIdData && null != eIdData.getIdentity()) {
            Identity identity = eIdData.getIdentity();
            if (null != eIdData.getPhoto()) {
                byte[] photoData = eIdData.getPhoto();
                kml.addImage(photoData);
                htmlDescription = htmlDescription + "<img src='photo.jpg' align='left'>";
            } else {
                LOG.debug((Object)"no photo");
            }
            Element elName = doc.createName(identity.firstName + " " + identity.name);
            htmlDescription = htmlDescription + identity.firstName + " ";
            if (null != identity.middleName) {
                htmlDescription = htmlDescription + identity.middleName + " ";
            }
            htmlDescription = htmlDescription + identity.name;
            htmlDescription = htmlDescription + "<br/>";
            htmlDescription = htmlDescription + identity.nationality;
            htmlDescription = htmlDescription + "<br/>";
            SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
            String birthday = formatter.format(identity.dateOfBirth.getTime());
            htmlDescription = htmlDescription + "(\u00b0" + birthday + ", " + identity.placeOfBirth + ")";
            htmlDescription = htmlDescription + "<br/>";
            Element elValid = null;
            if (null != identity.cardValidityDateBegin) {
                elValid = doc.createTimespan(identity.cardValidityDateBegin.getTime(), identity.cardValidityDateEnd.getTime());
            } else {
                LOG.debug((Object)"card validity begin date is unknown");
            }
            Element elAddress = null;
            if (null != eIdData.getAddress()) {
                Address address = eIdData.getAddress();
                elAddress = doc.createAddress(address.streetAndNumber, address.municipality, address.zip);
            } else {
                LOG.debug((Object)"no address");
            }
            Element elDescription = doc.createDescriptionNode(htmlDescription);
            doc.addPlacemark(elName, elAddress, elDescription, elValid);
        }
        kml.addKmlFile(doc.getDocumentAsBytes());
        kml.close();
        return baos.toByteArray();
    }
}

