/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.service.impl;

import java.io.Serializable;
import java.security.SecureRandom;
import java.util.Date;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuthenticationChallenge
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog(AuthenticationChallenge.class);
    public static final String AUTHN_CHALLENGE_SESSION_ATTRIBUTE = AuthenticationChallenge.class.getName();
    public static final long DEFAULT_MAX_MATURITY = 300000L;
    private final byte[] challenge = new byte[20];
    private final Date timestamp;
    private static final SecureRandom secureRandom = new SecureRandom();

    private AuthenticationChallenge() {
        secureRandom.nextBytes(this.challenge);
        secureRandom.setSeed(System.currentTimeMillis());
        this.timestamp = new Date();
    }

    public static byte[] generateChallenge(HttpSession session) {
        AuthenticationChallenge authenticationChallenge = new AuthenticationChallenge();
        if (null != session.getAttribute(AUTHN_CHALLENGE_SESSION_ATTRIBUTE)) {
            LOG.warn((Object)"overwriting a previous authentication challenge");
        }
        session.setAttribute(AUTHN_CHALLENGE_SESSION_ATTRIBUTE, (Object)authenticationChallenge);
        byte[] challenge = authenticationChallenge.getChallenge();
        return challenge;
    }

    private byte[] getChallenge() {
        return this.challenge;
    }

    private Date getTimestamp() {
        return this.timestamp;
    }

    public static byte[] getAuthnChallenge(HttpSession session, Long maxMaturity) {
        long dt;
        AuthenticationChallenge authenticationChallenge = (AuthenticationChallenge)session.getAttribute(AUTHN_CHALLENGE_SESSION_ATTRIBUTE);
        if (null == authenticationChallenge) {
            throw new SecurityException("no challenge in session");
        }
        session.removeAttribute(AUTHN_CHALLENGE_SESSION_ATTRIBUTE);
        Date now = new Date();
        if (null == maxMaturity) {
            maxMaturity = 300000L;
        }
        if ((dt = now.getTime() - authenticationChallenge.getTimestamp().getTime()) > maxMaturity) {
            throw new SecurityException("maximum challenge maturity reached");
        }
        byte[] challenge = authenticationChallenge.getChallenge();
        return challenge;
    }

    public static byte[] getAuthnChallenge(HttpSession session) {
        return AuthenticationChallenge.getAuthnChallenge(session, null);
    }

    static {
        secureRandom.setSeed(System.currentTimeMillis());
    }
}

