/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.service.dto;

import be.fedict.eid.applet.service.dto.IdenticalValueConvertor;
import be.fedict.eid.applet.service.dto.Mapping;
import be.fedict.eid.applet.service.dto.MapsTo;
import be.fedict.eid.applet.service.dto.ValueConvertor;
import be.fedict.eid.applet.service.dto.ValueConvertorException;
import java.lang.reflect.Field;

public class DTOMapper {
    public <T> T map(Object from, Class<T> toClass) {
        Field[] fromFields;
        T to;
        if (null == from) {
            return null;
        }
        try {
            to = toClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("could not create new instance of " + toClass.getName());
        }
        Class<?> fromClass = from.getClass();
        for (Field fromField : fromFields = fromClass.getDeclaredFields()) {
            MapsTo[] mapsToAnnotations;
            Mapping mappingAnnotation = fromField.getAnnotation(Mapping.class);
            if (null == mappingAnnotation) continue;
            for (MapsTo mapsToAnnotation : mapsToAnnotations = mappingAnnotation.value()) {
                Object value;
                Field toField;
                if (!toClass.equals(mapsToAnnotation.value())) continue;
                String toFieldName = mapsToAnnotation.field();
                if (toFieldName.isEmpty()) {
                    toFieldName = fromField.getName();
                }
                try {
                    toField = toClass.getDeclaredField(toFieldName);
                }
                catch (Exception e) {
                    throw new RuntimeException("no such target field: " + toFieldName);
                }
                try {
                    value = fromField.get(from);
                }
                catch (Exception e) {
                    throw new RuntimeException("could not read field: " + fromField.getName());
                }
                Class<ValueConvertor<?, ?>> valueConvertorClass = mapsToAnnotation.convertor();
                if (!IdenticalValueConvertor.class.equals(valueConvertorClass)) {
                    ValueConvertor<?, ?> valueConvertor;
                    try {
                        valueConvertor = valueConvertorClass.newInstance();
                    }
                    catch (Exception e) {
                        throw new RuntimeException("could not instantiate value convertor: " + valueConvertorClass.getName());
                    }
                    try {
                        value = valueConvertor.convert(value);
                    }
                    catch (ValueConvertorException e) {
                        throw new RuntimeException("could not convert value of field: " + fromField.getName());
                    }
                }
                try {
                    toField.set(to, value);
                }
                catch (Exception e) {
                    throw new RuntimeException("could not write field " + toFieldName + ": " + e.getMessage(), e);
                }
            }
        }
        return to;
    }
}

