/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.service;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public enum SpecialStatus implements Serializable
{
    NO_STATUS("0", false, false, false),
    WHITE_CANE("1", true, false, false),
    EXTENDED_MINORITY("2", false, true, false),
    WHITE_CANE_EXTENDED_MINORITY("3", true, true, false),
    YELLOW_CANE("4", false, false, true),
    YELLOW_CANE_EXTENDED_MINORITY("5", false, true, true);

    private final String strValue;
    private final boolean whiteCane;
    private final boolean extendedMinority;
    private final boolean yellowCane;
    private static Map<String, SpecialStatus> map;

    private SpecialStatus(String strValue, boolean whiteCane, boolean extendedMinority, boolean yellowCane) {
        this.strValue = strValue;
        this.whiteCane = whiteCane;
        this.extendedMinority = extendedMinority;
        this.yellowCane = yellowCane;
    }

    public boolean hasWhiteCane() {
        return this.whiteCane;
    }

    public boolean hasExtendedMinority() {
        return this.extendedMinority;
    }

    public boolean hasYellowCane() {
        return this.yellowCane;
    }

    public boolean hasBadSight() {
        return this.whiteCane || this.yellowCane;
    }

    public static SpecialStatus toSpecialStatus(String value) {
        return map.get(value);
    }

    static {
        HashMap<String, SpecialStatus> map = new HashMap<String, SpecialStatus>();
        for (SpecialStatus specialStatus : SpecialStatus.values()) {
            String value = specialStatus.strValue;
            if (map.containsKey(value)) {
                throw new RuntimeException("duplicate special status: " + value);
            }
            map.put(value, specialStatus);
        }
        SpecialStatus.map = map;
    }
}

