/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.service;

import be.fedict.eid.applet.service.impl.ServiceLocator;
import be.fedict.eid.applet.service.spi.StrictTransportSecurityConfig;
import be.fedict.eid.applet.service.spi.TransportService;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HSTSFilter
implements Filter {
    private static final Log LOG = LogFactory.getLog(HSTSFilter.class);
    public static final String TRANSPORT_SERVICE_INIT_PARAM = "TransportService";
    private ServiceLocator<TransportService> transportServiceLocator;

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        TransportService transportService = this.transportServiceLocator.locateService();
        if (null == transportService) {
            chain.doFilter(request, response);
            return;
        }
        StrictTransportSecurityConfig hstsConfig = transportService.getStrictTransportSecurityConfig();
        if (null == hstsConfig) {
            chain.doFilter(request, response);
            return;
        }
        LOG.debug((Object)"adding HSTS header");
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        String headerValue = "max-age=" + hstsConfig.getMaxAge();
        if (hstsConfig.isIncludeSubdomains()) {
            headerValue = headerValue + "; includeSubdomains";
        }
        httpServletResponse.addHeader("Strict-Transport-Security", headerValue);
        chain.doFilter(request, response);
    }

    public void init(FilterConfig config) throws ServletException {
        this.transportServiceLocator = new ServiceLocator(TRANSPORT_SERVICE_INIT_PARAM, config);
    }
}

