/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.service;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public enum DocumentType implements Serializable
{
    BELGIAN_CITIZEN("1"),
    KIDS_CARD("6"),
    BOOTSTRAP_CARD("7"),
    HABILITATION_CARD("8"),
    FOREIGNER_A("11"),
    FOREIGNER_B("12"),
    FOREIGNER_C("13"),
    FOREIGNER_D("14"),
    FOREIGNER_E("15"),
    FOREIGNER_E_PLUS("16"),
    FOREIGNER_F("17"),
    FOREIGNER_F_PLUS("18"),
    EUROPEAN_BLUE_CARD_H("19");

    private final int key;
    private static Map<Integer, DocumentType> documentTypes;

    private DocumentType(String value) {
        this.key = this.toKey(value);
    }

    private int toKey(String value) {
        char c1 = value.charAt(0);
        int key = c1 - 48;
        if (2 == value.length()) {
            key *= 10;
            char c2 = value.charAt(1);
            key += c2 - 48;
        }
        return key;
    }

    private static int toKey(byte[] value) {
        int key = value[0] - 48;
        if (2 == value.length) {
            key *= 10;
            key += value[1] - 48;
        }
        return key;
    }

    public int getKey() {
        return this.key;
    }

    public static DocumentType toDocumentType(byte[] value) {
        int key = DocumentType.toKey(value);
        DocumentType documentType = documentTypes.get(key);
        return documentType;
    }

    public static String toString(byte[] documentTypeValue) {
        String str = Integer.toString(DocumentType.toKey(documentTypeValue));
        return str;
    }

    static {
        HashMap<Integer, DocumentType> documentTypes = new HashMap<Integer, DocumentType>();
        for (DocumentType documentType : DocumentType.values()) {
            int encodedValue = documentType.key;
            if (documentTypes.containsKey(encodedValue)) {
                throw new RuntimeException("duplicate document type enum: " + encodedValue);
            }
            documentTypes.put(encodedValue, documentType);
        }
        DocumentType.documentTypes = documentTypes;
    }
}

