/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.service;

import be.fedict.eid.applet.service.AbstractAppletServiceServlet;
import be.fedict.eid.applet.service.impl.ServiceLocator;
import be.fedict.eid.applet.service.impl.handler.AuthSignResponseMessageHandler;
import be.fedict.eid.applet.service.impl.handler.AuthenticationDataMessageHandler;
import be.fedict.eid.applet.service.impl.handler.ClientEnvironmentMessageHandler;
import be.fedict.eid.applet.service.impl.handler.ContinueInsecureMessageHandler;
import be.fedict.eid.applet.service.impl.handler.FileDigestsDataMessageHandler;
import be.fedict.eid.applet.service.impl.handler.HandlesMessage;
import be.fedict.eid.applet.service.impl.handler.HelloMessageHandler;
import be.fedict.eid.applet.service.impl.handler.IdentityDataMessageHandler;
import be.fedict.eid.applet.service.impl.handler.InitParam;
import be.fedict.eid.applet.service.impl.handler.MessageHandler;
import be.fedict.eid.applet.service.impl.handler.SignCertificatesDataMessageHandler;
import be.fedict.eid.applet.service.impl.handler.SignatureDataMessageHandler;
import be.fedict.eid.applet.shared.AbstractProtocolMessage;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AppletServiceServlet
extends AbstractAppletServiceServlet {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog(AppletServiceServlet.class);
    private static final Class<? extends MessageHandler<?>>[] MESSAGE_HANDLER_CLASSES = new Class[]{IdentityDataMessageHandler.class, HelloMessageHandler.class, ClientEnvironmentMessageHandler.class, AuthenticationDataMessageHandler.class, SignatureDataMessageHandler.class, FileDigestsDataMessageHandler.class, ContinueInsecureMessageHandler.class, SignCertificatesDataMessageHandler.class, AuthSignResponseMessageHandler.class};
    private Map<Class<?>, MessageHandler<?>> messageHandlers;

    public AppletServiceServlet() {
        LOG.debug((Object)"constructor");
    }

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        LOG.debug((Object)"init");
        this.messageHandlers = new HashMap();
        for (Class<MessageHandler<?>> clazz : MESSAGE_HANDLER_CLASSES) {
            MessageHandler<?> messageHandler;
            HandlesMessage handlesMessageAnnotation = clazz.getAnnotation(HandlesMessage.class);
            if (null == handlesMessageAnnotation) {
                throw new ServletException("missing meta-data on message handler: " + clazz.getName());
            }
            Class<? extends AbstractProtocolMessage> protocolMessageClass = handlesMessageAnnotation.value();
            try {
                messageHandler = clazz.newInstance();
            }
            catch (Exception e) {
                throw new ServletException("cannot create message handler instance");
            }
            this.messageHandlers.put(protocolMessageClass, messageHandler);
        }
        Collection<MessageHandler<?>> messageHandlers = this.messageHandlers.values();
        for (MessageHandler<?> messageHandler : messageHandlers) {
            try {
                AppletServiceServlet.injectInitParams(config, messageHandler);
            }
            catch (Exception exception) {
                throw new ServletException("error injecting init-param into message handler field: " + exception.getMessage(), (Throwable)exception);
            }
            messageHandler.init(config);
        }
    }

    public static void injectInitParams(ServletConfig config, MessageHandler<?> messageHandler) throws ServletException, IllegalArgumentException, IllegalAccessException {
        Field[] fields;
        Class<?> messageHandlerClass = messageHandler.getClass();
        for (Field field : fields = messageHandlerClass.getDeclaredFields()) {
            Comparable<Boolean> fieldValue;
            InitParam initParamAnnotation = field.getAnnotation(InitParam.class);
            if (null == initParamAnnotation) continue;
            String initParamName = initParamAnnotation.value();
            Class<?> fieldType = field.getType();
            field.setAccessible(true);
            if (ServiceLocator.class.equals(fieldType)) {
                ServiceLocator fieldValue2 = new ServiceLocator(initParamName, config);
                field.set(messageHandler, fieldValue2);
                continue;
            }
            String initParamValue = config.getInitParameter(initParamName);
            if (initParamAnnotation.required() && null == initParamValue) {
                throw new ServletException("missing required init-param: " + initParamName + " for message handler:" + messageHandlerClass.getName());
            }
            if (null == initParamValue) continue;
            if (Boolean.TYPE.equals(fieldType)) {
                LOG.debug((Object)("injecting boolean: " + initParamValue));
                fieldValue = Boolean.parseBoolean(initParamValue);
                field.set(messageHandler, fieldValue);
                continue;
            }
            if (String.class.equals(fieldType)) {
                field.set(messageHandler, initParamValue);
                continue;
            }
            if (InetAddress.class.equals(fieldType)) {
                InetAddress inetAddress;
                try {
                    inetAddress = InetAddress.getByName(initParamValue);
                }
                catch (UnknownHostException e) {
                    throw new ServletException("unknown host: " + initParamValue);
                }
                field.set(messageHandler, inetAddress);
                continue;
            }
            if (Long.class.equals(fieldType)) {
                fieldValue = Long.parseLong(initParamValue);
                field.set(messageHandler, fieldValue);
                continue;
            }
            throw new ServletException("unsupported init-param field type: " + fieldType.getName());
        }
    }

    @Override
    protected <T> MessageHandler<T> getMessageHandler(Class<T> messageClass) {
        return this.messageHandlers.get(messageClass);
    }
}

