/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.service;

import be.fedict.eid.applet.service.impl.CleanSessionProtocolStateListener;
import be.fedict.eid.applet.service.impl.HttpServletProtocolContext;
import be.fedict.eid.applet.service.impl.HttpServletRequestHttpReceiver;
import be.fedict.eid.applet.service.impl.HttpServletResponseHttpTransmitter;
import be.fedict.eid.applet.service.impl.RequestContext;
import be.fedict.eid.applet.service.impl.handler.MessageHandler;
import be.fedict.eid.applet.shared.AppletProtocolMessageCatalog;
import be.fedict.eid.applet.shared.annotation.ResponsesAllowed;
import be.fedict.eid.applet.shared.protocol.HttpReceiver;
import be.fedict.eid.applet.shared.protocol.HttpTransmitter;
import be.fedict.eid.applet.shared.protocol.ProtocolContext;
import be.fedict.eid.applet.shared.protocol.ProtocolMessageCatalog;
import be.fedict.eid.applet.shared.protocol.ProtocolStateListener;
import be.fedict.eid.applet.shared.protocol.ProtocolStateMachine;
import be.fedict.eid.applet.shared.protocol.Transport;
import be.fedict.eid.applet.shared.protocol.Unmarshaller;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractAppletServiceServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog(AbstractAppletServiceServlet.class);
    private Unmarshaller unmarshaller;
    private static final String SKIP_SECURE_CONNECTION_CHECK_INIT_PARAM = "SkipSecureConnectionCheck";
    private boolean skipSecureConnectionCheck;

    public AbstractAppletServiceServlet() {
        LOG.debug((Object)"constructor");
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        LOG.debug((Object)"init");
        this.unmarshaller = new Unmarshaller((ProtocolMessageCatalog)new AppletProtocolMessageCatalog());
        String skipSecureConnectionCheck = config.getInitParameter(SKIP_SECURE_CONNECTION_CHECK_INIT_PARAM);
        if (null != skipSecureConnectionCheck) {
            this.skipSecureConnectionCheck = Boolean.parseBoolean(skipSecureConnectionCheck);
            LOG.debug((Object)("skipping secure connection check: " + this.skipSecureConnectionCheck));
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOG.debug((Object)"doGet");
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        out.println("<html>");
        out.println("<head><title>eID Applet Service</title></head>");
        out.println("<body>");
        out.println("<h1>eID Applet Service</h1>");
        out.println("<p>The eID Applet Service should not be accessed directly.</p>");
        out.println("</body></html>");
        out.close();
    }

    protected abstract <T> MessageHandler<T> getMessageHandler(Class<T> var1);

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Object transferObject;
        LOG.debug((Object)"doPost");
        HashMap<String, String> httpHeaders = new HashMap<String, String>();
        Enumeration headerNamesEnum = request.getHeaderNames();
        while (headerNamesEnum.hasMoreElements()) {
            String headerName = (String)headerNamesEnum.nextElement();
            httpHeaders.put(headerName, request.getHeader(headerName));
        }
        HttpServletRequestHttpReceiver httpReceiver = new HttpServletRequestHttpReceiver(request, this.skipSecureConnectionCheck);
        try {
            transferObject = this.unmarshaller.receive((HttpReceiver)httpReceiver);
        }
        catch (Exception e) {
            LOG.debug((Object)("unmarshaller error: " + e.getMessage()), (Throwable)e);
            throw new RuntimeException("unmarshaller error: " + e.getMessage(), e);
        }
        HttpServletProtocolContext protocolContext = new HttpServletProtocolContext(request);
        ProtocolStateMachine protocolStateMachine = new ProtocolStateMachine((ProtocolContext)protocolContext);
        CleanSessionProtocolStateListener cleanSessionProtocolStateListener = new CleanSessionProtocolStateListener(request);
        protocolStateMachine.addProtocolStateListener((ProtocolStateListener)cleanSessionProtocolStateListener);
        RequestContext requestContext = new RequestContext(request);
        protocolStateMachine.addProtocolStateListener((ProtocolStateListener)requestContext);
        protocolStateMachine.checkRequestMessage(transferObject);
        Class<?> messageClass = transferObject.getClass();
        MessageHandler<?> messageHandler = this.getMessageHandler(messageClass);
        if (null == messageHandler) {
            throw new ServletException("unsupported message");
        }
        HttpSession session = request.getSession();
        Object responseMessage = messageHandler.handleMessage(transferObject, httpHeaders, request, session);
        ResponsesAllowed responsesAllowedAnnotation = messageClass.getAnnotation(ResponsesAllowed.class);
        if (null != responsesAllowedAnnotation) {
            if (null == responseMessage) {
                throw new ServletException("null response message while @ResponsesAllowed constraint was set");
            }
            Class[] responsesAllowed = responsesAllowedAnnotation.value();
            if (!this.isOfClass(responseMessage, responsesAllowed)) {
                throw new ServletException("response message type incorrect");
            }
        }
        protocolStateMachine.checkResponseMessage(responseMessage);
        if (null != responseMessage) {
            HttpServletResponseHttpTransmitter httpTransmitter = new HttpServletResponseHttpTransmitter(response);
            Transport.transfer((Object)responseMessage, (HttpTransmitter)httpTransmitter);
        }
    }

    private boolean isOfClass(Object object, Class<?>[] classes) {
        for (Class<?> clazz : classes) {
            if (!clazz.equals(object.getClass())) continue;
            return true;
        }
        return false;
    }
}

