/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.service.impl.handler;

import be.fedict.eid.applet.service.impl.ServiceLocator;
import be.fedict.eid.applet.service.impl.handler.HandlesMessage;
import be.fedict.eid.applet.service.impl.handler.InitParam;
import be.fedict.eid.applet.service.impl.handler.MessageHandler;
import be.fedict.eid.applet.service.impl.handler.SignatureDataMessageHandler;
import be.fedict.eid.applet.service.spi.DigestInfo;
import be.fedict.eid.applet.service.spi.IdentityRequest;
import be.fedict.eid.applet.service.spi.IdentityService;
import be.fedict.eid.applet.service.spi.SignatureService;
import be.fedict.eid.applet.shared.FileDigestsDataMessage;
import be.fedict.eid.applet.shared.SignRequestMessage;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@HandlesMessage(value=FileDigestsDataMessage.class)
public class FileDigestsDataMessageHandler
implements MessageHandler<FileDigestsDataMessage> {
    @InitParam(value="SignatureService")
    private ServiceLocator<SignatureService> signatureServiceLocator;
    @InitParam(value="RemoveCard")
    private boolean removeCard;
    @InitParam(value="Logoff")
    private boolean logoff;
    @InitParam(value="RequireSecureReader")
    private boolean requireSecureReader;
    @InitParam(value="IdentityService")
    private ServiceLocator<IdentityService> identityServiceLocator;

    @Override
    public Object handleMessage(FileDigestsDataMessage message, Map<String, String> httpHeaders, HttpServletRequest request, HttpSession session) throws ServletException {
        boolean removeCard;
        DigestInfo digestInfo;
        LinkedList<DigestInfo> fileDigestInfos = new LinkedList<DigestInfo>();
        List messageFileDigestInfos = message.fileDigestInfos;
        Iterator messageIterator = messageFileDigestInfos.iterator();
        while (messageIterator.hasNext()) {
            byte[] digestValue;
            String digestAlgo = (String)messageIterator.next();
            String hexDigestValue = (String)messageIterator.next();
            String description = (String)messageIterator.next();
            try {
                digestValue = Hex.decodeHex((char[])hexDigestValue.toCharArray());
            }
            catch (DecoderException e) {
                throw new ServletException("digest value decode error: " + e.getMessage(), (Throwable)e);
            }
            fileDigestInfos.add(new DigestInfo(digestValue, digestAlgo, description));
        }
        SignatureService signatureService = this.signatureServiceLocator.locateService();
        try {
            digestInfo = signatureService.preSign(fileDigestInfos, null);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ServletException("no such algo: " + e.getMessage(), (Throwable)e);
        }
        SignatureDataMessageHandler.setDigestValue(digestInfo.digestValue, session);
        IdentityService identityService = this.identityServiceLocator.locateService();
        if (null != identityService) {
            IdentityRequest identityRequest = identityService.getIdentityRequest();
            removeCard = identityRequest.removeCard();
        } else {
            removeCard = this.removeCard;
        }
        SignRequestMessage signRequestMessage = new SignRequestMessage(digestInfo.digestValue, digestInfo.digestAlgo, digestInfo.description, this.logoff, removeCard, this.requireSecureReader);
        return signRequestMessage;
    }

    @Override
    public void init(ServletConfig config) throws ServletException {
    }
}

