/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.service.signer.ooxml;

import be.fedict.eid.applet.service.signer.DigestAlgo;
import be.fedict.eid.applet.service.signer.SignatureFacet;
import be.fedict.eid.applet.service.signer.jaxb.opc.contenttypes.CTDefault;
import be.fedict.eid.applet.service.signer.jaxb.opc.contenttypes.CTOverride;
import be.fedict.eid.applet.service.signer.jaxb.opc.contenttypes.CTTypes;
import be.fedict.eid.applet.service.signer.jaxb.opc.contenttypes.ObjectFactory;
import be.fedict.eid.applet.service.signer.jaxb.opc.relationships.CTRelationship;
import be.fedict.eid.applet.service.signer.jaxb.opc.relationships.CTRelationships;
import be.fedict.eid.applet.service.signer.ooxml.AbstractOOXMLSignatureService;
import be.fedict.eid.applet.service.signer.ooxml.RelationshipTransformParameterSpec;
import be.fedict.eid.applet.service.signer.time.Clock;
import be.fedict.eid.applet.service.signer.time.LocalClock;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Manifest;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureProperties;
import javax.xml.crypto.dsig.SignatureProperty;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OOXMLSignatureFacet
implements SignatureFacet {
    private static final Log LOG = LogFactory.getLog(OOXMLSignatureFacet.class);
    public static final String OOXML_DIGSIG_NS = "http://schemas.openxmlformats.org/package/2006/digital-signature";
    public static final String OFFICE_DIGSIG_NS = "http://schemas.microsoft.com/office/2006/digsig";
    private final AbstractOOXMLSignatureService signatureService;
    private final Clock clock;
    private final DigestAlgo digestAlgo;
    public static String[] contentTypes = new String[]{"application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml", "application/vnd.openxmlformats-officedocument.wordprocessingml.fontTable+xml", "application/vnd.openxmlformats-officedocument.wordprocessingml.settings+xml", "application/vnd.openxmlformats-officedocument.wordprocessingml.styles+xml", "application/vnd.openxmlformats-officedocument.theme+xml", "application/vnd.openxmlformats-officedocument.wordprocessingml.webSettings+xml", "application/vnd.openxmlformats-officedocument.wordprocessingml.numbering+xml", "application/vnd.ms-word.stylesWithEffects+xml", "application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml", "application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml", "application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml", "application/vnd.openxmlformats-officedocument.presentationml.presentation.main+xml", "application/vnd.openxmlformats-officedocument.presentationml.slideLayout+xml", "application/vnd.openxmlformats-officedocument.presentationml.slideMaster+xml", "application/vnd.openxmlformats-officedocument.presentationml.slide+xml", "application/vnd.openxmlformats-officedocument.presentationml.tableStyles+xml", "application/vnd.openxmlformats-officedocument.presentationml.viewProps+xml", "application/vnd.openxmlformats-officedocument.presentationml.presProps+xml"};
    public static String[] signed = new String[]{"powerPivotData", "activeXControlBinary", "attachedToolbars", "connectorXml", "downRev", "functionPrototypes", "graphicFrameDoc", "groupShapeXml", "ink", "keyMapCustomizations", "legacyDiagramText", "legacyDocTextInfo", "officeDocument", "pictureXml", "shapeXml", "smartTags", "ui/altText", "ui/buttonSize", "ui/controlID", "ui/description", "ui/enabled", "ui/extensibility", "ui/helperText", "ui/imageID", "ui/imageMso", "ui/keyTip", "ui/label", "ui/lcid", "ui/loud", "ui/pressed", "ui/progID", "ui/ribbonID", "ui/showImage", "ui/showLabel", "ui/supertip", "ui/target", "ui/text", "ui/title", "ui/tooltip", "ui/userCustomization", "ui/visible", "userXmlData", "vbaProject", "wordVbaData", "wsSortMap", "xlBinaryIndex", "xlExternalLinkPath/xlAlternateStartup", "xlExternalLinkPath/xlLibrary", "xlExternalLinkPath/xlPathMissing", "xlExternalLinkPath/xlStartup", "xlIntlMacrosheet", "xlMacrosheet", "customData", "diagramDrawing", "hdphoto", "inkXml", "media", "slicer", "slicerCache", "stylesWithEffects", "ui/extensibility", "chartColorStyle", "chartLayout", "chartStyle", "dictionary", "timeline", "timelineCache", "aFChunk", "attachedTemplate", "audio", "calcChain", "chart", "chartsheet", "chartUserShapes", "commentAuthors", "comments", "connections", "control", "customProperty", "customXml", "diagramColors", "diagramData", "diagramLayout", "diagramQuickStyle", "dialogsheet", "drawing", "endnotes", "externalLink", "externalLinkPath", "font", "fontTable", "footer", "footnotes", "glossaryDocument", "handoutMaster", "header", "hyperlink", "image", "mailMergeHeaderSource", "mailMergeRecipientData", "mailMergeSource", "notesMaster", "notesSlide", "numbering", "officeDocument", "oleObject", "package", "pivotCacheDefinition", "pivotCacheRecords", "pivotTable", "presProps", "printerSettings", "queryTable", "recipientData", "settings", "sharedStrings", "sheetMetadata", "slide", "slideLayout", "slideMaster", "slideUpdateInfo", "slideUpdateUrl", "styles", "table", "tableSingleCells", "tableStyles", "tags", "theme", "themeOverride", "transform", "video", "viewProps", "volatileDependencies", "webSettings", "worksheet", "xmlMaps", "ctrlProp", "customData", "diagram", "diagramColorsHeader", "diagramLayoutHeader", "diagramQuickStyleHeader", "documentParts", "slicer", "slicerCache", "vmlDrawing"};

    public OOXMLSignatureFacet(AbstractOOXMLSignatureService signatureService) {
        this(signatureService, new LocalClock(), DigestAlgo.SHA1);
    }

    public OOXMLSignatureFacet(AbstractOOXMLSignatureService signatureService, Clock clock, DigestAlgo digestAlgo) {
        this.signatureService = signatureService;
        this.clock = clock;
        this.digestAlgo = digestAlgo;
    }

    @Override
    public void preSign(XMLSignatureFactory signatureFactory, Document document, String signatureId, List<X509Certificate> signingCertificateChain, List<Reference> references, List<XMLObject> objects) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        LOG.debug((Object)"pre sign");
        this.addManifestObject(signatureFactory, document, signatureId, references, objects);
        this.addSignatureInfo(signatureFactory, document, signatureId, references, objects);
    }

    private void addManifestObject(XMLSignatureFactory signatureFactory, Document document, String signatureId, List<Reference> references, List<XMLObject> objects) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        Manifest manifest = this.constructManifest(signatureFactory, document);
        String objectId = "idPackageObject";
        LinkedList<XMLStructure> objectContent = new LinkedList<XMLStructure>();
        objectContent.add(manifest);
        this.addSignatureTime(signatureFactory, document, signatureId, objectContent);
        objects.add(signatureFactory.newXMLObject(objectContent, objectId, null, null));
        DigestMethod digestMethod = signatureFactory.newDigestMethod(this.digestAlgo.getXmlAlgoId(), null);
        Reference reference = signatureFactory.newReference("#" + objectId, digestMethod, null, "http://www.w3.org/2000/09/xmldsig#Object", null);
        references.add(reference);
    }

    private Manifest constructManifest(XMLSignatureFactory signatureFactory, Document document) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        LinkedList<Reference> manifestReferences = new LinkedList<Reference>();
        try {
            this.addManifestReferences(signatureFactory, document, manifestReferences);
        }
        catch (Exception e) {
            throw new RuntimeException("error: " + e.getMessage(), e);
        }
        return signatureFactory.newManifest(manifestReferences);
    }

    private void addManifestReferences(XMLSignatureFactory signatureFactory, Document document, List<Reference> manifestReferences) throws IOException, JAXBException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        CTTypes contentTypes = this.getContentTypes();
        List<String> relsEntryNames = this.getRelsEntryNames();
        DigestMethod digestMethod = signatureFactory.newDigestMethod(this.digestAlgo.getXmlAlgoId(), null);
        HashSet<String> digestedPartNames = new HashSet<String>();
        for (String relsEntryName : relsEntryNames) {
            CTRelationships relationships = this.getRelationships(relsEntryName);
            List<CTRelationship> relationshipList = relationships.getRelationship();
            RelationshipTransformParameterSpec parameterSpec = new RelationshipTransformParameterSpec();
            for (CTRelationship relationship : relationshipList) {
                String relationshipType = relationship.getType();
                if (!OOXMLSignatureFacet.isSignedRelationship(relationshipType)) continue;
                String baseUri = "/" + relsEntryName.substring(0, relsEntryName.indexOf("_rels/"));
                String relationshipTarget = relationship.getTarget();
                String partName = FilenameUtils.normalize((String)(baseUri + relationshipTarget));
                LOG.debug((Object)("part name: " + partName));
                String relationshipId = relationship.getId();
                parameterSpec.addRelationshipReference(relationshipId);
                String contentType = this.getContentType(contentTypes, partName);
                if (relationshipType.endsWith("customXml") && !contentType.equals("inkml+xml") && !contentType.equals("text/xml")) {
                    LOG.debug((Object)("skipping customXml with content type: " + contentType));
                    continue;
                }
                if (digestedPartNames.contains(partName)) continue;
                Reference reference = signatureFactory.newReference(partName + "?ContentType=" + contentType, digestMethod);
                manifestReferences.add(reference);
                digestedPartNames.add(partName);
            }
            if (parameterSpec.getSourceIds().isEmpty()) continue;
            LinkedList<Transform> transforms = new LinkedList<Transform>();
            transforms.add(signatureFactory.newTransform("http://schemas.openxmlformats.org/package/2006/RelationshipTransform", parameterSpec));
            transforms.add(signatureFactory.newTransform("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", (TransformParameterSpec)null));
            Reference reference = signatureFactory.newReference("/" + relsEntryName + "?ContentType=application/vnd.openxmlformats-package.relationships+xml", digestMethod, transforms, null, null);
            manifestReferences.add(reference);
        }
    }

    private String getContentType(CTTypes contentTypes, String partName) {
        List<Object> defaultOrOverrideList = contentTypes.getDefaultOrOverride();
        for (Object defaultOrOverride : defaultOrOverrideList) {
            CTOverride override;
            if (!(defaultOrOverride instanceof CTOverride) || !partName.equals((override = (CTOverride)defaultOrOverride).getPartName())) continue;
            return override.getContentType();
        }
        for (Object defaultOrOverride : defaultOrOverrideList) {
            CTDefault ctDefault;
            if (!(defaultOrOverride instanceof CTDefault) || !partName.endsWith((ctDefault = (CTDefault)defaultOrOverride).getExtension())) continue;
            return ctDefault.getContentType();
        }
        return null;
    }

    private CTRelationships getRelationships(String relsEntryName) throws IOException, JAXBException {
        ZipEntry zipEntry;
        URL ooxmlUrl = this.signatureService.getOfficeOpenXMLDocumentURL();
        ZipInputStream zipInputStream = new ZipInputStream(ooxmlUrl.openStream());
        ZipInputStream relationshipsInputStream = null;
        while (null != (zipEntry = zipInputStream.getNextEntry())) {
            if (!relsEntryName.equals(zipEntry.getName())) continue;
            relationshipsInputStream = zipInputStream;
            break;
        }
        if (null == relationshipsInputStream) {
            return null;
        }
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{be.fedict.eid.applet.service.signer.jaxb.opc.relationships.ObjectFactory.class});
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        JAXBElement relationshipsElement = (JAXBElement)unmarshaller.unmarshal((InputStream)relationshipsInputStream);
        return (CTRelationships)relationshipsElement.getValue();
    }

    private CTTypes getContentTypes() throws IOException, JAXBException {
        ZipEntry zipEntry;
        URL ooxmlUrl = this.signatureService.getOfficeOpenXMLDocumentURL();
        ZipInputStream zipInputStream = new ZipInputStream(ooxmlUrl.openStream());
        ZipInputStream contentTypesInputStream = null;
        while (null != (zipEntry = zipInputStream.getNextEntry())) {
            if (!"[Content_Types].xml".equals(zipEntry.getName())) continue;
            contentTypesInputStream = zipInputStream;
            break;
        }
        if (null == contentTypesInputStream) {
            return null;
        }
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        JAXBElement contentTypesElement = (JAXBElement)unmarshaller.unmarshal((InputStream)contentTypesInputStream);
        return (CTTypes)contentTypesElement.getValue();
    }

    private List<String> getRelsEntryNames() throws IOException {
        ZipEntry zipEntry;
        LinkedList<String> relsEntryNames = new LinkedList<String>();
        URL ooxmlUrl = this.signatureService.getOfficeOpenXMLDocumentURL();
        InputStream inputStream = ooxmlUrl.openStream();
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        while (null != (zipEntry = zipInputStream.getNextEntry())) {
            String zipEntryName = zipEntry.getName();
            if (!zipEntryName.endsWith(".rels")) continue;
            relsEntryNames.add(zipEntryName);
        }
        return relsEntryNames;
    }

    private void addSignatureTime(XMLSignatureFactory signatureFactory, Document document, String signatureId, List<XMLStructure> objectContent) {
        Element signatureTimeElement = document.createElementNS(OOXML_DIGSIG_NS, "mdssi:SignatureTime");
        signatureTimeElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:mdssi", OOXML_DIGSIG_NS);
        Element formatElement = document.createElementNS(OOXML_DIGSIG_NS, "mdssi:Format");
        formatElement.setTextContent("YYYY-MM-DDThh:mm:ssTZD");
        signatureTimeElement.appendChild(formatElement);
        Element valueElement = document.createElementNS(OOXML_DIGSIG_NS, "mdssi:Value");
        Date now = this.clock.getTime();
        DateTime dateTime = new DateTime(now.getTime(), DateTimeZone.UTC);
        DateTimeFormatter fmt = ISODateTimeFormat.dateTimeNoMillis();
        String nowStr = fmt.print((ReadableInstant)dateTime);
        LOG.debug((Object)("now: " + nowStr));
        valueElement.setTextContent(nowStr);
        signatureTimeElement.appendChild(valueElement);
        LinkedList<DOMStructure> signatureTimeContent = new LinkedList<DOMStructure>();
        signatureTimeContent.add(new DOMStructure(signatureTimeElement));
        SignatureProperty signatureTimeSignatureProperty = signatureFactory.newSignatureProperty(signatureTimeContent, "#" + signatureId, "idSignatureTime");
        LinkedList<SignatureProperty> signaturePropertyContent = new LinkedList<SignatureProperty>();
        signaturePropertyContent.add(signatureTimeSignatureProperty);
        SignatureProperties signatureProperties = signatureFactory.newSignatureProperties(signaturePropertyContent, "id-signature-time-" + UUID.randomUUID().toString());
        objectContent.add(signatureProperties);
    }

    private void addSignatureInfo(XMLSignatureFactory signatureFactory, Document document, String signatureId, List<Reference> references, List<XMLObject> objects) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        LinkedList<SignatureProperties> objectContent = new LinkedList<SignatureProperties>();
        Element signatureInfoElement = document.createElementNS(OFFICE_DIGSIG_NS, "SignatureInfoV1");
        signatureInfoElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", OFFICE_DIGSIG_NS);
        Element manifestHashAlgorithmElement = document.createElementNS(OFFICE_DIGSIG_NS, "ManifestHashAlgorithm");
        manifestHashAlgorithmElement.setTextContent("http://www.w3.org/2000/09/xmldsig#sha1");
        signatureInfoElement.appendChild(manifestHashAlgorithmElement);
        LinkedList<DOMStructure> signatureInfoContent = new LinkedList<DOMStructure>();
        signatureInfoContent.add(new DOMStructure(signatureInfoElement));
        SignatureProperty signatureInfoSignatureProperty = signatureFactory.newSignatureProperty(signatureInfoContent, "#" + signatureId, "idOfficeV1Details");
        LinkedList<SignatureProperty> signaturePropertyContent = new LinkedList<SignatureProperty>();
        signaturePropertyContent.add(signatureInfoSignatureProperty);
        SignatureProperties signatureProperties = signatureFactory.newSignatureProperties(signaturePropertyContent, null);
        objectContent.add(signatureProperties);
        String objectId = "idOfficeObject";
        objects.add(signatureFactory.newXMLObject(objectContent, objectId, null, null));
        DigestMethod digestMethod = signatureFactory.newDigestMethod(this.digestAlgo.getXmlAlgoId(), null);
        Reference reference = signatureFactory.newReference("#" + objectId, digestMethod, null, "http://www.w3.org/2000/09/xmldsig#Object", null);
        references.add(reference);
    }

    protected Document loadDocument(String zipEntryName) throws IOException, ParserConfigurationException, SAXException {
        Document document = this.findDocument(zipEntryName);
        if (null != document) {
            return document;
        }
        throw new RuntimeException("ZIP entry not found: " + zipEntryName);
    }

    protected Document findDocument(String zipEntryName) throws IOException, ParserConfigurationException, SAXException {
        ZipEntry zipEntry;
        URL ooxmlUrl = this.signatureService.getOfficeOpenXMLDocumentURL();
        InputStream inputStream = ooxmlUrl.openStream();
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        while (null != (zipEntry = zipInputStream.getNextEntry())) {
            if (!zipEntryName.equals(zipEntry.getName())) continue;
            Document document = OOXMLSignatureFacet.loadDocument(zipInputStream);
            return document;
        }
        return null;
    }

    public static Document loadDocument(InputStream documentInputStream) throws ParserConfigurationException, SAXException, IOException {
        InputSource inputSource = new InputSource(documentInputStream);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        return documentBuilder.parse(inputSource);
    }

    @Override
    public void postSign(Element signatureElement, List<X509Certificate> signingCertificateChain) {
    }

    public static String getRelationshipReferenceURI(String zipEntryName) {
        return "/" + zipEntryName + "?ContentType=application/vnd.openxmlformats-package.relationships+xml";
    }

    public static String getResourceReferenceURI(String resourceName, String contentType) {
        return "/" + resourceName + "?ContentType=" + contentType;
    }

    public static boolean isSignedRelationship(String relationshipType) {
        LOG.debug((Object)("relationship type: " + relationshipType));
        for (String signedTypeExtension : signed) {
            if (!relationshipType.endsWith(signedTypeExtension)) continue;
            return true;
        }
        if (relationshipType.endsWith("customXml")) {
            LOG.debug((Object)"customXml relationship type");
            return true;
        }
        return false;
    }
}

