/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.service.signer.odf;

import be.fedict.eid.applet.service.signer.DigestAlgo;
import be.fedict.eid.applet.service.signer.SignatureFacet;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureProperties;
import javax.xml.crypto.dsig.SignatureProperty;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenOfficeSignatureFacet
implements SignatureFacet {
    private static final Log LOG = LogFactory.getLog(OpenOfficeSignatureFacet.class);
    private final DigestAlgo digestAlgo;

    public OpenOfficeSignatureFacet(DigestAlgo digestAlgo) {
        this.digestAlgo = digestAlgo;
    }

    @Override
    public void preSign(XMLSignatureFactory signatureFactory, Document document, String signatureId, List<X509Certificate> signingCertificateChain, List<Reference> references, List<XMLObject> objects) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        LOG.debug((Object)"pre sign");
        Element dateElement = document.createElementNS("", "dc:date");
        dateElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:dc", "http://purl.org/dc/elements/1.1/");
        DateTime dateTime = new DateTime(DateTimeZone.UTC);
        DateTimeFormatter fmt = ISODateTimeFormat.dateTimeNoMillis();
        String now = fmt.print((ReadableInstant)dateTime);
        now = now.substring(0, now.indexOf("Z"));
        LOG.debug((Object)("now: " + now));
        dateElement.setTextContent(now);
        String signaturePropertyId = "sign-prop-" + UUID.randomUUID().toString();
        LinkedList<DOMStructure> signaturePropertyContent = new LinkedList<DOMStructure>();
        signaturePropertyContent.add(new DOMStructure(dateElement));
        SignatureProperty signatureProperty = signatureFactory.newSignatureProperty(signaturePropertyContent, "#" + signatureId, signaturePropertyId);
        LinkedList<SignatureProperties> objectContent = new LinkedList<SignatureProperties>();
        LinkedList<SignatureProperty> signaturePropertiesContent = new LinkedList<SignatureProperty>();
        signaturePropertiesContent.add(signatureProperty);
        SignatureProperties signatureProperties = signatureFactory.newSignatureProperties(signaturePropertiesContent, null);
        objectContent.add(signatureProperties);
        objects.add(signatureFactory.newXMLObject(objectContent, null, null, null));
        DigestMethod digestMethod = signatureFactory.newDigestMethod(this.digestAlgo.getXmlAlgoId(), null);
        Reference reference = signatureFactory.newReference("#" + signaturePropertyId, digestMethod);
        references.add(reference);
    }

    @Override
    public void postSign(Element signatureElement, List<X509Certificate> signingCertificateChain) {
    }
}

