/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.service.signer.odf;

import be.fedict.eid.applet.service.signer.AbstractXmlSignatureService;
import be.fedict.eid.applet.service.signer.DigestAlgo;
import be.fedict.eid.applet.service.signer.facets.KeyInfoSignatureFacet;
import be.fedict.eid.applet.service.signer.facets.XAdESSignatureFacet;
import be.fedict.eid.applet.service.signer.odf.ODFSignatureFacet;
import be.fedict.eid.applet.service.signer.odf.ODFURIDereferencer;
import be.fedict.eid.applet.service.signer.odf.ODFUtil;
import be.fedict.eid.applet.service.signer.odf.OpenOfficeSignatureFacet;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.crypto.URIDereferencer;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public abstract class AbstractODFSignatureService
extends AbstractXmlSignatureService {
    private static final Log LOG = LogFactory.getLog(AbstractODFSignatureService.class);
    private final XAdESSignatureFacet xadesSignatureFacet;

    public AbstractODFSignatureService(DigestAlgo digestAlgo) {
        super(digestAlgo);
        this.addSignatureFacet(new ODFSignatureFacet(this, this.getSignatureDigestAlgorithm()));
        this.addSignatureFacet(new OpenOfficeSignatureFacet(this.getSignatureDigestAlgorithm()));
        this.xadesSignatureFacet = new XAdESSignatureFacet(this.getSignatureDigestAlgorithm());
        this.addSignatureFacet(this.xadesSignatureFacet);
        this.addSignatureFacet(new KeyInfoSignatureFacet(false, true, false));
    }

    protected XAdESSignatureFacet getXAdESSignatureFacet() {
        return this.xadesSignatureFacet;
    }

    protected abstract URL getOpenDocumentURL();

    protected final URIDereferencer getURIDereferencer() {
        URL odfUrl = this.getOpenDocumentURL();
        return new ODFURIDereferencer(odfUrl);
    }

    protected String getSignatureDescription() {
        return "ODF Document";
    }

    protected final OutputStream getSignedDocumentOutputStream() {
        LOG.debug((Object)"get signed document output stream");
        ODFSignedDocumentOutputStream signedDocumentOutputStream = new ODFSignedDocumentOutputStream();
        return signedDocumentOutputStream;
    }

    private void outputSignedOpenDocument(byte[] signatureData) throws IOException {
        ZipEntry zipEntry;
        LOG.debug((Object)"output signed open document");
        OutputStream signedOdfOutputStream = this.getSignedOpenDocumentOutputStream();
        if (null == signedOdfOutputStream) {
            throw new NullPointerException("signedOpenDocumentOutputStream is null");
        }
        ZipOutputStream zipOutputStream = new ZipOutputStream(signedOdfOutputStream);
        ZipInputStream zipInputStream = new ZipInputStream(this.getOpenDocumentURL().openStream());
        while (null != (zipEntry = zipInputStream.getNextEntry())) {
            if (zipEntry.getName().equals(ODFUtil.SIGNATURE_FILE)) continue;
            zipOutputStream.putNextEntry(zipEntry);
            IOUtils.copy((InputStream)zipInputStream, (OutputStream)zipOutputStream);
        }
        zipInputStream.close();
        zipEntry = new ZipEntry(ODFUtil.SIGNATURE_FILE);
        zipOutputStream.putNextEntry(zipEntry);
        IOUtils.write((byte[])signatureData, (OutputStream)zipOutputStream);
        zipOutputStream.close();
    }

    protected abstract OutputStream getSignedOpenDocumentOutputStream();

    public final String getFilesDigestAlgorithm() {
        return null;
    }

    protected final Document getEnvelopingDocument() throws ParserConfigurationException, IOException, SAXException {
        Document document = this.getODFSignatureDocument();
        if (null != document) {
            return document;
        }
        document = ODFUtil.getNewDocument();
        Element rootElement = document.createElementNS(ODFUtil.SIGNATURE_NS, ODFUtil.SIGNATURE_ELEMENT);
        rootElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", ODFUtil.SIGNATURE_NS);
        document.appendChild(rootElement);
        return document;
    }

    private Document getODFSignatureDocument() throws IOException, ParserConfigurationException, SAXException {
        URL odfUrl = this.getOpenDocumentURL();
        InputStream inputStream = ODFUtil.findDataInputStream(odfUrl.openStream(), ODFUtil.SIGNATURE_FILE);
        if (null != inputStream) {
            return ODFUtil.loadDocument(inputStream);
        }
        return null;
    }

    private class ODFSignedDocumentOutputStream
    extends ByteArrayOutputStream {
        private ODFSignedDocumentOutputStream() {
        }

        public void close() throws IOException {
            LOG.debug((Object)"close ODF signed document output stream");
            super.close();
            AbstractODFSignatureService.this.outputSignedOpenDocument(this.toByteArray());
        }
    }
}

