/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.service.signer.facets;

import be.fedict.eid.applet.service.signer.DigestAlgo;
import be.fedict.eid.applet.service.signer.SignatureFacet;
import be.fedict.eid.applet.service.signer.facets.RevocationData;
import be.fedict.eid.applet.service.signer.facets.RevocationDataService;
import be.fedict.eid.applet.service.signer.facets.XAdESNamespacePrefixMapper;
import be.fedict.eid.applet.service.signer.facets.XAdESSignatureFacet;
import be.fedict.eid.applet.service.signer.jaxb.xades132.CRLIdentifierType;
import be.fedict.eid.applet.service.signer.jaxb.xades132.CRLRefType;
import be.fedict.eid.applet.service.signer.jaxb.xades132.CRLRefsType;
import be.fedict.eid.applet.service.signer.jaxb.xades132.CRLValuesType;
import be.fedict.eid.applet.service.signer.jaxb.xades132.CertIDListType;
import be.fedict.eid.applet.service.signer.jaxb.xades132.CertIDType;
import be.fedict.eid.applet.service.signer.jaxb.xades132.CertificateValuesType;
import be.fedict.eid.applet.service.signer.jaxb.xades132.CompleteCertificateRefsType;
import be.fedict.eid.applet.service.signer.jaxb.xades132.CompleteRevocationRefsType;
import be.fedict.eid.applet.service.signer.jaxb.xades132.DigestAlgAndValueType;
import be.fedict.eid.applet.service.signer.jaxb.xades132.EncapsulatedPKIDataType;
import be.fedict.eid.applet.service.signer.jaxb.xades132.OCSPIdentifierType;
import be.fedict.eid.applet.service.signer.jaxb.xades132.OCSPRefType;
import be.fedict.eid.applet.service.signer.jaxb.xades132.OCSPRefsType;
import be.fedict.eid.applet.service.signer.jaxb.xades132.OCSPValuesType;
import be.fedict.eid.applet.service.signer.jaxb.xades132.ObjectFactory;
import be.fedict.eid.applet.service.signer.jaxb.xades132.ResponderIDType;
import be.fedict.eid.applet.service.signer.jaxb.xades132.RevocationValuesType;
import be.fedict.eid.applet.service.signer.jaxb.xades132.XAdESTimeStampType;
import be.fedict.eid.applet.service.signer.jaxb.xades141.ValidationDataType;
import be.fedict.eid.applet.service.signer.jaxb.xmldsig.CanonicalizationMethodType;
import be.fedict.eid.applet.service.signer.time.TimeStampService;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.transform.TransformerException;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xpath.XPathAPI;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.ocsp.ResponderID;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.PrincipalUtil;
import org.bouncycastle.ocsp.BasicOCSPResp;
import org.bouncycastle.ocsp.OCSPException;
import org.bouncycastle.ocsp.OCSPResp;
import org.bouncycastle.ocsp.RespID;
import org.joda.time.DateTime;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XAdESXLSignatureFacet
implements SignatureFacet {
    private static final Log LOG = LogFactory.getLog(XAdESXLSignatureFacet.class);
    public static final String XADES_NAMESPACE = "http://uri.etsi.org/01903/v1.3.2#";
    public static final String XADES141_NAMESPACE = "http://uri.etsi.org/01903/v1.4.1#";
    private Element nsElement;
    private final ObjectFactory objectFactory = new ObjectFactory();
    private final be.fedict.eid.applet.service.signer.jaxb.xades141.ObjectFactory xades141ObjectFactory;
    private final be.fedict.eid.applet.service.signer.jaxb.xmldsig.ObjectFactory xmldsigObjectFactory;
    private final TimeStampService timeStampService;
    private String c14nAlgoId = "http://www.w3.org/2001/10/xml-exc-c14n#";
    private final Marshaller marshaller;
    private final RevocationDataService revocationDataService;
    private final CertificateFactory certificateFactory;
    private final DatatypeFactory datatypeFactory;
    private final DigestAlgo digestAlgorithm;

    public XAdESXLSignatureFacet(TimeStampService timeStampService, RevocationDataService revocationDataService) {
        this(timeStampService, revocationDataService, DigestAlgo.SHA1);
    }

    public XAdESXLSignatureFacet(TimeStampService timeStampService, RevocationDataService revocationDataService, DigestAlgo digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
        this.timeStampService = timeStampService;
        this.revocationDataService = revocationDataService;
        this.xmldsigObjectFactory = new be.fedict.eid.applet.service.signer.jaxb.xmldsig.ObjectFactory();
        this.xades141ObjectFactory = new be.fedict.eid.applet.service.signer.jaxb.xades141.ObjectFactory();
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{be.fedict.eid.applet.service.signer.jaxb.xades141.ObjectFactory.class});
            this.marshaller = context.createMarshaller();
            this.marshaller.setProperty("jaxb.formatted.output", (Object)true);
            this.marshaller.setProperty("com.sun.xml.bind.namespacePrefixMapper", (Object)new XAdESNamespacePrefixMapper());
        }
        catch (JAXBException e) {
            throw new RuntimeException("JAXB error: " + e.getMessage(), e);
        }
        try {
            this.certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new RuntimeException("X509 JCA error: " + e.getMessage(), e);
        }
        try {
            this.datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException("datatype config error: " + e.getMessage(), e);
        }
    }

    public void setCanonicalizerAlgorithm(String c14nAlgoId) {
        this.c14nAlgoId = c14nAlgoId;
    }

    private Node findSingleNode(Node baseNode, String xpathExpression) {
        if (null == this.nsElement) {
            this.nsElement = XAdESXLSignatureFacet.createNamespaceElement(baseNode);
        }
        return XAdESXLSignatureFacet.findSingleNode(baseNode, xpathExpression, this.nsElement);
    }

    public static Node findSingleNode(Node baseNode, String xpathExpression, Element nsElement) {
        try {
            Node node = XPathAPI.selectSingleNode((Node)baseNode, (String)xpathExpression, (Node)nsElement);
            return node;
        }
        catch (TransformerException e) {
            throw new RuntimeException("XPath error: " + e.getMessage(), e);
        }
    }

    public static NodeList getNodes(Node baseNode, String xpathExpression, Element nsElement) {
        try {
            NodeList nodeList = XPathAPI.selectNodeList((Node)baseNode, (String)xpathExpression, (Node)nsElement);
            return nodeList;
        }
        catch (TransformerException e) {
            throw new RuntimeException("XPath error: " + e.getMessage(), e);
        }
    }

    @Override
    public void postSign(Element signatureElement, List<X509Certificate> signingCertificateChain) {
        Element unsignedSignaturePropertiesElement;
        LOG.debug((Object)"XAdES-X-L post sign phase");
        Element qualifyingPropertiesElement = (Element)this.findSingleNode(signatureElement, "ds:Object/xades:QualifyingProperties");
        if (null == qualifyingPropertiesElement) {
            throw new IllegalArgumentException("no XAdES-BES extension present");
        }
        Document document = signatureElement.getOwnerDocument();
        String xadesNamespacePrefix = null != qualifyingPropertiesElement.getPrefix() ? qualifyingPropertiesElement.getPrefix() + ":" : "";
        Element unsignedPropertiesElement = (Element)this.findSingleNode(qualifyingPropertiesElement, "xades:UnsignedProperties");
        if (null == unsignedPropertiesElement) {
            unsignedPropertiesElement = document.createElementNS(XADES_NAMESPACE, xadesNamespacePrefix + "UnsignedProperties");
            qualifyingPropertiesElement.appendChild(unsignedPropertiesElement);
        }
        if (null == (unsignedSignaturePropertiesElement = (Element)this.findSingleNode(unsignedPropertiesElement, "xades:UnsignedSignatureProperties"))) {
            unsignedSignaturePropertiesElement = document.createElementNS(XADES_NAMESPACE, xadesNamespacePrefix + "UnsignedSignatureProperties");
            unsignedPropertiesElement.appendChild(unsignedSignaturePropertiesElement);
        }
        Node signatureValueNode = this.findSingleNode(signatureElement, "ds:SignatureValue");
        RevocationData tsaRevocationDataXadesT = new RevocationData();
        LOG.debug((Object)"creating XAdES-T time-stamp");
        XAdESTimeStampType signatureTimeStamp = XAdESXLSignatureFacet.createXAdESTimeStamp(Collections.singletonList(signatureValueNode), tsaRevocationDataXadesT, this.c14nAlgoId, this.timeStampService, this.objectFactory, this.xmldsigObjectFactory);
        try {
            this.marshaller.marshal(this.objectFactory.createSignatureTimeStamp(signatureTimeStamp), (Node)unsignedSignaturePropertiesElement);
        }
        catch (JAXBException e) {
            throw new RuntimeException("JAXB error: " + e.getMessage(), e);
        }
        if (tsaRevocationDataXadesT.hasRevocationDataEntries()) {
            ValidationDataType validationData = this.createValidationData(tsaRevocationDataXadesT);
            try {
                this.marshaller.marshal(this.xades141ObjectFactory.createTimeStampValidationData(validationData), (Node)unsignedSignaturePropertiesElement);
            }
            catch (JAXBException e) {
                throw new RuntimeException("JAXB error: " + e.getMessage(), e);
            }
        }
        if (null == this.revocationDataService) {
            return;
        }
        CompleteCertificateRefsType completeCertificateRefs = this.objectFactory.createCompleteCertificateRefsType();
        CertIDListType certIdList = this.objectFactory.createCertIDListType();
        completeCertificateRefs.setCertRefs(certIdList);
        List<CertIDType> certIds = certIdList.getCert();
        for (int certIdx = 1; certIdx < signingCertificateChain.size(); ++certIdx) {
            X509Certificate certificate = signingCertificateChain.get(certIdx);
            CertIDType certId = XAdESSignatureFacet.getCertID(certificate, this.objectFactory, this.xmldsigObjectFactory, this.digestAlgorithm, false);
            certIds.add(certId);
        }
        CompleteRevocationRefsType completeRevocationRefs = this.objectFactory.createCompleteRevocationRefsType();
        RevocationData revocationData = this.revocationDataService.getRevocationData(signingCertificateChain);
        if (revocationData.hasCRLs()) {
            CRLRefsType crlRefs = this.objectFactory.createCRLRefsType();
            completeRevocationRefs.setCRLRefs(crlRefs);
            List<CRLRefType> crlRefList = crlRefs.getCRLRef();
            List<byte[]> crls = revocationData.getCRLs();
            for (byte[] encodedCrl : crls) {
                String issuerName;
                X509CRL crl;
                CRLRefType crlRef = this.objectFactory.createCRLRefType();
                crlRefList.add(crlRef);
                try {
                    crl = (X509CRL)this.certificateFactory.generateCRL(new ByteArrayInputStream(encodedCrl));
                }
                catch (CRLException e) {
                    throw new RuntimeException("CRL parse error: " + e.getMessage(), e);
                }
                CRLIdentifierType crlIdentifier = this.objectFactory.createCRLIdentifierType();
                crlRef.setCRLIdentifier(crlIdentifier);
                try {
                    issuerName = PrincipalUtil.getIssuerX509Principal((X509CRL)crl).getName().replace(",", ", ");
                }
                catch (CRLException e) {
                    throw new RuntimeException("CRL encoding error: " + e.getMessage(), e);
                }
                crlIdentifier.setIssuer(issuerName);
                crlIdentifier.setIssueTime(this.datatypeFactory.newXMLGregorianCalendar(new DateTime((Object)crl.getThisUpdate()).toGregorianCalendar()));
                crlIdentifier.setNumber(this.getCrlNumber(crl));
                DigestAlgAndValueType digestAlgAndValue = XAdESSignatureFacet.getDigestAlgAndValue(encodedCrl, this.objectFactory, this.xmldsigObjectFactory, this.digestAlgorithm);
                crlRef.setDigestAlgAndValue(digestAlgAndValue);
            }
        }
        if (revocationData.hasOCSPs()) {
            OCSPRefsType ocspRefs = this.objectFactory.createOCSPRefsType();
            completeRevocationRefs.setOCSPRefs(ocspRefs);
            List<OCSPRefType> ocspRefList = ocspRefs.getOCSPRef();
            List<byte[]> ocsps = revocationData.getOCSPs();
            for (byte[] ocsp : ocsps) {
                Object ocspResponseObject;
                OCSPResp ocspResp;
                OCSPRefType ocspRef = this.objectFactory.createOCSPRefType();
                ocspRefList.add(ocspRef);
                DigestAlgAndValueType digestAlgAndValue = XAdESSignatureFacet.getDigestAlgAndValue(ocsp, this.objectFactory, this.xmldsigObjectFactory, this.digestAlgorithm);
                ocspRef.setDigestAlgAndValue(digestAlgAndValue);
                OCSPIdentifierType ocspIdentifier = this.objectFactory.createOCSPIdentifierType();
                ocspRef.setOCSPIdentifier(ocspIdentifier);
                try {
                    ocspResp = new OCSPResp(ocsp);
                }
                catch (IOException e) {
                    throw new RuntimeException("OCSP decoding error: " + e.getMessage(), e);
                }
                try {
                    ocspResponseObject = ocspResp.getResponseObject();
                }
                catch (OCSPException e) {
                    throw new RuntimeException("OCSP error: " + e.getMessage(), e);
                }
                BasicOCSPResp basicOcspResp = (BasicOCSPResp)ocspResponseObject;
                Date producedAt = basicOcspResp.getProducedAt();
                ocspIdentifier.setProducedAt(this.datatypeFactory.newXMLGregorianCalendar(new DateTime((Object)producedAt).toGregorianCalendar()));
                ResponderIDType responderId = this.objectFactory.createResponderIDType();
                ocspIdentifier.setResponderID(responderId);
                RespID respId = basicOcspResp.getResponderId();
                ResponderID ocspResponderId = respId.toASN1Object();
                DERTaggedObject derTaggedObject = (DERTaggedObject)ocspResponderId.toASN1Object();
                if (2 == derTaggedObject.getTagNo()) {
                    ASN1OctetString keyHashOctetString = (ASN1OctetString)derTaggedObject.getObject();
                    responderId.setByKey(keyHashOctetString.getOctets());
                    continue;
                }
                X509Name name = X509Name.getInstance((Object)derTaggedObject.getObject());
                responderId.setByName(name.toString());
            }
        }
        NodeList unsignedSignaturePropertiesNodeList = qualifyingPropertiesElement.getElementsByTagNameNS(XADES_NAMESPACE, "UnsignedSignatureProperties");
        Node unsignedSignaturePropertiesNode = unsignedSignaturePropertiesNodeList.item(0);
        try {
            this.marshaller.marshal(this.objectFactory.createCompleteCertificateRefs(completeCertificateRefs), unsignedSignaturePropertiesNode);
            this.marshaller.marshal(this.objectFactory.createCompleteRevocationRefs(completeRevocationRefs), unsignedSignaturePropertiesNode);
        }
        catch (JAXBException e) {
            throw new RuntimeException("JAXB error: " + e.getMessage(), e);
        }
        LinkedList<Node> timeStampNodesXadesX1 = new LinkedList<Node>();
        timeStampNodesXadesX1.add(signatureValueNode);
        Node signatureTimeStampNode = this.findSingleNode(unsignedSignaturePropertiesNode, "xades:SignatureTimeStamp");
        timeStampNodesXadesX1.add(signatureTimeStampNode);
        Node completeCertificateRefsNode = this.findSingleNode(unsignedSignaturePropertiesNode, "xades:CompleteCertificateRefs");
        timeStampNodesXadesX1.add(completeCertificateRefsNode);
        Node completeRevocationRefsNode = this.findSingleNode(unsignedSignaturePropertiesNode, "xades:CompleteRevocationRefs");
        timeStampNodesXadesX1.add(completeRevocationRefsNode);
        RevocationData tsaRevocationDataXadesX1 = new RevocationData();
        LOG.debug((Object)"creating XAdES-X time-stamp");
        XAdESTimeStampType timeStampXadesX1 = XAdESXLSignatureFacet.createXAdESTimeStamp(timeStampNodesXadesX1, tsaRevocationDataXadesX1, this.c14nAlgoId, this.timeStampService, this.objectFactory, this.xmldsigObjectFactory);
        ValidationDataType timeStampXadesX1ValidationData = tsaRevocationDataXadesX1.hasRevocationDataEntries() ? this.createValidationData(tsaRevocationDataXadesX1) : null;
        try {
            this.marshaller.marshal(this.objectFactory.createSigAndRefsTimeStamp(timeStampXadesX1), unsignedSignaturePropertiesNode);
            if (null != timeStampXadesX1ValidationData) {
                this.marshaller.marshal(this.xades141ObjectFactory.createTimeStampValidationData(timeStampXadesX1ValidationData), unsignedSignaturePropertiesNode);
            }
        }
        catch (JAXBException e) {
            throw new RuntimeException("JAXB error: " + e.getMessage(), e);
        }
        CertificateValuesType certificateValues = this.objectFactory.createCertificateValuesType();
        List<Object> certificateValuesList = certificateValues.getEncapsulatedX509CertificateOrOtherCertificate();
        for (X509Certificate certificate : signingCertificateChain) {
            EncapsulatedPKIDataType encapsulatedPKIDataType = this.objectFactory.createEncapsulatedPKIDataType();
            try {
                encapsulatedPKIDataType.setValue(certificate.getEncoded());
            }
            catch (CertificateEncodingException e) {
                throw new RuntimeException("certificate encoding error: " + e.getMessage(), e);
            }
            certificateValuesList.add(encapsulatedPKIDataType);
        }
        RevocationValuesType revocationValues = this.createRevocationValues(revocationData);
        try {
            this.marshaller.marshal(this.objectFactory.createCertificateValues(certificateValues), unsignedSignaturePropertiesNode);
            this.marshaller.marshal(this.objectFactory.createRevocationValues(revocationValues), unsignedSignaturePropertiesNode);
        }
        catch (JAXBException e) {
            throw new RuntimeException("JAXB error: " + e.getMessage(), e);
        }
    }

    public static byte[] getC14nValue(List<Node> nodeList, String c14nAlgoId) {
        byte[] c14nValue = null;
        try {
            for (Node node : nodeList) {
                Canonicalizer c14n;
                try {
                    c14n = Canonicalizer.getInstance((String)c14nAlgoId);
                }
                catch (InvalidCanonicalizerException e) {
                    throw new RuntimeException("c14n algo error: " + e.getMessage(), e);
                }
                c14nValue = ArrayUtils.addAll(c14nValue, (byte[])c14n.canonicalizeSubtree(node));
            }
        }
        catch (CanonicalizationException e) {
            throw new RuntimeException("c14n error: " + e.getMessage(), e);
        }
        return c14nValue;
    }

    public static Element createNamespaceElement(Node documentNode) {
        Document document = documentNode.getOwnerDocument();
        Element nsElement = document.createElement("nsElement");
        nsElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:ds", "http://www.w3.org/2000/09/xmldsig#");
        nsElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xades", XADES_NAMESPACE);
        return nsElement;
    }

    @Override
    public void preSign(XMLSignatureFactory signatureFactory, Document document, String signatureId, List<X509Certificate> signingCertificateChain, List<Reference> references, List<XMLObject> objects) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
    }

    private BigInteger getCrlNumber(X509CRL crl) {
        byte[] crlNumberExtensionValue = crl.getExtensionValue(X509Extensions.CRLNumber.getId());
        if (null == crlNumberExtensionValue) {
            return null;
        }
        try {
            ASN1InputStream asn1InputStream = new ASN1InputStream(crlNumberExtensionValue);
            ASN1OctetString octetString = (ASN1OctetString)asn1InputStream.readObject();
            byte[] octets = octetString.getOctets();
            DERInteger integer = (DERInteger)new ASN1InputStream(octets).readObject();
            BigInteger crlNumber = integer.getPositiveValue();
            return crlNumber;
        }
        catch (IOException e) {
            throw new RuntimeException("I/O error: " + e.getMessage(), e);
        }
    }

    public static XAdESTimeStampType createXAdESTimeStamp(List<Node> nodeList, RevocationData revocationData, String c14nAlgoId, TimeStampService timeStampService, ObjectFactory objectFactory, be.fedict.eid.applet.service.signer.jaxb.xmldsig.ObjectFactory xmldsigObjectFactory) {
        byte[] c14nSignatureValueElement = XAdESXLSignatureFacet.getC14nValue(nodeList, c14nAlgoId);
        return XAdESXLSignatureFacet.createXAdESTimeStamp(c14nSignatureValueElement, revocationData, c14nAlgoId, timeStampService, objectFactory, xmldsigObjectFactory);
    }

    public static XAdESTimeStampType createXAdESTimeStamp(byte[] data, RevocationData revocationData, String c14nAlgoId, TimeStampService timeStampService, ObjectFactory objectFactory, be.fedict.eid.applet.service.signer.jaxb.xmldsig.ObjectFactory xmldsigObjectFactory) {
        byte[] timeStampToken;
        try {
            timeStampToken = timeStampService.timeStamp(data, revocationData);
        }
        catch (Exception e) {
            throw new RuntimeException("error while creating a time-stamp: " + e.getMessage(), e);
        }
        XAdESTimeStampType xadesTimeStamp = objectFactory.createXAdESTimeStampType();
        CanonicalizationMethodType c14nMethod = xmldsigObjectFactory.createCanonicalizationMethodType();
        c14nMethod.setAlgorithm(c14nAlgoId);
        xadesTimeStamp.setCanonicalizationMethod(c14nMethod);
        xadesTimeStamp.setId("time-stamp-" + UUID.randomUUID().toString());
        EncapsulatedPKIDataType encapsulatedTimeStamp = objectFactory.createEncapsulatedPKIDataType();
        encapsulatedTimeStamp.setValue(timeStampToken);
        encapsulatedTimeStamp.setId("time-stamp-token-" + UUID.randomUUID().toString());
        List<Object> timeStampContent = xadesTimeStamp.getEncapsulatedTimeStampOrXMLTimeStamp();
        timeStampContent.add(encapsulatedTimeStamp);
        return xadesTimeStamp;
    }

    private ValidationDataType createValidationData(RevocationData revocationData) {
        ValidationDataType validationData = this.xades141ObjectFactory.createValidationDataType();
        RevocationValuesType revocationValues = this.createRevocationValues(revocationData);
        validationData.setRevocationValues(revocationValues);
        return validationData;
    }

    private RevocationValuesType createRevocationValues(RevocationData revocationData) {
        RevocationValuesType revocationValues = this.objectFactory.createRevocationValuesType();
        if (revocationData.hasCRLs()) {
            CRLValuesType crlValues = this.objectFactory.createCRLValuesType();
            revocationValues.setCRLValues(crlValues);
            List<EncapsulatedPKIDataType> encapsulatedCrlValues = crlValues.getEncapsulatedCRLValue();
            List<byte[]> crls = revocationData.getCRLs();
            for (byte[] crl : crls) {
                EncapsulatedPKIDataType encapsulatedCrlValue = this.objectFactory.createEncapsulatedPKIDataType();
                encapsulatedCrlValue.setValue(crl);
                encapsulatedCrlValues.add(encapsulatedCrlValue);
            }
        }
        if (revocationData.hasOCSPs()) {
            OCSPValuesType ocspValues = this.objectFactory.createOCSPValuesType();
            revocationValues.setOCSPValues(ocspValues);
            List<EncapsulatedPKIDataType> encapsulatedOcspValues = ocspValues.getEncapsulatedOCSPValue();
            List<byte[]> ocsps = revocationData.getOCSPs();
            for (byte[] ocsp : ocsps) {
                EncapsulatedPKIDataType encapsulatedOcspValue = this.objectFactory.createEncapsulatedPKIDataType();
                encapsulatedOcspValue.setValue(ocsp);
                encapsulatedOcspValues.add(encapsulatedOcspValue);
            }
        }
        return revocationValues;
    }

    static {
        Init.init();
    }
}

