/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.service.signer.asic;

import be.fedict.eid.applet.service.signer.odf.ODFUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.xml.crypto.Data;
import javax.xml.crypto.OctetStreamData;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.URIReference;
import javax.xml.crypto.URIReferenceException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ASiCURIDereferencer
implements URIDereferencer {
    private static final Log LOG = LogFactory.getLog(ASiCURIDereferencer.class);
    private final File tmpFile;
    private final byte[] data;
    private final URIDereferencer baseUriDereferener;

    public ASiCURIDereferencer(File tmpFile) {
        this(null, tmpFile);
    }

    public ASiCURIDereferencer(byte[] data) {
        this(data, null);
    }

    protected ASiCURIDereferencer(byte[] data, File tmpFile) {
        this.data = data;
        this.tmpFile = tmpFile;
        XMLSignatureFactory xmlSignatureFactory = XMLSignatureFactory.getInstance();
        this.baseUriDereferener = xmlSignatureFactory.getURIDereferencer();
    }

    public Data dereference(URIReference uriReference, XMLCryptoContext context) throws URIReferenceException {
        InputStream dataInputStream;
        InputStream zipInputStream;
        if (null == uriReference) {
            throw new URIReferenceException("URIReference cannot be null");
        }
        if (null == context) {
            throw new URIReferenceException("XMLCrytoContext cannot be null");
        }
        String uri = uriReference.getURI();
        try {
            uri = URLDecoder.decode(uri, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn((Object)("could not URL decode the uri: " + uri));
        }
        LOG.debug((Object)("dereference: " + uri));
        if (null != this.tmpFile) {
            try {
                zipInputStream = new FileInputStream(this.tmpFile);
            }
            catch (FileNotFoundException e) {
                throw new URIReferenceException("file not found error: " + e.getMessage(), e);
            }
        } else {
            zipInputStream = new ByteArrayInputStream(this.data);
        }
        try {
            dataInputStream = ODFUtil.findDataInputStream(zipInputStream, uri);
        }
        catch (IOException e) {
            throw new URIReferenceException("I/O error: " + e.getMessage(), e);
        }
        if (null == dataInputStream) {
            return this.baseUriDereferener.dereference(uriReference, context);
        }
        return new OctetStreamData(dataInputStream, uri, null);
    }
}

