/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.service.signer;

import be.fedict.eid.applet.service.signer.DigestAlgo;
import be.fedict.eid.applet.service.signer.NoCloseInputStream;
import be.fedict.eid.applet.service.signer.NoCloseOutputStream;
import be.fedict.eid.applet.service.signer.SignatureFacet;
import be.fedict.eid.applet.service.signer.TemporaryDataStorage;
import be.fedict.eid.applet.service.spi.DigestInfo;
import be.fedict.eid.applet.service.spi.SignatureService;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Manifest;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.utils.Base64;
import org.apache.xpath.XPathAPI;
import org.jcp.xml.dsig.internal.dom.DOMReference;
import org.jcp.xml.dsig.internal.dom.DOMSignedInfo;
import org.jcp.xml.dsig.internal.dom.DOMXMLSignature;
import org.jcp.xml.dsig.internal.dom.XMLDSigRI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractXmlSignatureService
implements SignatureService {
    static final Log LOG = LogFactory.getLog(AbstractXmlSignatureService.class);
    private static final String SIGNATURE_ID_ATTRIBUTE = "signature-id";
    private final List<SignatureFacet> signatureFacets = new LinkedList<SignatureFacet>();
    private String signatureNamespacePrefix = null;
    private String signatureId = null;
    private final DigestAlgo digestAlgo;

    public AbstractXmlSignatureService(DigestAlgo digestAlgo) {
        this.digestAlgo = digestAlgo;
    }

    protected void setSignatureId(String signatureId) {
        this.signatureId = signatureId;
    }

    protected void setSignatureNamespacePrefix(String signatureNamespacePrefix) {
        this.signatureNamespacePrefix = signatureNamespacePrefix;
    }

    protected void addSignatureFacet(SignatureFacet signatureFacet) {
        this.signatureFacets.add(signatureFacet);
    }

    protected DigestAlgo getSignatureDigestAlgorithm() {
        return null != this.digestAlgo ? this.digestAlgo : DigestAlgo.SHA1;
    }

    protected Document getEnvelopingDocument() throws ParserConfigurationException, IOException, SAXException {
        return null;
    }

    protected URIDereferencer getURIDereferencer() {
        return null;
    }

    protected String getSignatureDescription() {
        return "XML Document";
    }

    protected abstract TemporaryDataStorage getTemporaryDataStorage();

    protected abstract OutputStream getSignedDocumentOutputStream();

    public DigestInfo preSign(List<DigestInfo> digestInfos, List<X509Certificate> signingCertificateChain) throws NoSuchAlgorithmException {
        byte[] digestValue;
        LOG.debug((Object)"preSign");
        DigestAlgo digestAlgo = this.getSignatureDigestAlgorithm();
        try {
            digestValue = this.getXmlSignatureDigestValue(digestAlgo, digestInfos, signingCertificateChain);
        }
        catch (Exception e) {
            throw new RuntimeException("XML signature error: " + e.getMessage(), e);
        }
        String description = this.getSignatureDescription();
        return new DigestInfo(digestValue, digestAlgo.getAlgoId(), description);
    }

    public void postSign(byte[] signatureValue, List<X509Certificate> signingCertificateChain) {
        Element signatureElement;
        Document document;
        LOG.debug((Object)"postSign");
        TemporaryDataStorage temporaryDataStorage = this.getTemporaryDataStorage();
        InputStream documentInputStream = temporaryDataStorage.getTempInputStream();
        String signatureId = (String)((Object)temporaryDataStorage.getAttribute(SIGNATURE_ID_ATTRIBUTE));
        LOG.debug((Object)("signature Id: " + signatureId));
        try {
            document = this.loadDocument(documentInputStream);
        }
        catch (Exception e) {
            throw new RuntimeException("DOM error: " + e.getMessage(), e);
        }
        Element nsElement = document.createElement("ns");
        nsElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:ds", "http://www.w3.org/2000/09/xmldsig#");
        try {
            signatureElement = (Element)XPathAPI.selectSingleNode((Node)document, (String)("//ds:Signature[@Id='" + signatureId + "']"), (Node)nsElement);
        }
        catch (TransformerException e) {
            throw new RuntimeException("XPATH error: " + e.getMessage(), e);
        }
        if (null == signatureElement) {
            throw new RuntimeException("ds:Signature not found for @Id: " + signatureId);
        }
        NodeList signatureValueNodeList = signatureElement.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "SignatureValue");
        Element signatureValueElement = (Element)signatureValueNodeList.item(0);
        signatureValueElement.setTextContent(Base64.encode((byte[])signatureValue));
        for (SignatureFacet signatureFacet : this.signatureFacets) {
            signatureFacet.postSign(signatureElement, signingCertificateChain);
        }
        OutputStream signedDocumentOutputStream = this.getSignedDocumentOutputStream();
        if (null == signedDocumentOutputStream) {
            throw new IllegalArgumentException("signed document output stream is null");
        }
        try {
            this.writeDocument(document, signedDocumentOutputStream);
        }
        catch (Exception e) {
            LOG.debug((Object)("error writing the signed XML document: " + e.getMessage()), (Throwable)e);
            throw new RuntimeException("error writing the signed XML document: " + e.getMessage(), e);
        }
    }

    protected String getCanonicalizationMethod() {
        return "http://www.w3.org/2001/10/xml-exc-c14n#";
    }

    private byte[] getXmlSignatureDigestValue(DigestAlgo digestAlgo, List<DigestInfo> digestInfos, List<X509Certificate> signingCertificateChain) throws ParserConfigurationException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, MarshalException, XMLSignatureException, TransformerFactoryConfigurationError, TransformerException, IOException, SAXException {
        Document document = this.getEnvelopingDocument();
        if (null == document) {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.newDocument();
        }
        Key key = new Key(){
            private static final long serialVersionUID = 1L;

            public String getAlgorithm() {
                return null;
            }

            public byte[] getEncoded() {
                return null;
            }

            public String getFormat() {
                return null;
            }
        };
        DOMSignContext xmlSignContext = new DOMSignContext(key, (Node)document);
        URIDereferencer uriDereferencer = this.getURIDereferencer();
        if (null != uriDereferencer) {
            xmlSignContext.setURIDereferencer(uriDereferencer);
        }
        if (null != this.signatureNamespacePrefix) {
            xmlSignContext.putNamespacePrefix("http://www.w3.org/2000/09/xmldsig#", this.signatureNamespacePrefix);
        }
        XMLSignatureFactory signatureFactory = XMLSignatureFactory.getInstance("DOM", new XMLDSigRI());
        LinkedList<Reference> references = new LinkedList<Reference>();
        this.addDigestInfosAsReferences(digestInfos, signatureFactory, references);
        String localSignatureId = null == this.signatureId ? "xmldsig-" + UUID.randomUUID().toString() : this.signatureId;
        LinkedList<XMLObject> objects = new LinkedList<XMLObject>();
        for (SignatureFacet signatureFacet : this.signatureFacets) {
            LOG.debug((Object)("invoking signature facet: " + signatureFacet.getClass().getSimpleName()));
            signatureFacet.preSign(signatureFactory, document, localSignatureId, signingCertificateChain, references, objects);
        }
        SignatureMethod signatureMethod = signatureFactory.newSignatureMethod(this.getSignatureMethod(digestAlgo), null);
        CanonicalizationMethod canonicalizationMethod = signatureFactory.newCanonicalizationMethod(this.getCanonicalizationMethod(), (C14NMethodParameterSpec)null);
        SignedInfo signedInfo = signatureFactory.newSignedInfo(canonicalizationMethod, signatureMethod, references);
        String signatureValueId = localSignatureId + "-signature-value";
        XMLSignature xmlSignature = signatureFactory.newXMLSignature(signedInfo, null, objects, localSignatureId, signatureValueId);
        DOMXMLSignature domXmlSignature = (DOMXMLSignature)xmlSignature;
        Node documentNode = document.getDocumentElement();
        if (null == documentNode) {
            documentNode = document;
        }
        domXmlSignature.marshal(documentNode, this.signatureNamespacePrefix, xmlSignContext);
        for (XMLObject object : objects) {
            LOG.debug((Object)("object java type: " + object.getClass().getName()));
            List<XMLStructure> objectContentList = object.getContent();
            for (XMLStructure objectContent : objectContentList) {
                LOG.debug((Object)("object content java type: " + objectContent.getClass().getName()));
                if (!(objectContent instanceof Manifest)) continue;
                Manifest manifest = (Manifest)objectContent;
                List<Reference> manifestReferences = manifest.getReferences();
                for (Reference manifestReference : manifestReferences) {
                    if (null != manifestReference.getDigestValue()) continue;
                    DOMReference manifestDOMReference = (DOMReference)manifestReference;
                    manifestDOMReference.digest(xmlSignContext);
                }
            }
        }
        List<Reference> signedInfoReferences = signedInfo.getReferences();
        for (Reference signedInfoReference : signedInfoReferences) {
            DOMReference domReference = (DOMReference)signedInfoReference;
            if (null != domReference.getDigestValue()) continue;
            domReference.digest(xmlSignContext);
        }
        TemporaryDataStorage temporaryDataStorage = this.getTemporaryDataStorage();
        OutputStream tempDocumentOutputStream = temporaryDataStorage.getTempOutputStream();
        this.writeDocument(document, tempDocumentOutputStream);
        temporaryDataStorage.setAttribute(SIGNATURE_ID_ATTRIBUTE, (Serializable)((Object)localSignatureId));
        DOMSignedInfo domSignedInfo = (DOMSignedInfo)signedInfo;
        ByteArrayOutputStream dataStream = new ByteArrayOutputStream();
        domSignedInfo.canonicalize(xmlSignContext, dataStream);
        byte[] octets = dataStream.toByteArray();
        MessageDigest jcaMessageDigest = MessageDigest.getInstance(digestAlgo.getAlgoId());
        byte[] digestValue = jcaMessageDigest.digest(octets);
        return digestValue;
    }

    private void addDigestInfosAsReferences(List<DigestInfo> digestInfos, XMLSignatureFactory signatureFactory, List<Reference> references) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException, MalformedURLException {
        if (null == digestInfos) {
            return;
        }
        for (DigestInfo digestInfo : digestInfos) {
            byte[] documentDigestValue = digestInfo.digestValue;
            DigestMethod digestMethod = signatureFactory.newDigestMethod(this.getXmlDigestAlgo(digestInfo.digestAlgo), null);
            String uri = FilenameUtils.getName((String)new File(digestInfo.description).toURI().toURL().getFile());
            Reference reference = signatureFactory.newReference(uri, digestMethod, null, null, null, documentDigestValue);
            references.add(reference);
        }
    }

    private String getXmlDigestAlgo(String digestAlgo) {
        if ("SHA-1".equals(digestAlgo)) {
            return "http://www.w3.org/2000/09/xmldsig#sha1";
        }
        if ("SHA-256".equals(digestAlgo)) {
            return "http://www.w3.org/2001/04/xmlenc#sha256";
        }
        if ("SHA-512".equals(digestAlgo)) {
            return "http://www.w3.org/2001/04/xmlenc#sha512";
        }
        throw new RuntimeException("unsupported digest algo: " + digestAlgo);
    }

    private String getSignatureMethod(DigestAlgo digestAlgo) {
        if (null == digestAlgo) {
            throw new RuntimeException("digest algo is null");
        }
        switch (digestAlgo) {
            case SHA1: {
                return "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
            }
            case SHA256: {
                return "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
            }
            case SHA512: {
                return "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512";
            }
        }
        throw new RuntimeException("unsupported sign algo: " + (Object)((Object)digestAlgo));
    }

    protected void writeDocument(Document document, OutputStream documentOutputStream) throws TransformerConfigurationException, TransformerFactoryConfigurationError, TransformerException, IOException {
        this.writeDocumentNoClosing(document, documentOutputStream);
        documentOutputStream.close();
    }

    protected void writeDocumentNoClosing(Document document, OutputStream documentOutputStream) throws TransformerConfigurationException, TransformerFactoryConfigurationError, TransformerException, IOException {
        this.writeDocumentNoClosing(document, documentOutputStream, false);
    }

    protected void writeDocumentNoClosing(Document document, OutputStream documentOutputStream, boolean omitXmlDeclaration) throws TransformerConfigurationException, TransformerFactoryConfigurationError, TransformerException, IOException {
        NoCloseOutputStream outputStream = new NoCloseOutputStream(documentOutputStream);
        StreamResult result = new StreamResult((OutputStream)((Object)outputStream));
        Transformer xformer = TransformerFactory.newInstance().newTransformer();
        if (omitXmlDeclaration) {
            xformer.setOutputProperty("omit-xml-declaration", "yes");
        }
        DOMSource source = new DOMSource(document);
        xformer.transform(source, result);
    }

    protected Document loadDocument(InputStream documentInputStream) throws ParserConfigurationException, SAXException, IOException {
        InputSource inputSource = new InputSource(documentInputStream);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(inputSource);
        return document;
    }

    protected Document loadDocumentNoClose(InputStream documentInputStream) throws ParserConfigurationException, SAXException, IOException {
        NoCloseInputStream noCloseInputStream = new NoCloseInputStream(documentInputStream);
        InputSource inputSource = new InputSource((InputStream)((Object)noCloseInputStream));
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(inputSource);
        return document;
    }
}

