/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.service.cdi;

import be.fedict.eid.applet.service.Address;
import be.fedict.eid.applet.service.Identity;
import be.fedict.eid.applet.service.cdi.BelgianCertificate;
import java.security.cert.X509Certificate;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.servlet.http.HttpSession;

public class BelgianIdentityCardProducer {
    @Inject
    private HttpSession httpSession;

    @Produces
    public Identity createIdentity() {
        Identity identity = (Identity)this.httpSession.getAttribute("eid.identity");
        return identity;
    }

    @Produces
    public Address createAddress() {
        Address address = (Address)this.httpSession.getAttribute("eid.address");
        return address;
    }

    @Produces
    @BelgianCertificate(value=BelgianCertificate.CERTIFICATE_TYPE.AUTH)
    public X509Certificate createAuthCert() {
        X509Certificate cert = (X509Certificate)this.httpSession.getAttribute("eid.certs.authn");
        return cert;
    }

    @Produces
    @BelgianCertificate(value=BelgianCertificate.CERTIFICATE_TYPE.SIGN)
    public X509Certificate createSignCert() {
        X509Certificate cert = (X509Certificate)this.httpSession.getAttribute("eid.certs.sign");
        return cert;
    }

    @Produces
    @BelgianCertificate(value=BelgianCertificate.CERTIFICATE_TYPE.CITIZEN_CA)
    public X509Certificate createCitizenCACert() {
        X509Certificate cert = (X509Certificate)this.httpSession.getAttribute("eid.certs.ca");
        return cert;
    }

    @Produces
    @BelgianCertificate(value=BelgianCertificate.CERTIFICATE_TYPE.ROOT_CA)
    public X509Certificate createRootCACert() {
        X509Certificate cert = (X509Certificate)this.httpSession.getAttribute("eid.certs.root");
        return cert;
    }
}

