/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.servlet.logging;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashSet;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessProducerMethod;
import org.jboss.seam.servlet.logging.TypedMessageBundle;
import org.jboss.seam.servlet.logging.TypedMessageBundleAndLoggerProducers;
import org.jboss.seam.servlet.logging.TypedMessageLogger;
import org.jboss.seam.solder.bean.NarrowingBeanBuilder;
import org.jboss.seam.solder.literal.MessageBundleLiteral;
import org.jboss.seam.solder.logging.MessageLogger;
import org.jboss.seam.solder.messages.MessageBundle;

public class TypedMessageBundleAndLoggerExtension
implements Extension {
    private final Collection<AnnotatedType<?>> messageLoggerTypes = new HashSet();
    private final Collection<AnnotatedType<?>> messageBundleTypes = new HashSet();
    private Bean<Object> loggerProducerBean;
    private Bean<Object> bundleProducerBean;
    private boolean processTypesInModule = false;
    private static final String MODULE_PACKAGE_PREFIX = "org.jboss.seam.servlet.";

    public TypedMessageBundleAndLoggerExtension() {
        Package cdi = BeanManager.class.getPackage();
        this.processTypesInModule = System.getProperty("glassfish.version") != null && cdi.getImplementationTitle().contains("Weld") && cdi.getImplementationVersion().equals("20110114-1644");
    }

    void detectInterfaces(@Observes ProcessAnnotatedType<?> event, BeanManager beanManager) {
        AnnotatedType type;
        if (this.processTypesInModule && (type = event.getAnnotatedType()).getJavaClass().getPackage().getName().startsWith(MODULE_PACKAGE_PREFIX)) {
            if (type.isAnnotationPresent(MessageLogger.class)) {
                this.messageLoggerTypes.add(type);
            }
            if (type.isAnnotationPresent(MessageBundle.class)) {
                this.messageBundleTypes.add(type);
            }
        }
    }

    void detectProducers(@Observes ProcessProducerMethod<Object, TypedMessageBundleAndLoggerProducers> event) {
        this.captureProducers(event.getAnnotatedProducerMethod(), event.getBean());
    }

    @Deprecated
    void detectProducersInverted(@Observes ProcessProducerMethod<TypedMessageBundleAndLoggerProducers, Object> event) {
        this.captureProducers(event.getAnnotatedProducerMethod(), event.getBean());
    }

    void captureProducers(AnnotatedMethod<?> method, Bean<?> bean) {
        if (this.processTypesInModule) {
            if (method.isAnnotationPresent(TypedMessageLogger.class)) {
                this.loggerProducerBean = bean;
            }
            if (method.isAnnotationPresent(TypedMessageBundle.class)) {
                this.bundleProducerBean = bean;
            }
        }
    }

    void installBeans(@Observes AfterBeanDiscovery event, BeanManager beanManager) {
        if (this.processTypesInModule) {
            for (AnnotatedType<?> type : this.messageLoggerTypes) {
                event.addBean(TypedMessageBundleAndLoggerExtension.createMessageLoggerBean(this.loggerProducerBean, type, beanManager));
            }
            for (AnnotatedType<?> type : this.messageBundleTypes) {
                event.addBean(TypedMessageBundleAndLoggerExtension.createMessageBundleBean(this.bundleProducerBean, type, beanManager));
            }
        }
    }

    private static <T> Bean<T> createMessageLoggerBean(Bean<Object> delegate, AnnotatedType<T> type, BeanManager beanManager) {
        return new NarrowingBeanBuilder(delegate, beanManager).readFromType(type).types(new Type[]{type.getBaseType(), Object.class}).create();
    }

    private static <T> Bean<T> createMessageBundleBean(Bean<Object> delegate, AnnotatedType<T> type, BeanManager beanManager) {
        return new NarrowingBeanBuilder(delegate, beanManager).readFromType(type).types(new Type[]{type.getBaseType(), Object.class}).addQualifier((Annotation)MessageBundleLiteral.INSTANCE).create();
    }

    void cleanup(@Observes AfterDeploymentValidation event) {
        this.messageLoggerTypes.clear();
        this.messageBundleTypes.clear();
    }
}

