/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.service.impl.handler;

import be.fedict.eid.applet.service.impl.AuthenticationChallenge;
import be.fedict.eid.applet.service.impl.RequestContext;
import be.fedict.eid.applet.service.impl.ServiceLocator;
import be.fedict.eid.applet.service.impl.handler.HandlesMessage;
import be.fedict.eid.applet.service.impl.handler.HelloMessageHandler;
import be.fedict.eid.applet.service.impl.handler.InitParam;
import be.fedict.eid.applet.service.impl.handler.MessageHandler;
import be.fedict.eid.applet.service.impl.handler.SignatureDataMessageHandler;
import be.fedict.eid.applet.service.spi.AuthenticationService;
import be.fedict.eid.applet.service.spi.DigestInfo;
import be.fedict.eid.applet.service.spi.IdentityIntegrityService;
import be.fedict.eid.applet.service.spi.IdentityRequest;
import be.fedict.eid.applet.service.spi.IdentityService;
import be.fedict.eid.applet.service.spi.InsecureClientEnvironmentException;
import be.fedict.eid.applet.service.spi.PrivacyService;
import be.fedict.eid.applet.service.spi.SecureClientEnvironmentService;
import be.fedict.eid.applet.service.spi.SignatureService;
import be.fedict.eid.applet.shared.AdministrationMessage;
import be.fedict.eid.applet.shared.AuthenticationRequestMessage;
import be.fedict.eid.applet.shared.ClientEnvironmentMessage;
import be.fedict.eid.applet.shared.FilesDigestRequestMessage;
import be.fedict.eid.applet.shared.IdentificationRequestMessage;
import be.fedict.eid.applet.shared.InsecureClientMessage;
import be.fedict.eid.applet.shared.SignCertificatesRequestMessage;
import be.fedict.eid.applet.shared.SignRequestMessage;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@HandlesMessage(value=ClientEnvironmentMessage.class)
public class ClientEnvironmentMessageHandler
implements MessageHandler<ClientEnvironmentMessage> {
    private static final Log LOG = LogFactory.getLog(ClientEnvironmentMessageHandler.class);
    @InitParam(value="SecureClientEnvironmentService")
    private ServiceLocator<SecureClientEnvironmentService> secureClientEnvServiceLocator;
    @InitParam(value="IncludePhoto")
    private boolean includePhoto;
    @InitParam(value="IncludeAddress")
    private boolean includeAddress;
    @InitParam(value="IncludeIdentity")
    private boolean includeIdentity;
    @InitParam(value="IdentityIntegrityService")
    private ServiceLocator<IdentityIntegrityService> identityIntegrityServiceLocator;
    @InitParam(value="AuthenticationService")
    private ServiceLocator<AuthenticationService> authenticationServiceLocator;
    @InitParam(value="PrivacyService")
    private ServiceLocator<PrivacyService> privacyServiceLocator;
    private SecureRandom secureRandom;
    @InitParam(value="RemoveCard")
    private boolean removeCard;
    @InitParam(value="ChangePin")
    private boolean changePin;
    @InitParam(value="UnblockPin")
    private boolean unblockPin;
    private boolean includeHostname;
    private boolean includeInetAddress;
    @InitParam(value="Logoff")
    private boolean logoff;
    @InitParam(value="PreLogoff")
    private boolean preLogoff;
    @InitParam(value="IncludeCertificates")
    private boolean includeCertificates;
    @InitParam(value="SessionIdChannelBinding")
    private boolean sessionIdChannelBinding;
    private boolean serverCertificateChannelBinding;
    @InitParam(value="RequireSecureReader")
    private boolean requireSecureReader;
    @InitParam(value="SignatureService")
    private ServiceLocator<SignatureService> signatureServiceLocator;
    @InitParam(value="NoPKCS11")
    private boolean noPkcs11;
    @InitParam(value="IdentityService")
    private ServiceLocator<IdentityService> identityServiceLocator;

    @Override
    public Object handleMessage(ClientEnvironmentMessage message, Map<String, String> httpHeaders, HttpServletRequest request, HttpSession session) throws ServletException {
        boolean includeCertificates;
        boolean includePhoto;
        boolean includeAddress;
        String identityDataUsage;
        SecureClientEnvironmentService secureClientEnvService = this.secureClientEnvServiceLocator.locateService();
        if (null == secureClientEnvService) {
            throw new ServletException("no secure client env service configured");
        }
        String remoteAddress = request.getRemoteAddr();
        Integer sslKeySize = (Integer)request.getAttribute("javax.servlet.request.key_size");
        String userAgent = httpHeaders.get("user-agent");
        String sslCipherSuite = (String)request.getAttribute("javax.servlet.request.cipher_suite");
        try {
            secureClientEnvService.checkSecureClientEnvironment(message.javaVersion, message.javaVendor, message.osName, message.osArch, message.osVersion, userAgent, message.navigatorAppName, message.navigatorAppVersion, message.navigatorUserAgent, remoteAddress, sslKeySize, sslCipherSuite, message.readerList);
        }
        catch (InsecureClientEnvironmentException e) {
            return new InsecureClientMessage(e.isWarnOnly());
        }
        if (this.changePin || this.unblockPin) {
            AdministrationMessage administrationMessage = new AdministrationMessage(this.changePin, this.unblockPin, this.logoff, this.removeCard, this.requireSecureReader);
            return administrationMessage;
        }
        SignatureService signatureService = this.signatureServiceLocator.locateService();
        if (null != signatureService) {
            DigestInfo digestInfo;
            String filesDigestAlgo = signatureService.getFilesDigestAlgorithm();
            if (null != filesDigestAlgo) {
                LOG.debug((Object)("files digest algo: " + filesDigestAlgo));
                FilesDigestRequestMessage filesDigestRequestMessage = new FilesDigestRequestMessage();
                filesDigestRequestMessage.digestAlgo = filesDigestAlgo;
                return filesDigestRequestMessage;
            }
            if (this.includeCertificates) {
                boolean includePhoto2;
                boolean includeAddress2;
                boolean includeIdentity;
                LOG.debug((Object)"include signing certificate chain during pre-sign");
                IdentityIntegrityService identityIntegrityService = this.identityIntegrityServiceLocator.locateService();
                boolean includeIntegrityData = null != identityIntegrityService;
                IdentityService identityService = this.identityServiceLocator.locateService();
                if (null != identityService) {
                    IdentityRequest identityRequest = identityService.getIdentityRequest();
                    includeIdentity = identityRequest.includeIdentity();
                    includeAddress2 = identityRequest.includeAddress();
                    includePhoto2 = identityRequest.includePhoto();
                } else {
                    includeIdentity = this.includeIdentity;
                    includeAddress2 = this.includeAddress;
                    includePhoto2 = this.includePhoto;
                }
                RequestContext requestContext = new RequestContext(session);
                requestContext.setIncludeIdentity(includeIdentity);
                requestContext.setIncludeAddress(includeAddress2);
                requestContext.setIncludePhoto(includePhoto2);
                SignCertificatesRequestMessage signCertificatesRequestMessage = new SignCertificatesRequestMessage(includeIdentity, includeAddress2, includePhoto2, includeIntegrityData);
                return signCertificatesRequestMessage;
            }
            try {
                digestInfo = signatureService.preSign(null, null);
            }
            catch (NoSuchAlgorithmException e) {
                throw new ServletException("no such algo: " + e.getMessage(), (Throwable)e);
            }
            SignatureDataMessageHandler.setDigestValue(digestInfo.digestValue, session);
            SignRequestMessage signRequestMessage = new SignRequestMessage(digestInfo.digestValue, digestInfo.digestAlgo, digestInfo.description, this.logoff, this.removeCard, this.requireSecureReader, this.noPkcs11);
            return signRequestMessage;
        }
        AuthenticationService authenticationService = this.authenticationServiceLocator.locateService();
        if (null != authenticationService) {
            boolean includeCertificates2;
            boolean includePhoto3;
            boolean includeAddress3;
            boolean includeIdentity;
            byte[] challenge = AuthenticationChallenge.generateChallenge(session);
            IdentityIntegrityService identityIntegrityService = this.identityIntegrityServiceLocator.locateService();
            boolean includeIntegrityData = null != identityIntegrityService;
            IdentityService identityService = this.identityServiceLocator.locateService();
            if (null != identityService) {
                IdentityRequest identityRequest = identityService.getIdentityRequest();
                includeIdentity = identityRequest.includeIdentity();
                includeAddress3 = identityRequest.includeAddress();
                includePhoto3 = identityRequest.includePhoto();
                includeCertificates2 = identityRequest.includeCertificates();
            } else {
                includeIdentity = this.includeIdentity;
                includeAddress3 = this.includeAddress;
                includePhoto3 = this.includePhoto;
                includeCertificates2 = this.includeCertificates;
            }
            RequestContext requestContext = new RequestContext(session);
            requestContext.setIncludeIdentity(includeIdentity);
            requestContext.setIncludeAddress(includeAddress3);
            requestContext.setIncludePhoto(includePhoto3);
            requestContext.setIncludeCertificates(includeCertificates2);
            AuthenticationRequestMessage authenticationRequestMessage = new AuthenticationRequestMessage(challenge, this.includeHostname, this.includeInetAddress, this.logoff, this.preLogoff, this.removeCard, this.sessionIdChannelBinding, this.serverCertificateChannelBinding, includeIdentity, includeCertificates2, includeAddress3, includePhoto3, includeIntegrityData, this.requireSecureReader, this.noPkcs11);
            return authenticationRequestMessage;
        }
        IdentityIntegrityService identityIntegrityService = this.identityIntegrityServiceLocator.locateService();
        boolean includeIntegrityData = null != identityIntegrityService;
        PrivacyService privacyService = this.privacyServiceLocator.locateService();
        if (null != privacyService) {
            String clientLanguage = HelloMessageHandler.getClientLanguage(session);
            identityDataUsage = privacyService.getIdentityDataUsage(clientLanguage);
        } else {
            identityDataUsage = null;
        }
        IdentityService identityService = this.identityServiceLocator.locateService();
        if (null != identityService) {
            IdentityRequest identityRequest = identityService.getIdentityRequest();
            includeAddress = identityRequest.includeAddress();
            includePhoto = identityRequest.includePhoto();
            includeCertificates = identityRequest.includeCertificates();
        } else {
            includeAddress = this.includeAddress;
            includePhoto = this.includePhoto;
            includeCertificates = this.includeCertificates;
        }
        RequestContext requestContext = new RequestContext(session);
        requestContext.setIncludeAddress(includeAddress);
        requestContext.setIncludePhoto(includePhoto);
        requestContext.setIncludeCertificates(includeCertificates);
        IdentificationRequestMessage responseMessage = new IdentificationRequestMessage(includeAddress, includePhoto, includeIntegrityData, includeCertificates, this.removeCard, identityDataUsage);
        return responseMessage;
    }

    @Override
    public void init(ServletConfig config) throws ServletException {
        String channelBindingService;
        String channelBindingServerCertificate;
        String inetAddress;
        this.secureRandom = new SecureRandom();
        this.secureRandom.setSeed(System.currentTimeMillis());
        String hostname = config.getInitParameter("Hostname");
        if (null != hostname) {
            this.includeHostname = true;
        }
        if (null != (inetAddress = config.getInitParameter("InetAddress"))) {
            this.includeInetAddress = true;
        }
        if (null != (channelBindingServerCertificate = config.getInitParameter("ChannelBindingServerCertificate"))) {
            this.serverCertificateChannelBinding = true;
        }
        if (null != (channelBindingService = config.getInitParameter("ChannelBindingService"))) {
            this.serverCertificateChannelBinding = true;
        }
    }
}

