/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.service.signer.facets;

import java.security.cert.CRLException;
import java.security.cert.X509CRL;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RevocationData {
    private final List<byte[]> crls = new LinkedList<byte[]>();
    private final List<byte[]> ocsps = new LinkedList<byte[]>();

    public void addCRL(byte[] encodedCrl) {
        this.crls.add(encodedCrl);
    }

    public void addCRL(X509CRL crl) {
        byte[] encodedCrl;
        try {
            encodedCrl = crl.getEncoded();
        }
        catch (CRLException e) {
            throw new IllegalArgumentException("CRL coding error: " + e.getMessage(), e);
        }
        this.addCRL(encodedCrl);
    }

    public void addOCSP(byte[] encodedOcsp) {
        this.ocsps.add(encodedOcsp);
    }

    public List<byte[]> getCRLs() {
        return this.crls;
    }

    public List<byte[]> getOCSPs() {
        return this.ocsps;
    }

    public boolean hasOCSPs() {
        return false == this.ocsps.isEmpty();
    }

    public boolean hasCRLs() {
        return false == this.crls.isEmpty();
    }

    public boolean hasRevocationDataEntries() {
        return this.hasOCSPs() || this.hasCRLs();
    }
}

