/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.service.signer.facets;

import be.fedict.eid.applet.service.signer.SignatureFacet;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.LinkedList;
import java.util.List;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jcp.xml.dsig.internal.dom.DOMKeyInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyInfoSignatureFacet
implements SignatureFacet {
    private static final Log LOG = LogFactory.getLog(KeyInfoSignatureFacet.class);
    private final boolean includeEntireCertificateChain;
    private final boolean includeIssuerSerial;
    private final boolean includeKeyValue;

    public KeyInfoSignatureFacet(boolean includeEntireCertificateChain, boolean includeIssuerSerial, boolean includeKeyValue) {
        this.includeEntireCertificateChain = includeEntireCertificateChain;
        this.includeIssuerSerial = includeIssuerSerial;
        this.includeKeyValue = includeKeyValue;
    }

    @Override
    public void postSign(Element signatureElement, List<X509Certificate> signingCertificateChain) {
        LOG.debug((Object)"postSign");
        String signatureNamespacePrefix = signatureElement.getPrefix();
        NodeList objectNodeList = signatureElement.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Object");
        Node nextSibling = 0 == objectNodeList.getLength() ? null : objectNodeList.item(0);
        KeyInfoFactory keyInfoFactory = KeyInfoFactory.getInstance();
        LinkedList<Object> x509DataObjects = new LinkedList<Object>();
        X509Certificate signingCertificate = signingCertificateChain.get(0);
        LinkedList<XMLStructure> keyInfoContent = new LinkedList<XMLStructure>();
        if (this.includeKeyValue) {
            KeyValue keyValue;
            try {
                keyValue = keyInfoFactory.newKeyValue(signingCertificate.getPublicKey());
            }
            catch (KeyException e) {
                throw new RuntimeException("key exception: " + e.getMessage(), e);
            }
            keyInfoContent.add(keyValue);
        }
        if (this.includeIssuerSerial) {
            x509DataObjects.add(keyInfoFactory.newX509IssuerSerial(signingCertificate.getIssuerX500Principal().toString(), signingCertificate.getSerialNumber()));
        }
        if (this.includeEntireCertificateChain) {
            for (X509Certificate certificate : signingCertificateChain) {
                x509DataObjects.add(certificate);
            }
        } else {
            x509DataObjects.add(signingCertificate);
        }
        if (!x509DataObjects.isEmpty()) {
            X509Data x509Data = keyInfoFactory.newX509Data(x509DataObjects);
            keyInfoContent.add(x509Data);
        }
        KeyInfo keyInfo = keyInfoFactory.newKeyInfo(keyInfoContent);
        DOMKeyInfo domKeyInfo = (DOMKeyInfo)keyInfo;
        Key key = new Key(){
            private static final long serialVersionUID = 1L;

            public String getAlgorithm() {
                return null;
            }

            public byte[] getEncoded() {
                return null;
            }

            public String getFormat() {
                return null;
            }
        };
        DOMSignContext xmlSignContext = new DOMSignContext(key, (Node)signatureElement);
        DOMCryptoContext domCryptoContext = xmlSignContext;
        try {
            domKeyInfo.marshal(signatureElement, nextSibling, signatureNamespacePrefix, domCryptoContext);
        }
        catch (MarshalException e) {
            throw new RuntimeException("marshall error: " + e.getMessage(), e);
        }
    }

    @Override
    public void preSign(XMLSignatureFactory signatureFactory, Document document, String signatureId, List<X509Certificate> signingCertificateChain, List<Reference> references, List<XMLObject> objects) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
    }
}

