/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.service.signer.asic;

import be.fedict.eid.applet.service.signer.AbstractXmlSignatureService;
import be.fedict.eid.applet.service.signer.CloseActionOutputStream;
import be.fedict.eid.applet.service.signer.DigestAlgo;
import be.fedict.eid.applet.service.signer.TemporaryDataStorage;
import be.fedict.eid.applet.service.signer.asic.ASiCSignatureFacet;
import be.fedict.eid.applet.service.signer.asic.ASiCSignatureOutputStream;
import be.fedict.eid.applet.service.signer.asic.ASiCURIDereferencer;
import be.fedict.eid.applet.service.signer.asic.ASiCUtil;
import be.fedict.eid.applet.service.signer.facets.IdentitySignatureFacet;
import be.fedict.eid.applet.service.signer.facets.KeyInfoSignatureFacet;
import be.fedict.eid.applet.service.signer.facets.RevocationDataService;
import be.fedict.eid.applet.service.signer.facets.XAdESSignatureFacet;
import be.fedict.eid.applet.service.signer.facets.XAdESXLSignatureFacet;
import be.fedict.eid.applet.service.signer.odf.ODFUtil;
import be.fedict.eid.applet.service.signer.time.TimeStampService;
import be.fedict.eid.applet.service.spi.AddressDTO;
import be.fedict.eid.applet.service.spi.DigestInfo;
import be.fedict.eid.applet.service.spi.IdentityDTO;
import be.fedict.eid.applet.service.spi.SignatureServiceEx;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.crypto.URIDereferencer;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.IOUtils;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractASiCSignatureService
extends AbstractXmlSignatureService
implements SignatureServiceEx {
    private final TemporaryDataStorage temporaryDataStorage;
    private final File tmpFile;
    private final OutputStream documentOutputStream;

    public AbstractASiCSignatureService(InputStream documentInputStream, DigestAlgo digestAlgo, RevocationDataService revocationDataService, TimeStampService timeStampService, String claimedRole, IdentityDTO identity, byte[] photo, TemporaryDataStorage temporaryDataStorage, OutputStream documentOutputStream) throws IOException {
        super(digestAlgo);
        this.temporaryDataStorage = temporaryDataStorage;
        this.documentOutputStream = documentOutputStream;
        this.tmpFile = File.createTempFile("eid-dss-", ".asice");
        FileOutputStream fileOutputStream = new FileOutputStream(this.tmpFile);
        IOUtils.copy((InputStream)documentInputStream, (OutputStream)fileOutputStream);
        this.addSignatureFacet(new ASiCSignatureFacet(this.tmpFile, digestAlgo));
        XAdESSignatureFacet xadesSignatureFacet = new XAdESSignatureFacet(this.getSignatureDigestAlgorithm());
        xadesSignatureFacet.setRole(claimedRole);
        xadesSignatureFacet.setXadesNamespacePrefix("xades");
        this.addSignatureFacet(xadesSignatureFacet);
        this.addSignatureFacet(new XAdESXLSignatureFacet(timeStampService, revocationDataService, this.getSignatureDigestAlgorithm()));
        this.addSignatureFacet(new KeyInfoSignatureFacet(true, false, false));
        if (null != identity) {
            IdentitySignatureFacet identitySignatureFacet = new IdentitySignatureFacet(identity, photo, this.getSignatureDigestAlgorithm());
            this.addSignatureFacet(identitySignatureFacet);
        }
    }

    @Override
    protected String getSignatureDescription() {
        return "Associated Signature Container";
    }

    public String getFilesDigestAlgorithm() {
        return null;
    }

    @Override
    protected TemporaryDataStorage getTemporaryDataStorage() {
        return this.temporaryDataStorage;
    }

    @Override
    protected URIDereferencer getURIDereferencer() {
        return new ASiCURIDereferencer(this.tmpFile);
    }

    @Override
    protected OutputStream getSignedDocumentOutputStream() {
        return new ASiCSignatureOutputStream(this.tmpFile, (OutputStream)((Object)new CloseActionOutputStream(this.documentOutputStream, new CloseAction())));
    }

    public DigestInfo preSign(List<DigestInfo> digestInfos, List<X509Certificate> signingCertificateChain, IdentityDTO identity, AddressDTO address, byte[] photo) throws NoSuchAlgorithmException {
        return super.preSign(digestInfos, signingCertificateChain);
    }

    @Override
    protected Document getEnvelopingDocument() throws ParserConfigurationException, IOException, SAXException {
        ZipEntry zipEntry;
        FileInputStream fileInputStream = new FileInputStream(this.tmpFile);
        ZipInputStream zipInputStream = new ZipInputStream(fileInputStream);
        while (null != (zipEntry = zipInputStream.getNextEntry())) {
            if (!ASiCUtil.isSignatureZipEntry(zipEntry)) continue;
            Document documentSignaturesDocument = ODFUtil.loadDocument(zipInputStream);
            return documentSignaturesDocument;
        }
        Document document = ASiCUtil.createNewSignatureDocument();
        return document;
    }

    private class CloseAction
    implements Runnable {
        private CloseAction() {
        }

        public void run() {
            AbstractASiCSignatureService.this.tmpFile.delete();
        }
    }
}

