/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.service.signer;

import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.util.Arrays;

public class SHA1WithRSAProxySignature
extends Signature {
    private static final Log LOG = LogFactory.getLog(SHA1WithRSAProxySignature.class);
    private static final ThreadLocal<byte[]> digestValues = new ThreadLocal();
    private static final ThreadLocal<byte[]> signatureValues = new ThreadLocal();
    private final MessageDigest messageDigest;

    public SHA1WithRSAProxySignature() throws NoSuchAlgorithmException {
        super("SHA1withRSA");
        LOG.debug((Object)"constructor");
        this.messageDigest = MessageDigest.getInstance("SHA1");
    }

    public static void reset() {
        digestValues.set(null);
        signatureValues.set(null);
    }

    protected Object engineGetParameter(String param) throws InvalidParameterException {
        throw new UnsupportedOperationException();
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        LOG.debug((Object)("engineInitSign: " + privateKey.getAlgorithm()));
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        throw new UnsupportedOperationException();
    }

    protected void engineSetParameter(String param, Object value) throws InvalidParameterException {
        throw new UnsupportedOperationException();
    }

    protected byte[] engineSign() throws SignatureException {
        LOG.debug((Object)"engineSign");
        byte[] signatureValue = signatureValues.get();
        if (null != signatureValue) {
            LOG.debug((Object)("injecting signature value: " + Hex.encodeHexString((byte[])signatureValue)));
            SHA1WithRSAProxySignature.reset();
            return signatureValue;
        }
        LOG.debug((Object)"returning a dummy signature value");
        return "dummy".getBytes();
    }

    protected void engineUpdate(byte b) throws SignatureException {
        throw new UnsupportedOperationException();
    }

    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        LOG.debug((Object)("engineUpdate(b,off,len): off=" + off + "; len=" + len));
        this.messageDigest.update(b, off, len);
        byte[] digestValue = this.messageDigest.digest();
        byte[] expectedDigestValue = digestValues.get();
        if (null == expectedDigestValue) {
            digestValues.set(digestValue);
        } else if (!Arrays.areEqual((byte[])expectedDigestValue, (byte[])digestValue)) {
            throw new IllegalStateException("digest value has changed");
        }
        LOG.debug((Object)("digest value: " + Hex.encodeHexString((byte[])digestValue)));
    }

    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        throw new UnsupportedOperationException();
    }

    public static byte[] getDigestValue() {
        return digestValues.get();
    }

    public static void setSignatureValue(byte[] signatureValue) {
        signatureValues.set(signatureValue);
    }

    public static void setDigestSignatureValue(byte[] digestValue, byte[] signatureValue) {
        digestValues.set(digestValue);
        signatureValues.set(signatureValue);
    }
}

