/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.shared;

import be.fedict.eid.applet.shared.AbstractProtocolMessage;
import be.fedict.eid.applet.shared.SignRequestMessage;
import be.fedict.eid.applet.shared.annotation.Description;
import be.fedict.eid.applet.shared.annotation.HttpBody;
import be.fedict.eid.applet.shared.annotation.HttpHeader;
import be.fedict.eid.applet.shared.annotation.MessageDiscriminator;
import be.fedict.eid.applet.shared.annotation.NotNull;
import be.fedict.eid.applet.shared.annotation.PostConstruct;
import be.fedict.eid.applet.shared.annotation.ProtocolStateAllowed;
import be.fedict.eid.applet.shared.annotation.ResponsesAllowed;
import be.fedict.eid.applet.shared.protocol.ProtocolState;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.LinkedList;
import java.util.List;

@ResponsesAllowed(value={SignRequestMessage.class})
@ProtocolStateAllowed(value=ProtocolState.SIGN_CERTS)
public class SignCertificatesDataMessage
extends AbstractProtocolMessage {
    @HttpHeader(value="X-AppletProtocol-Type")
    @MessageDiscriminator
    public static final String TYPE = SignCertificatesDataMessage.class.getSimpleName();
    @HttpHeader(value="X-AppletProtocol-SignCertFileSize")
    @NotNull
    public Integer signCertFileSize;
    @HttpHeader(value="X-AppletProtocol-CaCertFileSize")
    @NotNull
    public Integer caCertFileSize;
    @HttpHeader(value="X-AppletProtocol-RootCaCertFileSize")
    @NotNull
    public Integer rootCertFileSize;
    @HttpHeader(value="X-AppletProtocol-IdentityFileSize")
    public Integer identityFileSize;
    @HttpHeader(value="X-AppletProtocol-AddressFileSize")
    public Integer addressFileSize;
    @HttpHeader(value="X-AppletProtocol-PhotoFileSize")
    public Integer photoFileSize;
    @HttpHeader(value="X-AppletProtocol-IdentitySignatureFileSize")
    public Integer identitySignatureFileSize;
    @HttpHeader(value="X-AppletProtocol-AddressSignatureFileSize")
    public Integer addressSignatureFileSize;
    @HttpHeader(value="X-AppletProtocol-NationalRegistryCertFileSize")
    public Integer rrnCertFileSize;
    @HttpBody
    @NotNull
    @Description(value="The non-repudiation certificate chain, optional identity files.")
    public byte[] body;
    public byte[] identityData;
    public byte[] addressData;
    public byte[] photoData;
    public byte[] identitySignatureData;
    public byte[] addressSignatureData;
    public X509Certificate rrnCertificate;
    public X509Certificate rootCertificate;
    public List<X509Certificate> certificateChain;

    public SignCertificatesDataMessage() {
    }

    public SignCertificatesDataMessage(byte[] signCertFile, byte[] citizenCaCertFile, byte[] rootCaCertFile, byte[] identityFile, byte[] addressFile, byte[] photoFile, byte[] identitySignFile, byte[] addressSignFile, byte[] nrnCertFile) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(signCertFile);
        this.signCertFileSize = signCertFile.length;
        baos.write(citizenCaCertFile);
        this.caCertFileSize = citizenCaCertFile.length;
        baos.write(rootCaCertFile);
        this.rootCertFileSize = rootCaCertFile.length;
        if (null != identityFile) {
            baos.write(identityFile);
            this.identityFileSize = identityFile.length;
        }
        if (null != addressFile) {
            baos.write(addressFile);
            this.addressFileSize = addressFile.length;
        }
        if (null != photoFile) {
            baos.write(photoFile);
            this.photoFileSize = photoFile.length;
        }
        if (null != identitySignFile) {
            baos.write(identitySignFile);
            this.identitySignatureFileSize = identitySignFile.length;
        }
        if (null != addressSignFile) {
            baos.write(addressSignFile);
            this.addressSignatureFileSize = addressSignFile.length;
        }
        if (null != nrnCertFile) {
            baos.write(nrnCertFile);
            this.rrnCertFileSize = nrnCertFile.length;
        }
        this.body = baos.toByteArray();
    }

    public SignCertificatesDataMessage(X509Certificate[] signCertChain) throws IOException, CertificateEncodingException {
        this(signCertChain[0].getEncoded(), signCertChain[1].getEncoded(), signCertChain[2].getEncoded(), null, null, null, null, null, null);
    }

    private byte[] copy(byte[] source, int idx, int count) {
        byte[] result = new byte[count];
        System.arraycopy(source, idx, result, 0, count);
        return result;
    }

    @PostConstruct
    public void postConstruct() {
        int idx = 0;
        byte[] signCertFile = this.copy(this.body, idx, this.signCertFileSize);
        X509Certificate signCert = this.getCertificate(signCertFile);
        byte[] citizenCaCertFile = this.copy(this.body, idx += this.signCertFileSize.intValue(), this.caCertFileSize);
        X509Certificate citizenCaCert = this.getCertificate(citizenCaCertFile);
        byte[] rootCaCertFile = this.copy(this.body, idx += this.caCertFileSize.intValue(), this.rootCertFileSize);
        idx += this.rootCertFileSize.intValue();
        this.rootCertificate = this.getCertificate(rootCaCertFile);
        this.certificateChain = new LinkedList<X509Certificate>();
        this.certificateChain.add(signCert);
        this.certificateChain.add(citizenCaCert);
        this.certificateChain.add(this.rootCertificate);
        if (null != this.identityFileSize) {
            this.identityData = this.copy(this.body, idx, this.identityFileSize);
            idx += this.identityFileSize.intValue();
        }
        if (null != this.addressFileSize) {
            this.addressData = this.copy(this.body, idx, this.addressFileSize);
            idx += this.addressFileSize.intValue();
        }
        if (null != this.photoFileSize) {
            this.photoData = this.copy(this.body, idx, this.photoFileSize);
            idx += this.photoFileSize.intValue();
        }
        if (null != this.identitySignatureFileSize) {
            this.identitySignatureData = this.copy(this.body, idx, this.identitySignatureFileSize);
            idx += this.identitySignatureFileSize.intValue();
        }
        if (null != this.addressSignatureFileSize) {
            this.addressSignatureData = this.copy(this.body, idx, this.addressSignatureFileSize);
            idx += this.addressSignatureFileSize.intValue();
        }
        if (null != this.rrnCertFileSize) {
            byte[] nrnCertData = this.copy(this.body, idx, this.rrnCertFileSize);
            idx += this.rrnCertFileSize.intValue();
            this.rrnCertificate = this.getCertificate(nrnCertData);
        }
    }

    private X509Certificate getCertificate(byte[] certData) {
        CertificateFactory certificateFactory;
        try {
            certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new RuntimeException("cert factory error: " + e.getMessage(), e);
        }
        try {
            X509Certificate certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(certData));
            return certificate;
        }
        catch (CertificateException e) {
            return null;
        }
    }
}

