/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.sc;

import be.fedict.eid.applet.DiagnosticTests;
import be.fedict.eid.applet.Messages;
import be.fedict.eid.applet.View;
import be.fedict.eid.applet.sc.Constants;
import be.fedict.eid.applet.sc.DiagnosticCallbackHandler;
import be.fedict.eid.applet.sc.PKCS11NotFoundException;
import be.fedict.eid.applet.sc.Pkcs11LoadStoreParameter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import sun.security.pkcs11.SunPKCS11;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.CK_C_INITIALIZE_ARGS;
import sun.security.pkcs11.wrapper.CK_INFO;
import sun.security.pkcs11.wrapper.CK_MECHANISM;
import sun.security.pkcs11.wrapper.CK_SLOT_INFO;
import sun.security.pkcs11.wrapper.CK_TOKEN_INFO;
import sun.security.pkcs11.wrapper.PKCS11;
import sun.security.pkcs11.wrapper.PKCS11Exception;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pkcs11Eid {
    private final View view;
    private PKCS11 pkcs11;
    private long slotIdx;
    private String slotDescription;
    private Messages messages;
    private SunPKCS11 pkcs11Provider;
    private List<X509Certificate> authnCertificateChain;
    private List<X509Certificate> signCertificateChain;

    public Pkcs11Eid(View view, Messages messages) {
        this.view = view;
        this.messages = messages;
    }

    public PKCS11 getPkcs11() {
        return this.pkcs11;
    }

    private String getPkcs11Path() throws PKCS11NotFoundException {
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Linux")) {
            File pkcs11File = new File("/usr/local/lib/libbeidpkcs11.so");
            if (pkcs11File.exists()) {
                return pkcs11File.getAbsolutePath();
            }
            pkcs11File = new File("/usr/lib/libbeidpkcs11.so");
            if (pkcs11File.exists()) {
                return pkcs11File.getAbsolutePath();
            }
            pkcs11File = new File("/usr/local/lib/pkcs11/Belgium-EID-pkcs11.so");
            if (pkcs11File.exists()) {
                return pkcs11File.getAbsolutePath();
            }
            pkcs11File = new File("/usr/lib/opensc-pkcs11.so");
            if (pkcs11File.exists()) {
                return pkcs11File.getAbsolutePath();
            }
        } else if (osName.startsWith("Mac")) {
            File pkcs11File = new File("/usr/local/lib/libbeidpkcs11.3.5.1.dylib");
            if (pkcs11File.exists()) {
                return pkcs11File.getAbsolutePath();
            }
            pkcs11File = new File("/usr/local/lib/libbeidpkcs11.3.5.0.dylib");
            if (pkcs11File.exists()) {
                return pkcs11File.getAbsolutePath();
            }
            pkcs11File = new File("/usr/local/lib/beid-pkcs11.bundle/Contents/MacOS/libbeidpkcs11.2.1.0.dylib");
            if (pkcs11File.exists()) {
                return pkcs11File.getAbsolutePath();
            }
            pkcs11File = new File("/usr/local/lib/libbeidpkcs11.dylib");
            if (pkcs11File.exists()) {
                return pkcs11File.getAbsolutePath();
            }
            pkcs11File = new File("/usr/local/lib/beid-pkcs11.bundle/Contents/MacOS/libbeidpkcs11.dylib");
            if (pkcs11File.exists()) {
                return pkcs11File.getAbsolutePath();
            }
        } else {
            String[] libraryDirectories;
            File pkcs11File = new File("C:\\WINDOWS\\system32\\beidpkcs11.dll");
            if (pkcs11File.exists()) {
                return pkcs11File.getAbsolutePath();
            }
            pkcs11File = new File("C:\\WINDOWS\\system32\\Belgium Identity Card PKCS11.dll");
            if (pkcs11File.exists()) {
                return pkcs11File.getAbsolutePath();
            }
            pkcs11File = new File("C:\\WINNT\\system32\\Belgium Identity Card PKCS11.dll");
            if (pkcs11File.exists()) {
                return pkcs11File.getAbsolutePath();
            }
            pkcs11File = new File("C:\\WINNT\\system32\\beidpkcs11.dll");
            if (pkcs11File.exists()) {
                return pkcs11File.getAbsolutePath();
            }
            pkcs11File = new File("C:\\Windows\\SysWOW64\\beidpkcs11.dll");
            if (pkcs11File.exists()) {
                return pkcs11File.getAbsolutePath();
            }
            String javaLibraryPath = System.getProperty("java.library.path");
            String pathSeparator = System.getProperty("path.separator");
            for (String libraryDirectory : libraryDirectories = javaLibraryPath.split(pathSeparator)) {
                pkcs11File = new File(libraryDirectory + "\\beidpkcs11.dll");
                if (!pkcs11File.exists()) continue;
                return pkcs11File.getAbsolutePath();
            }
        }
        throw new PKCS11NotFoundException();
    }

    private PKCS11 loadPkcs11(String pkcs11Path) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException {
        try {
            Method getInstanceMethod = PKCS11.class.getMethod("getInstance", String.class, String.class, CK_C_INITIALIZE_ARGS.class, Boolean.TYPE);
            CK_C_INITIALIZE_ARGS ck_c_initialize_args = new CK_C_INITIALIZE_ARGS();
            PKCS11 pkcs11 = (PKCS11)getInstanceMethod.invoke(null, pkcs11Path, "C_GetFunctionList", ck_c_initialize_args, false);
            return pkcs11;
        }
        catch (NoSuchMethodException e) {
            this.view.addDetailMessage("PKCS11 getInstance Java 1.5 fallback");
            Method getInstanceMethod = PKCS11.class.getMethod("getInstance", String.class, CK_C_INITIALIZE_ARGS.class, Boolean.TYPE);
            PKCS11 pkcs11 = (PKCS11)getInstanceMethod.invoke(null, pkcs11Path, null, false);
            return pkcs11;
        }
    }

    public List<String> getReaderList() throws PKCS11NotFoundException, IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, PKCS11Exception, NoSuchFieldException {
        long[] slotIdxs;
        LinkedList<String> readerList = new LinkedList<String>();
        String pkcs11Path = this.getPkcs11Path();
        this.pkcs11 = this.loadPkcs11(pkcs11Path);
        for (long slotIdx : slotIdxs = this.pkcs11.C_GetSlotList(false)) {
            CK_SLOT_INFO slotInfo = this.pkcs11.C_GetSlotInfo(slotIdx);
            String reader = new String(slotInfo.slotDescription).trim();
            readerList.add(reader);
        }
        this.cFinalize();
        return readerList;
    }

    public boolean isEidPresent() throws IOException, PKCS11Exception, InterruptedException, NoSuchFieldException, IllegalAccessException, IllegalArgumentException, SecurityException, InvocationTargetException, NoSuchMethodException {
        String pkcs11Path = this.getPkcs11Path();
        this.view.addDetailMessage("PKCS#11 path: " + pkcs11Path);
        this.pkcs11 = this.loadPkcs11(pkcs11Path);
        CK_INFO ck_info = this.pkcs11.C_GetInfo();
        this.view.addDetailMessage("library description: " + new String(ck_info.libraryDescription).trim());
        this.view.addDetailMessage("manufacturer ID: " + new String(ck_info.manufacturerID).trim());
        this.view.addDetailMessage("library version: " + Integer.toString(ck_info.libraryVersion.major, 16) + "." + Integer.toString(ck_info.libraryVersion.minor, 16));
        this.view.addDetailMessage("cryptoki version: " + Integer.toString(ck_info.cryptokiVersion.major, 16) + "." + Integer.toString(ck_info.cryptokiVersion.minor, 16));
        long[] slotIdxs = this.pkcs11.C_GetSlotList(false);
        if (0 == slotIdxs.length) {
            this.view.addDetailMessage("no card readers connected?");
        }
        for (long slotIdx : slotIdxs) {
            CK_TOKEN_INFO tokenInfo;
            CK_SLOT_INFO slotInfo = this.pkcs11.C_GetSlotInfo(slotIdx);
            this.view.addDetailMessage("reader: " + new String(slotInfo.slotDescription).trim());
            if ((slotInfo.flags & 1L) == 0L) continue;
            try {
                tokenInfo = this.pkcs11.C_GetTokenInfo(slotIdx);
            }
            catch (PKCS11Exception e) {
                continue;
            }
            if (!new String(tokenInfo.label).startsWith("BELPIC")) continue;
            this.view.addDetailMessage("Belgium eID card in slot: " + slotIdx);
            this.slotIdx = slotIdx;
            this.slotDescription = new String(slotInfo.slotDescription).trim();
            return true;
        }
        this.cFinalize();
        return false;
    }

    public String getSlotDescription() {
        return this.slotDescription;
    }

    private void cFinalize() throws PKCS11Exception, NoSuchFieldException, IllegalAccessException {
        this.pkcs11.C_Finalize(null);
        Field moduleMapField = PKCS11.class.getDeclaredField("moduleMap");
        moduleMapField.setAccessible(true);
        Map moduleMap = (Map)moduleMapField.get(null);
        moduleMap.clear();
        this.pkcs11 = null;
    }

    public void waitForEidPresent() throws IOException, PKCS11Exception, InterruptedException, NoSuchFieldException, IllegalAccessException, IllegalArgumentException, SecurityException, InvocationTargetException, NoSuchMethodException {
        while (!this.isEidPresent()) {
            Thread.sleep(1000L);
        }
        return;
    }

    public KeyStore.PrivateKeyEntry getPrivateKeyEntry(String alias) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableEntryException {
        File tmpConfigFile = File.createTempFile("pkcs11-", "conf");
        tmpConfigFile.deleteOnExit();
        PrintWriter configWriter = new PrintWriter(new FileOutputStream(tmpConfigFile), true);
        configWriter.println("name=SmartCard");
        configWriter.println("library=" + this.getPkcs11Path());
        configWriter.println("slotListIndex= " + this.slotIdx);
        this.pkcs11Provider = new SunPKCS11(tmpConfigFile.getAbsolutePath());
        if (-1 == Security.addProvider(this.pkcs11Provider)) {
            throw new RuntimeException("could not add security provider");
        }
        KeyStore keyStore = KeyStore.getInstance("PKCS11", this.pkcs11Provider);
        Pkcs11LoadStoreParameter loadStoreParameter = new Pkcs11LoadStoreParameter(this.view, this.messages);
        keyStore.load(loadStoreParameter);
        Enumeration<String> aliases = keyStore.aliases();
        while (aliases.hasMoreElements()) {
            String currentAlias = aliases.nextElement();
            this.view.addDetailMessage("key alias: " + currentAlias);
        }
        KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(alias, null);
        if (null == privateKeyEntry) {
            throw new RuntimeException("private key entry for alias not found: " + alias);
        }
        return privateKeyEntry;
    }

    public KeyStore.PrivateKeyEntry getPrivateKeyEntry() throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableEntryException {
        KeyStore.PrivateKeyEntry privateKeyEntry = this.getPrivateKeyEntry("Authentication");
        return privateKeyEntry;
    }

    public byte[] signAuthn(byte[] toBeSigned) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableEntryException, InvalidKeyException, SignatureException {
        KeyStore.PrivateKeyEntry privateKeyEntry = this.getPrivateKeyEntry();
        PrivateKey privateKey = privateKeyEntry.getPrivateKey();
        X509Certificate[] certificateChain = (X509Certificate[])privateKeyEntry.getCertificateChain();
        this.authnCertificateChain = new LinkedList<X509Certificate>();
        for (X509Certificate certificate : certificateChain) {
            this.authnCertificateChain.add(certificate);
        }
        Signature signature = Signature.getInstance("SHA1withRSA");
        signature.initSign(privateKey);
        signature.update(toBeSigned);
        byte[] signatureValue = signature.sign();
        return signatureValue;
    }

    public List<X509Certificate> getAuthnCertificateChain() {
        return this.authnCertificateChain;
    }

    public List<X509Certificate> getSignCertificateChain() {
        return this.signCertificateChain;
    }

    public void close() throws PKCS11Exception, NoSuchFieldException, IllegalAccessException {
        if (null != this.pkcs11Provider) {
            Security.removeProvider(this.pkcs11Provider.getName());
            this.pkcs11Provider = null;
        }
        this.cFinalize();
    }

    public void removeCard() throws PKCS11Exception, InterruptedException {
        while (true) {
            CK_SLOT_INFO slotInfo = this.pkcs11.C_GetSlotInfo(this.slotIdx);
            if ((slotInfo.flags & 1L) == 0L) {
                return;
            }
            Thread.sleep(100L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] sign(byte[] digestValue, String digestAlgo) throws Exception {
        byte[] signatureValue;
        long session = this.pkcs11.C_OpenSession(this.slotIdx, 4L, null, null);
        try {
            long keyHandle;
            CK_ATTRIBUTE[] attributes = new CK_ATTRIBUTE[2];
            attributes[0] = new CK_ATTRIBUTE();
            attributes[0].type = 0L;
            attributes[0].pValue = 3L;
            attributes[1] = new CK_ATTRIBUTE();
            attributes[1].type = 3L;
            attributes[1].pValue = "Signature";
            this.pkcs11.C_FindObjectsInit(session, attributes);
            try {
                long[] keyHandles = this.pkcs11.C_FindObjects(session, 1L);
                if (0 == keyHandles.length) {
                    this.view.addDetailMessage("no PKCS#11 key handle for label \"Signature\"");
                    throw new RuntimeException("cannot sign via PKCS#11");
                }
                keyHandle = keyHandles[0];
                this.view.addDetailMessage("key handle: " + keyHandle);
            }
            finally {
                this.pkcs11.C_FindObjectsFinal(session);
            }
            CK_MECHANISM mechanism = new CK_MECHANISM();
            mechanism.mechanism = 1L;
            mechanism.pParameter = null;
            this.pkcs11.C_SignInit(session, mechanism, keyHandle);
            ByteArrayOutputStream digestInfo = new ByteArrayOutputStream();
            if ("SHA-1".equals(digestAlgo) || "SHA1".equals(digestAlgo)) {
                digestInfo.write(Constants.SHA1_DIGEST_INFO_PREFIX);
            } else if ("SHA-224".equals(digestAlgo)) {
                digestInfo.write(Constants.SHA224_DIGEST_INFO_PREFIX);
            } else if ("SHA-256".equals(digestAlgo)) {
                digestInfo.write(Constants.SHA256_DIGEST_INFO_PREFIX);
            } else if ("SHA-384".equals(digestAlgo)) {
                digestInfo.write(Constants.SHA384_DIGEST_INFO_PREFIX);
            } else if ("SHA-512".equals(digestAlgo)) {
                digestInfo.write(Constants.SHA512_DIGEST_INFO_PREFIX);
            } else if ("RIPEMD160".equals(digestAlgo)) {
                digestInfo.write(Constants.RIPEMD160_DIGEST_INFO_PREFIX);
            } else if ("RIPEMD128".equals(digestAlgo)) {
                digestInfo.write(Constants.RIPEMD128_DIGEST_INFO_PREFIX);
            } else if ("RIPEMD256".equals(digestAlgo)) {
                digestInfo.write(Constants.RIPEMD256_DIGEST_INFO_PREFIX);
            } else {
                throw new RuntimeException("digest also not supported: " + digestAlgo);
            }
            digestInfo.write(digestValue);
            signatureValue = this.pkcs11.C_Sign(session, digestInfo.toByteArray());
        }
        finally {
            this.pkcs11.C_CloseSession(session);
        }
        File tmpConfigFile = File.createTempFile("pkcs11-", "conf");
        tmpConfigFile.deleteOnExit();
        PrintWriter configWriter = new PrintWriter(new FileOutputStream(tmpConfigFile), true);
        configWriter.println("name=SmartCard");
        configWriter.println("library=" + this.getPkcs11Path());
        configWriter.println("slotListIndex= " + this.slotIdx);
        this.pkcs11Provider = new SunPKCS11(tmpConfigFile.getAbsolutePath());
        if (-1 == Security.addProvider(this.pkcs11Provider)) {
            throw new RuntimeException("could not add security provider");
        }
        KeyStore keyStore = KeyStore.getInstance("PKCS11", this.pkcs11Provider);
        keyStore.load(null, null);
        String alias = "Signature";
        KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(alias, null);
        if (null == privateKeyEntry) {
            throw new RuntimeException("private key entry for alias not found: " + alias);
        }
        X509Certificate[] certificateChain = (X509Certificate[])privateKeyEntry.getCertificateChain();
        this.signCertificateChain = new LinkedList<X509Certificate>();
        for (X509Certificate certificate : certificateChain) {
            this.signCertificateChain.add(certificate);
        }
        Security.removeProvider(this.pkcs11Provider.getName());
        this.pkcs11Provider = null;
        return signatureValue;
    }

    public void diagnosticTests(DiagnosticCallbackHandler diagnosticCallbackHandler) {
        CK_INFO ck_info;
        String pkcs11Path;
        try {
            pkcs11Path = this.getPkcs11Path();
        }
        catch (PKCS11NotFoundException e) {
            diagnosticCallbackHandler.addTestResult(DiagnosticTests.PKCS11_AVAILABLE, false, null);
            return;
        }
        diagnosticCallbackHandler.addTestResult(DiagnosticTests.PKCS11_AVAILABLE, true, pkcs11Path);
        try {
            this.pkcs11 = this.loadPkcs11(pkcs11Path);
        }
        catch (Exception e) {
            diagnosticCallbackHandler.addTestResult(DiagnosticTests.PKCS11_RUNTIME, false, e.getMessage());
            return;
        }
        try {
            ck_info = this.pkcs11.C_GetInfo();
        }
        catch (PKCS11Exception e) {
            diagnosticCallbackHandler.addTestResult(DiagnosticTests.PKCS11_RUNTIME, false, e.getMessage());
            return;
        }
        String libraryDescription = new String(ck_info.libraryDescription).trim();
        this.view.addDetailMessage("library description: " + libraryDescription);
        String manufacturerId = new String(ck_info.manufacturerID).trim();
        this.view.addDetailMessage("manufacturer ID: " + manufacturerId);
        String libraryVersion = Integer.toString(ck_info.libraryVersion.major, 16) + "." + Integer.toString(ck_info.libraryVersion.minor, 16);
        this.view.addDetailMessage("library version: " + libraryVersion);
        String cryptokiVersion = Integer.toString(ck_info.cryptokiVersion.major, 16) + "." + Integer.toString(ck_info.cryptokiVersion.minor, 16);
        this.view.addDetailMessage("cryptoki version: " + cryptokiVersion);
        String pkcs11Information = libraryDescription + ", " + manufacturerId + ", " + libraryVersion + ", " + cryptokiVersion;
        diagnosticCallbackHandler.addTestResult(DiagnosticTests.PKCS11_RUNTIME, true, pkcs11Information);
    }
}

